/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class MoreXDayFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private String prefixField;
    private int intervalDays;

    public MoreXDayFieldMapFunction(RowMeta rowMeta, String prefixField, int intervalDays) {
        this.rowMeta = rowMeta;
        this.prefixField = prefixField;
        this.intervalDays = intervalDays;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int baseqtyIndex = this.rowMeta.getFieldIndex("baseqty");
        BigDecimal baseqty = rowX.getBigDecimal(baseqtyIndex);
        int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
        BigDecimal standardamount = rowX.getBigDecimal(standardamountIndex);
        int actualamountIndex = this.rowMeta.getFieldIndex("actualamount");
        BigDecimal actualamount = rowX.getBigDecimal(actualamountIndex);
        int amountIndex = this.rowMeta.getFieldIndex("amount");
        rowX.set(amountIndex, (Object)standardamount.add(actualamount));
        BigDecimal totalRangeQty = BigDecimal.ZERO;
        BigDecimal totalRangeStandardamount = BigDecimal.ZERO;
        BigDecimal totalRangeCctualamount = BigDecimal.ZERO;
        for (int i = 0; i < this.intervalDays; ++i) {
            String prevPrefixField = "range" + i;
            int rangeqtyIndex = this.rowMeta.getFieldIndex(prevPrefixField + "qty");
            BigDecimal rangeqty = rowX.getBigDecimal(rangeqtyIndex);
            if (null == rangeqty) {
                rangeqty = BigDecimal.ZERO;
            }
            totalRangeQty = totalRangeQty.add(rangeqty);
            int rangestandardamountIndex = this.rowMeta.getFieldIndex(prevPrefixField + "standardamount");
            BigDecimal rangestandardamount = rowX.getBigDecimal(rangestandardamountIndex);
            if (null == rangestandardamount) {
                rangestandardamount = BigDecimal.ZERO;
            }
            totalRangeStandardamount = totalRangeStandardamount.add(rangestandardamount);
            int rangeactualamountIndex = this.rowMeta.getFieldIndex(prevPrefixField + "actualamount");
            BigDecimal rangeactualamount = rowX.getBigDecimal(rangeactualamountIndex);
            if (null == rangeactualamount) {
                rangeactualamount = BigDecimal.ZERO;
            }
            totalRangeCctualamount = totalRangeCctualamount.add(rangeactualamount);
            int rangeamountIndex = this.rowMeta.getFieldIndex(prevPrefixField + "amount");
            rowX.set(rangeamountIndex, (Object)rangestandardamount.add(rangeactualamount));
        }
        int rangeqtyLastIndex = this.rowMeta.getFieldIndex(this.prefixField + "qty");
        rowX.set(rangeqtyLastIndex, (Object)baseqty.subtract(totalRangeQty));
        int rangestandardamountLastIndex = this.rowMeta.getFieldIndex(this.prefixField + "standardamount");
        rowX.set(rangestandardamountLastIndex, (Object)standardamount.subtract(totalRangeStandardamount));
        int rangeactualamountLastIndex = this.rowMeta.getFieldIndex(this.prefixField + "actualamount");
        rowX.set(rangeactualamountLastIndex, (Object)actualamount.subtract(totalRangeCctualamount));
        int rangeamountLastIndex = this.rowMeta.getFieldIndex(this.prefixField + "amount");
        BigDecimal rangestandardamountLast = rowX.getBigDecimal(rangestandardamountLastIndex);
        BigDecimal rangeactualamountLast = rowX.getBigDecimal(rangeactualamountLastIndex);
        rowX.set(rangeamountLastIndex, (Object)rangestandardamountLast.add(rangeactualamountLast));
        return rowX;
    }
}

