/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.config.client.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class NewDealCalRangeMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private Set<Long> emptyRangeIdsSet;
    private Map<Long, String> dividebasisMap;
    private Map<Long, String> caldimensionMap;
    private RowMeta rowMeta;
    private Map<Long, String> calorgdiffcolMap;
    private Map<Long, Long> costAccountDividebasisMap;

    public NewDealCalRangeMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.emptyRangeIdsSet = reportParam.getEmptyRangeIdsSet();
        this.dividebasisMap = reportParam.getDividebasisMap();
        this.caldimensionMap = reportParam.getCaldimensionMap();
        this.rowMeta = rowMeta;
        this.calorgdiffcolMap = reportParam.getCalorgdiffcolMap();
        this.costAccountDividebasisMap = reportParam.getCostAccountDividebasisMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        String[] fieldNames;
        HashSet<String> fieldNamesSet = new HashSet<String>(16);
        for (String fieldName : fieldNames = this.rowMeta.getFieldNames()) {
            if (StringUtils.isBlank((String)fieldName)) continue;
            fieldNamesSet.add(fieldName);
        }
        int calrangeIndex = this.rowMeta.getFieldIndex("calrange");
        Long calRangeId = rowX.getLong(calrangeIndex);
        int dividebasisvalueIndex = this.rowMeta.getFieldIndex("dividebasisvalue");
        rowX.set(dividebasisvalueIndex, (Object)"0");
        int accounttypeIndex = this.rowMeta.getFieldIndex("accounttype");
        String accounttype = rowX.getString(accounttypeIndex);
        if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype) && this.emptyRangeIdsSet.contains(calRangeId)) {
            String dividebasisStr;
            int dividebasisIndex = this.rowMeta.getFieldIndex("dividebasis");
            Long dividebasisid = rowX.getLong(dividebasisIndex);
            if (null == dividebasisid || dividebasisid == 0L) {
                int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
                Long costaccountId = rowX.getLong(costaccountIndex);
                if (this.costAccountDividebasisMap != null && (dividebasisid = this.costAccountDividebasisMap.get(costaccountId)) != null && dividebasisid != 0L) {
                    rowX.set(dividebasisIndex, (Object)dividebasisid);
                }
            }
            if (!StringUtils.isEmpty((String)(dividebasisStr = this.dividebasisMap.get(dividebasisid)))) {
                String[] dividebasiss = dividebasisStr.split(",");
                StringBuilder dividebasisSb = new StringBuilder();
                for (String dividebasis : dividebasiss) {
                    int fieldIndex;
                    Object value;
                    String valueStr;
                    if (!fieldNamesSet.contains(dividebasis) || StringUtils.isEmpty((String)(valueStr = String.valueOf(value = rowX.get(fieldIndex = this.rowMeta.getFieldIndex(dividebasis)))))) continue;
                    dividebasisSb.append(valueStr);
                    dividebasisSb.append(",");
                }
                if (dividebasisSb.length() > 0) {
                    rowX.set(dividebasisvalueIndex, (Object)dividebasisSb.substring(0, dividebasisSb.length() - 1));
                }
            }
        }
        int caldimensionIndex = this.rowMeta.getFieldIndex("caldimension");
        Long caldimensionid = rowX.getLong(caldimensionIndex);
        int caldimensionvalueIndex = this.rowMeta.getFieldIndex("caldimensionvalue");
        rowX.set(caldimensionvalueIndex, (Object)"0");
        String caldimensionStr = null;
        if (AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype)) {
            int calorgIndex = this.rowMeta.getFieldIndex("calorg");
            Long calorgId = rowX.getLong(calorgIndex);
            caldimensionStr = this.calorgdiffcolMap.get(calorgId);
        } else {
            caldimensionStr = this.caldimensionMap.get(caldimensionid);
        }
        if (!StringUtils.isEmpty((String)caldimensionStr)) {
            String[] caldimensions = caldimensionStr.split(",");
            StringBuilder caldimensionsSb = new StringBuilder();
            for (String caldimension : caldimensions) {
                int fieldIndex;
                Object value;
                String valueStr;
                if (!fieldNamesSet.contains(caldimension) || StringUtils.isEmpty((String)(valueStr = String.valueOf(value = rowX.get(fieldIndex = this.rowMeta.getFieldIndex(caldimension)))))) continue;
                caldimensionsSb.append(valueStr);
                caldimensionsSb.append(",");
            }
            if (caldimensionsSb.length() > 0) {
                rowX.set(caldimensionvalueIndex, (Object)caldimensionsSb.substring(0, caldimensionsSb.length() - 1));
            }
        }
        return rowX;
    }
}

