/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CalcKeyHelper;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class StandardCostPriceMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<String, String> materialDimensionMap;
    private Set<Long> hasMultifactoryOrg;
    private Map<String, Long> orgCostTypeMap;

    public StandardCostPriceMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.rowMeta = rowMeta;
        this.materialDimensionMap = reportParam.getMaterialDimensionMap();
        this.hasMultifactoryOrg = reportParam.getHasMultifactoryOrg();
        this.orgCostTypeMap = reportParam.getOrgCostTypeMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        String costTypeKey;
        String dividebasisStr;
        String[] fieldNames;
        HashSet<String> fieldNamesSet = new HashSet<String>(16);
        for (String fieldName : fieldNames = this.rowMeta.getFieldNames()) {
            if (StringUtils.isBlank((String)fieldName)) continue;
            fieldNamesSet.add(fieldName);
        }
        int calorgIndex = this.rowMeta.getFieldIndex("calorg");
        Long calorgId = rowX.getLong(calorgIndex);
        int costaccountIndex = this.rowMeta.getFieldIndex("costaccount");
        Long costaccountId = rowX.getLong(costaccountIndex);
        int materialIndex = this.rowMeta.getFieldIndex("material");
        Long materialId = rowX.getLong(materialIndex);
        String orgKey = calorgId + "_" + costaccountId;
        if (this.hasMultifactoryOrg.contains(calorgId)) {
            int storageorgunitIndex = this.rowMeta.getFieldIndex("storageorg");
            Long storageorgunit = rowX.getLong(storageorgunitIndex);
            orgKey = orgKey + "_" + storageorgunit;
        }
        Long costType = this.orgCostTypeMap.get(orgKey);
        HashMap<String, Object> keyColMap = new HashMap<String, Object>(16);
        if (costType != null && costType != 0L && !StringUtils.isEmpty((String)(dividebasisStr = this.materialDimensionMap.get(costTypeKey = costType + "_" + materialId)))) {
            String[] dividebasiss;
            for (String dividebasis : dividebasiss = dividebasisStr.split(",")) {
                if (!fieldNamesSet.contains(dividebasis)) continue;
                int fieldIndex = this.rowMeta.getFieldIndex(dividebasis);
                Object value = rowX.get(fieldIndex);
                if (null == value || String.valueOf(value).equals("0")) break;
                if ("assist".equals(dividebasis)) {
                    keyColMap.put("auxproperty", value);
                    continue;
                }
                if ("mversion".equals(dividebasis)) {
                    keyColMap.put("matvers", value);
                    continue;
                }
                keyColMap.put(dividebasis, value);
            }
        }
        if (!keyColMap.isEmpty()) {
            String keyCol = CalcKeyHelper.getCalcKey(keyColMap);
            int materialstandkeycol = this.rowMeta.getFieldIndex("materialstandkeycol");
            if (!StringUtils.isEmpty((String)keyCol)) {
                rowX.set(materialstandkeycol, (Object)keyCol);
            }
        }
        return rowX;
    }
}

