/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;

public class StandardpriceMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, Boolean> containDiffermap;

    public StandardpriceMapFunction(RowMeta rowMeta, StockAgeReportBplatParam reportParam) {
        this.rowMeta = rowMeta;
        this.containDiffermap = reportParam.getContainDiffermap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        int calorgIndex = this.rowMeta.getFieldIndex("calorg");
        Long calorgId = rowX.getLong(calorgIndex);
        boolean isContainDiffer = false;
        if (this.containDiffermap.containsKey(calorgId)) {
            isContainDiffer = this.containDiffermap.get(calorgId);
        }
        if (!isContainDiffer) {
            int standardamountIndex = this.rowMeta.getFieldIndex("standardamount");
            int standardbaseqtyIndex = this.rowMeta.getFieldIndex("standardbaseqty");
            BigDecimal standardbaseqty = rowX.getBigDecimal(standardbaseqtyIndex);
            int standardpriceIndex = this.rowMeta.getFieldIndex("standardprice");
            BigDecimal standardprice = rowX.getBigDecimal(standardpriceIndex);
            if (standardbaseqty != null && standardprice != null) {
                rowX.set(standardamountIndex, (Object)standardbaseqty.multiply(standardprice));
            } else {
                rowX.set(standardamountIndex, (Object)BigDecimal.ZERO);
            }
        }
        return rowX;
    }
}

