/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockagelrpt.handle;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.report.newreport.base.NewReportDataHelper;
import kd.fi.cal.report.newreport.stockagelrpt.StandardRangePriceDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportBplatParam;
import kd.fi.cal.report.newreport.stockagelrpt.StockAgeReportUtil;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.AddSumClassGroupFieldDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CalBalPerPeriodEndFieldDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CalBalancePerPeriodEndFieldDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CalInitBillFieldDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CostAdjustBillFieldUnionDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CostRecordFieldUnUnionDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CostRecordFieldUnionDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.CostcostdiffBillFieldUnionDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.NewBuildSumDataxTransform;
import kd.fi.cal.report.newreport.stockagelrpt.dataxtransform.UpdateUnionFlagDataxTransform;

public class StockAgeSumReportHandle
implements IReportDataHandle {
    private static final String COSTRECORD = "costrecord";
    private static final String BALANCE = "balance";
    private Set<Long> notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
    private static final LocaleString locale_qty = new LocaleString(StockAgeSumReportHandle.getLocale_qty());
    private static final LocaleString locale_amount = new LocaleString(StockAgeSumReportHandle.getLocale_amount());
    private static final LocaleString width = new LocaleString("100px");
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private StockAgeReportBplatParam reportParam;

    private static String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockAgeRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public static String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockAgeRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (StockAgeReportBplatParam)ctx.getParam(StockAgeReportBplatParam.class.getName());
        this.reportParam.setFilterFields(StockAgeReportUtil.getFilterfields(ctx.getShowKeyCols(), this.reportParam));
        ctx.getShowKeyCols().add("calrange");
        ctx.getShowKeyCols().add("materialnumber");
        ctx.getShowKeyCols().add("materialmodel");
        ctx.getShowKeyCols().add("baseunit");
        ctx.getShowKeyCols().add("currency");
        ctx.getShowKeyCols().add("amtprecision");
        HashSet<String> groupUnionStrSet = new HashSet<String>(16);
        groupUnionStrSet.addAll(ctx.getShowKeyCols());
        this.reportParam.setGroupUnionStrSet(groupUnionStrSet);
        ctx.getShowKeyCols().add("datatype");
        ctx.getShowKeyCols().add("unionflag");
        ctx.getShowKeyCols().add("bizbillentryid");
        ctx.getShowKeyCols().add("billtype");
        ctx.getShowKeyCols().add("bookdate");
        ctx.getShowKeyCols().add("warehouse");
        ctx.getShowKeyCols().add("group");
        ctx.getShowKeyCols().add("location");
        ctx.getShowKeyCols().add("owner");
        ctx.getShowKeyCols().add("storageorg");
        ctx.getShowKeyCols().add("calbilltype");
        ctx.getShowKeyCols().add("assist");
        ctx.getShowKeyCols().add("configuredcode");
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        if (ctx.getCommonFs() != null) {
            this.reportParam.setCommonFilter(ctx.getCommonFs());
        } else {
            this.reportParam.setCommonFilter(null);
        }
        ctx.setCommonFs(null);
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        List<QFilter> list = this.reportParam.getBalanceHeadFilters();
        if (list != null && list.size() > 0) {
            for (QFilter qFilter : list) {
                String property = qFilter.getProperty();
                if ("materialnumber".equals(property)) {
                    qFilter.__setProperty("material.number");
                } else if ("materialmodel".equals(property)) {
                    qFilter.__setProperty("material.modelnum");
                }
                fs.add(qFilter);
            }
        }
        return fs;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        ArrayList<SrcBlockConf> resultBalanceSrcBlocks = new ArrayList<SrcBlockConf>();
        ArrayList<SrcBlockConf> resultBalSrcBlocks = new ArrayList<SrcBlockConf>();
        for (SrcBlockConf blockConf : blockCollector) {
            Map repoColFullSrcColMap;
            Map srcColMap;
            srcEntity = blockConf.getSrcEntity();
            blockConf.setUserFs(this.reportParam.getCommonFilter());
            if ("cal_balance".equals(srcEntity) && !this.isNewBalance) {
                this.setCalBalanceSrcBlockConf(ctx, resultBalanceSrcBlocks, blockConf);
                continue;
            }
            if ("cal_bal".equals(srcEntity) && this.isNewBalance) {
                NewReportDataHelper.addNewBalDimCols(ctx, blockConf, this.reportParam);
                this.setCalBalSrcBlockConf(ctx, resultBalSrcBlocks, blockConf);
                continue;
            }
            if ("cal_costrecord_subentity".equals(srcEntity)) {
                srcColMap = blockConf.getRepoColSrcColMap();
                srcColMap.put("noupdatecalfields", "noupdatecalfields");
                blockConf.setRepoColSrcColMap(srcColMap);
                repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                repoColFullSrcColMap.put("noupdatecalfields", "entry.noupdatecalfields");
                blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                this.setCalCostRecordSrcBlockConf(ctx, resultBalanceSrcBlocks, resultBalSrcBlocks, blockConf);
                continue;
            }
            if ("cal_costadjustbill".equals(srcEntity)) {
                srcColMap = blockConf.getRepoColSrcColMap();
                srcColMap.put("noupdatecalfields", "noupdatecalfields");
                blockConf.setRepoColSrcColMap(srcColMap);
                repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                repoColFullSrcColMap.put("noupdatecalfields", "entryentity.noupdatecalfields");
                blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                this.setCalCostAdjuestBillSrcBlockConf(ctx, resultBalanceSrcBlocks, resultBalSrcBlocks, blockConf);
                continue;
            }
            if ("cal_stdcostdiffbill".equals(srcEntity)) {
                srcColMap = blockConf.getRepoColSrcColMap();
                srcColMap.put("noupdatecalfields", "noupdatecalfields");
                blockConf.setRepoColSrcColMap(srcColMap);
                repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
                repoColFullSrcColMap.put("noupdatecalfields", "entryentity.noupdatecalfields");
                blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
                this.setCalCostdiffbillSrcBlockConf(ctx, resultBalanceSrcBlocks, resultBalSrcBlocks, blockConf);
                continue;
            }
            if (!"cal_initbill".equals(srcEntity)) continue;
            srcColMap = blockConf.getRepoColSrcColMap();
            srcColMap.put("noupdatecalfields", "noupdatecalfields");
            blockConf.setRepoColSrcColMap(srcColMap);
            repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.put("noupdatecalfields", "entryentity.noupdatecalfields");
            blockConf.setRepoColFullSrcColMap(repoColFullSrcColMap);
            this.setCalInitBillSrcBlockConf(ctx, resultBalanceSrcBlocks, resultBalSrcBlocks, blockConf);
        }
        if (this.isNewBalance) {
            ctx.getReportConf().setSrcBlockConf(resultBalSrcBlocks);
        } else {
            ctx.getReportConf().setSrcBlockConf(resultBalanceSrcBlocks);
        }
    }

    private void setCalInitBillSrcBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalanceSrcBlocks, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf) {
        QFilter dataFs = blockConf.getDataFs();
        QFilter q = StockAgeReportUtil.getCostAdjustFilter(this.reportParam);
        String ageField = (String)blockConf.getRepoColFullSrcColMap().get("bookdate");
        q.and(ageField, "<=", (Object)this.reportParam.getEndDate());
        q.and(ageField, ">=", (Object)this.reportParam.getIntervalStartDate());
        if (dataFs != null) {
            dataFs.and(q);
            blockConf.setDataFs(dataFs);
        } else {
            blockConf.setDataFs(q);
        }
        List dataXTransforms = blockConf.getDataTransform();
        if (dataXTransforms != null) {
            dataXTransforms.add(new CalInitBillFieldDataxTransform(this.reportParam));
        }
        blockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(blockConf);
        resultBalSrcBlocks.add(blockConf);
    }

    private void setCalCostAdjuestBillSrcBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalanceSrcBlocks, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf) {
        QFilter commonFilter = StockAgeReportUtil.getCostAdjustFilter(this.reportParam);
        if (this.reportParam.getMaterialIds() != null && this.reportParam.getMaterialIds().size() > 0) {
            commonFilter.and("entryentity.material", "in", this.reportParam.getMaterialIds());
        }
        commonFilter.and("isupdatecost", "=", (Object)"1");
        commonFilter.and("difftype", "=", (Object)Character.valueOf('B'));
        QFilter unionTwoQfilter = new QFilter("bookdate", ">=", (Object)this.reportParam.getStartDate());
        unionTwoQfilter.and("bookdate", "<=", (Object)this.reportParam.getEndDate());
        unionTwoQfilter.and(commonFilter);
        SrcBlockConf unionTwoFlagblockConf = new SrcBlockConf();
        unionTwoFlagblockConf.setDefVals(blockConf.getDefVals());
        unionTwoFlagblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        unionTwoFlagblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        unionTwoFlagblockConf.setSrcEntity(blockConf.getSrcEntity());
        unionTwoFlagblockConf.setType(blockConf.getType());
        QFilter unionTwodataFs = unionTwoFlagblockConf.getDataFs();
        if (unionTwodataFs != null) {
            unionTwoQfilter.and(unionTwodataFs);
        }
        unionTwoFlagblockConf.setDataFs(unionTwoQfilter);
        List dataXTransforms3 = unionTwoFlagblockConf.getDataTransform();
        if (dataXTransforms3 != null) {
            dataXTransforms3.add(new CostAdjustBillFieldUnionDataxTransform(this.reportParam));
            dataXTransforms3.add(new UpdateUnionFlagDataxTransform(2));
        }
        unionTwoFlagblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(unionTwoFlagblockConf);
        resultBalSrcBlocks.add(unionTwoFlagblockConf);
    }

    private void setCalCostdiffbillSrcBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalanceSrcBlocks, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf) {
        QFilter commonFilter = StockAgeReportUtil.getCostAdjustFilter(this.reportParam);
        if (this.reportParam.getMaterialIds() != null && this.reportParam.getMaterialIds().size() > 0) {
            commonFilter.and("entryentity.material", "in", this.reportParam.getMaterialIds());
        }
        commonFilter.and("isupdatecost", "=", (Object)"1");
        QFilter unionTwoQfilter = new QFilter("bookdate", ">=", (Object)this.reportParam.getStartDate());
        unionTwoQfilter.and("bookdate", "<=", (Object)this.reportParam.getEndDate());
        unionTwoQfilter.and(commonFilter);
        SrcBlockConf unionTwoFlagblockConf = new SrcBlockConf();
        unionTwoFlagblockConf.setDefVals(blockConf.getDefVals());
        unionTwoFlagblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        unionTwoFlagblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        unionTwoFlagblockConf.setSrcEntity(blockConf.getSrcEntity());
        unionTwoFlagblockConf.setType(blockConf.getType());
        QFilter unionTwodataFs = unionTwoFlagblockConf.getDataFs();
        if (unionTwodataFs != null) {
            unionTwoQfilter.and(unionTwodataFs);
        }
        unionTwoFlagblockConf.setDataFs(unionTwoQfilter);
        List dataXTransforms3 = unionTwoFlagblockConf.getDataTransform();
        if (dataXTransforms3 != null) {
            dataXTransforms3.add(new CostcostdiffBillFieldUnionDataxTransform(this.reportParam));
            dataXTransforms3.add(new UpdateUnionFlagDataxTransform(2));
        }
        unionTwoFlagblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(unionTwoFlagblockConf);
        resultBalSrcBlocks.add(unionTwoFlagblockConf);
    }

    private void setCalCostRecordSrcBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalanceSrcBlocks, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf) {
        QFilter commonFilter = StockAgeReportUtil.buildShowDataFilter(COSTRECORD, this.reportParam);
        commonFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        commonFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
        commonFilter.and("biztype", "not in", this.notUpdBalBizType);
        commonFilter.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        commonFilter.and(billStatusf);
        String ageField = (String)blockConf.getRepoColFullSrcColMap().get("bookdate");
        QFilter unUnionQfilter = new QFilter(ageField, "<=", (Object)this.reportParam.getEndDate());
        unUnionQfilter.and(ageField, ">=", (Object)this.reportParam.getIntervalStartDate());
        if (this.reportParam.getMaterialIds() != null && this.reportParam.getMaterialIds().size() > 0) {
            unUnionQfilter.and("entry.material", "in", this.reportParam.getMaterialIds());
        }
        QFilter billTypeFilter = QFilter.of((String)"calbilltype = 'IN' and entry.baseqty > 0", (Object[])new Object[0]);
        billTypeFilter.or(QFilter.of((String)"calbilltype = 'OUT' and entry.baseqty < 0", (Object[])new Object[0]));
        unUnionQfilter.and(billTypeFilter);
        unUnionQfilter.and(commonFilter);
        SrcBlockConf unUnionblockConf = new SrcBlockConf();
        unUnionblockConf.setDefVals(blockConf.getDefVals());
        unUnionblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        unUnionblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        unUnionblockConf.setSrcEntity(blockConf.getSrcEntity());
        unUnionblockConf.setType(blockConf.getType());
        unUnionblockConf.setUserFs(this.reportParam.getCommonFilter());
        QFilter unUniondataFs = unUnionblockConf.getDataFs();
        if (unUniondataFs != null) {
            unUnionQfilter.and(unUniondataFs);
        }
        unUnionblockConf.setDataFs(unUnionQfilter);
        List dataXTransforms2 = unUnionblockConf.getDataTransform();
        if (dataXTransforms2 != null) {
            dataXTransforms2.add(new CostRecordFieldUnUnionDataxTransform(this.reportParam));
        }
        unUnionblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(unUnionblockConf);
        resultBalSrcBlocks.add(unUnionblockConf);
        QFilter unionTwoQfilter = new QFilter("bookdate", "<=", (Object)new Timestamp(this.reportParam.getEndDate().getTime()));
        unionTwoQfilter.and("bookdate", ">=", (Object)this.reportParam.getStartDate());
        commonFilter = StockAgeReportUtil.buildFilterOnlyMaterial(COSTRECORD, this.reportParam);
        commonFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        commonFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
        commonFilter.and("biztype", "not in", this.notUpdBalBizType);
        commonFilter.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        commonFilter.and(billStatusf);
        unionTwoQfilter.and(commonFilter);
        SrcBlockConf unionFlagTwoblockConf = new SrcBlockConf();
        unionFlagTwoblockConf.setDefVals(blockConf.getDefVals());
        unionFlagTwoblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        unionFlagTwoblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        unionFlagTwoblockConf.setSrcEntity(blockConf.getSrcEntity());
        unionFlagTwoblockConf.setType(blockConf.getType());
        QFilter unionTwodataFs = unionFlagTwoblockConf.getDataFs();
        if (unionTwodataFs != null) {
            unionTwoQfilter.and(unionTwodataFs);
        }
        unionFlagTwoblockConf.setDataFs(unionTwoQfilter);
        List dataXTransforms3 = unionFlagTwoblockConf.getDataTransform();
        if (dataXTransforms3 != null) {
            dataXTransforms3.add(new CostRecordFieldUnionDataxTransform(this.reportParam, ctx));
            dataXTransforms3.add(new UpdateUnionFlagDataxTransform(2));
        }
        unionFlagTwoblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(unionFlagTwoblockConf);
        resultBalSrcBlocks.add(unionFlagTwoblockConf);
    }

    private void setCalBalSrcBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalSrcBlocks, SrcBlockConf blockConf) {
        QFilter dataFs = blockConf.getDataFs();
        QFilter unUnionq = StockAgeReportUtil.buildFilterOnlyMaterial(BALANCE, this.reportParam);
        unUnionq.and("period", "<", (Object)this.reportParam.getStartPeriod());
        unUnionq.and("endperiod", ">=", (Object)this.reportParam.getStartPeriod());
        unUnionq.and("invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        if (dataFs != null) {
            unUnionq = unUnionq.and(dataFs);
        }
        if (this.reportParam.getCommonFilter() != null) {
            QFilter unionq = StockAgeReportUtil.buildShowDataFilter(BALANCE, this.reportParam);
            unionq.and("period", "<=", (Object)this.reportParam.getStartPeriod());
            unionq.and("endperiod", ">", (Object)this.reportParam.getStartPeriod());
            unionq.and("invtype.isforwardamount", "=", (Object)Boolean.TRUE);
            if (dataFs != null) {
                unionq = unionq.and(dataFs);
            }
            blockConf.setDataFs(unionq);
            List dataXTransforms = blockConf.getDataTransform();
            if (dataXTransforms != null) {
                dataXTransforms.add(new UpdateUnionFlagDataxTransform(3));
            }
            blockConf.setAllowNotMatch(true);
            resultBalSrcBlocks.add(blockConf);
        }
        SrcBlockConf unUnionblockConf = new SrcBlockConf();
        unUnionblockConf.setDefVals(blockConf.getDefVals());
        unUnionblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        unUnionblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        unUnionblockConf.setSrcEntity(blockConf.getSrcEntity());
        unUnionblockConf.setType(blockConf.getType());
        unUnionblockConf.setDataFs(unUnionq);
        List dataXTransforms1 = unUnionblockConf.getDataTransform();
        if (dataXTransforms1 != null) {
            dataXTransforms1.add(new CalBalPerPeriodEndFieldDataxTransform(this.reportParam, ctx));
            dataXTransforms1.add(new UpdateUnionFlagDataxTransform(2));
        }
        unUnionblockConf.setAllowNotMatch(true);
        resultBalSrcBlocks.add(unUnionblockConf);
    }

    private void setCalBalanceSrcBlockConf(ReportDataCtx ctx, List<SrcBlockConf> resultBalanceSrcBlocks, SrcBlockConf blockConf) {
        QFilter dataFs = blockConf.getDataFs();
        QFilter unionq = StockAgeReportUtil.buildShowDataFilter(BALANCE, this.reportParam);
        unionq.and("period", "<=", (Object)this.reportParam.getStartPeriod());
        unionq.and("endperiod", ">", (Object)this.reportParam.getStartPeriod());
        unionq.and("invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        QFilter unUnionq = StockAgeReportUtil.buildFilterOnlyMaterial(BALANCE, this.reportParam);
        unUnionq.and("period", "<", (Object)this.reportParam.getStartPeriod());
        unUnionq.and("endperiod", ">=", (Object)this.reportParam.getStartPeriod());
        unUnionq.and("invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        if (dataFs != null) {
            unUnionq = unUnionq.and(dataFs);
            unionq = unionq.and(dataFs);
        }
        blockConf.setDataFs(unionq);
        if (this.reportParam.getCommonFilter() != null) {
            List dataXTransforms = blockConf.getDataTransform();
            if (dataXTransforms != null) {
                dataXTransforms.add(new UpdateUnionFlagDataxTransform(3));
            }
            blockConf.setAllowNotMatch(true);
            resultBalanceSrcBlocks.add(blockConf);
        }
        SrcBlockConf unUnionblockConf = new SrcBlockConf();
        unUnionblockConf.setDefVals(blockConf.getDefVals());
        unUnionblockConf.setRepoColFullSrcColMap(blockConf.getRepoColFullSrcColMap());
        unUnionblockConf.setRepoColSrcColMap(blockConf.getRepoColSrcColMap());
        unUnionblockConf.setSrcEntity(blockConf.getSrcEntity());
        unUnionblockConf.setType(blockConf.getType());
        unUnionblockConf.setDataFs(unUnionq);
        List dataXTransforms1 = unUnionblockConf.getDataTransform();
        if (dataXTransforms1 != null) {
            dataXTransforms1.add(new CalBalancePerPeriodEndFieldDataxTransform(this.reportParam, ctx));
            dataXTransforms1.add(new UpdateUnionFlagDataxTransform(2));
        }
        unUnionblockConf.setAllowNotMatch(true);
        resultBalanceSrcBlocks.add(unUnionblockConf);
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        String groupStr = StockAgeReportUtil.getCommonGroupBy(false, ctx.getShowKeyCols());
        String filterFields = this.reportParam.getFilterFields();
        if (!StringUtils.isEmpty((CharSequence)filterFields)) {
            groupStr = groupStr + "," + filterFields;
        }
        for (String group : groupStr.split(",")) {
            if (StringUtils.isEmpty((CharSequence)group)) continue;
            ctx.getShowKeyCols().add(group);
        }
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        ctx.getShowKeyCols().addAll(allKeyCols);
        ctx.getShowKeyCols().add("dividebasisvalue");
        ctx.getShowKeyCols().add("caldimensionvalue");
        ctx.getShowKeyCols().add("caldimension");
        ctx.getShowKeyCols().add("dividebasis");
        ctx.getShowKeyCols().add("accounttype");
        HashSet<String> groupUnUnionStrSet = new HashSet<String>(16);
        groupUnUnionStrSet.addAll(ctx.getShowKeyCols());
        this.reportParam.setGroupUnUnionStrSet(groupUnUnionStrSet);
        ctx.setGroupPlans(new GroupPlan((Collection)ctx.getShowKeyCols(), (Collection)ctx.getShowQtyCols()));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        boolean isAllContainDifferFalseCalOrg = StockAgeReportUtil.isAllContainDifferFalseCalOrg(this.reportParam);
        if (!isAllContainDifferFalseCalOrg) {
            transCollector.add(new StandardRangePriceDataxTransform(this.reportParam));
        }
        transCollector.add(new NewBuildSumDataxTransform(this.reportParam, ctx, this.notUpdBalBizType));
        transCollector.add(new AddSumClassGroupFieldDataxTransform(this.reportParam));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set allKeyColsA = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        Set allKeyColsB = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "B".equals(colConf.getCalType()));
        Set allKeyColsC = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "C".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyColsA);
        repoColFilter.addAll(allKeyColsB);
        repoColFilter.addAll(allKeyColsC);
        repoColFilter.addAll(this.reportParam.getOtherBalDims());
        repoColFilter.add("noupdatecalfields");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        Map<String, String> rangeColumns = this.getFieldKey(this.reportParam.getSbInvageGroup(), "range");
        this.addColums(cols, rangeColumns);
        for (AbstractReportColumn col : cols) {
            ReportColumn column;
            if (!(col instanceof ReportColumn) || !"currency".equals((column = (ReportColumn)col).getFieldKey()) && !"amtprecision".equals(column.getFieldKey())) continue;
            column.setHide(true);
        }
        return cols;
    }

    private Map<String, String> getFieldKey(StringBuffer sbInvageGroup, String setFieldKeyPrefix) {
        if (sbInvageGroup == null) {
            return null;
        }
        String[] captions = sbInvageGroup.toString().split(",");
        if (captions.length == 0) {
            return null;
        }
        int length = captions.length;
        TreeMap<String, String> fieldKeyAndNameMap = new TreeMap<String, String>();
        for (int i = 0; i < length; ++i) {
            fieldKeyAndNameMap.put(setFieldKeyPrefix + i, captions[i]);
        }
        return fieldKeyAndNameMap;
    }

    private List<AbstractReportColumn> addColums(List<AbstractReportColumn> columns, Map<String, String> fieldKeyAndNameMap) {
        ReportColumn amount = new ReportColumn();
        amount.setCaption(locale_amount);
        amount.setWidth(width);
        amount.setFieldKey("amount");
        amount.setFieldType("amount");
        amount.setZeroShow(false);
        amount.setNoDisplayScaleZero(false);
        amount.setCurrencyField("currency");
        columns.add((AbstractReportColumn)amount);
        if (fieldKeyAndNameMap != null) {
            String prefix = "range";
            for (int i = 0; i < fieldKeyAndNameMap.size(); ++i) {
                String entryKey = prefix + i;
                String entryVal = fieldKeyAndNameMap.get(entryKey);
                ReportColumnGroup groupCol = new ReportColumnGroup();
                groupCol.setCaption(new LocaleString(entryVal));
                groupCol.setFieldKey(entryKey);
                columns.add((AbstractReportColumn)groupCol);
                ReportColumn qty = new ReportColumn();
                qty.setCaption(locale_qty);
                qty.setWidth(width);
                qty.setFieldKey(entryKey + "qty");
                qty.setFieldType("qty");
                qty.setZeroShow(false);
                qty.setNoDisplayScaleZero(false);
                qty.setMeasureUnitField("baseunit");
                ReportColumn actualAmount = new ReportColumn();
                actualAmount.setCaption(locale_amount);
                actualAmount.setWidth(width);
                actualAmount.setFieldKey(entryKey + "amount");
                actualAmount.setFieldType("amount");
                actualAmount.setZeroShow(false);
                actualAmount.setNoDisplayScaleZero(false);
                actualAmount.setCurrencyField("currency");
                groupCol.getChildren().add(qty);
                groupCol.getChildren().add(actualAmount);
            }
        }
        return columns;
    }
}

