/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class StockCostGatherQueryHelper {
    public static QFilter getFilter(StockCostGatherRptParam reportParam, boolean balanceHeadFilter) {
        List<QFilter> list;
        HashSet<Long> set;
        Set<Long> warehsGroupSet;
        HashSet<Object> set2;
        Set<Long> costaccountIdSet = reportParam.getCostaccountIdSet();
        QFilter q = new QFilter("costaccount", "in", costaccountIdSet);
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        q.and("ownertype", "=", (Object)"bos_org");
        DynamicObjectCollection owner = reportParam.getOwnerFrom();
        if (owner != null && !owner.isEmpty()) {
            set2 = new HashSet<Object>(owner.size());
            for (DynamicObject info : owner) {
                set2.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("owner", "in", set2);
        } else {
            HashSet<Long> acctOwnerIds = new HashSet<Long>(16);
            for (Long costaccountId : costaccountIdSet) {
                Long[] owners = AccountingSysHelper.getOwners((Long)costaccountId);
                acctOwnerIds.addAll(Arrays.asList(owners));
            }
            q.and("owner", "in", acctOwnerIds);
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            set2 = new HashSet(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("storageorgunit", "in", set2);
        }
        if (!(warehsGroupSet = StockCostGatherQueryHelper.getWarehsGroupSet(reportParam)).isEmpty()) {
            q.and("warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && !reportParam.getWarehouse().isEmpty()) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && !reportParam.getLocation().isEmpty()) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("location", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && !reportParam.getMaterialFrom().isEmpty()) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("material", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMultracknumber() != null && !reportParam.getMultracknumber().isEmpty()) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getMultracknumber()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("tracknumber", "in", set);
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (reportParam.getMatcategory() != null && reportParam.getMatcategory().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getMatcategory()) {
                set.add(info.getLong("id"));
            }
            q.and("materialcategory", "in", set);
        }
        if (balanceHeadFilter && (list = reportParam.getBalanceHeadFilters()) != null && !list.isEmpty()) {
            for (QFilter qFilter : list) {
                q.and(qFilter);
            }
        }
        return q;
    }

    private static Set<Long> getWarehsGroupSet(StockCostGatherRptParam reportParam) {
        HashSet<Long> warehsGroupSet = new HashSet<Long>(8);
        DynamicObjectCollection filter_warehsgroup = reportParam.getMulwarehsgroup();
        if (filter_warehsgroup != null) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (DynamicObject info : filter_warehsgroup) {
                warehsGroupSet.add(info.getDynamicObject("fbasedataid").getLong("id"));
                warehsGroupF.or("longnumber", "like", (Object)(info.getDynamicObject("fbasedataid").getString("longnumber") + "%"));
            }
            if (!warehsGroupSet.isEmpty()) {
                DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
                for (DynamicObject warehsGroup : warehsGroupColl) {
                    warehsGroupSet.add(warehsGroup.getLong("id"));
                }
            }
        } else if (reportParam.isOnlyqueryemptygroup()) {
            warehsGroupSet.add(0L);
        }
        return warehsGroupSet;
    }

    public static List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stockcoststd_col_repo");
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>(16);
        if (headFilters != null) {
            for (QFilter q : headFilters) {
                String property = q.getProperty();
                IDataEntityProperty p = entityType.findProperty(property);
                if (null == p) continue;
                if (p instanceof BasedataProp) {
                    String field = ((BasedataProp)p).getDisplayProp();
                    property = property + "." + field;
                }
                q.__setProperty(property);
                List nests = q.getNests(true);
                for (QFilter.QFilterNest net : nests) {
                    QFilter netFilter = net.getFilter();
                    StockCostGatherQueryHelper.rebuildBalanceHeadFilter(netFilter, entityType);
                }
                newHeadFilters.add(q);
            }
        }
        return newHeadFilters;
    }

    private static void rebuildBalanceHeadFilter(QFilter filter, MainEntityType entityType) {
        String property = filter.getProperty();
        IDataEntityProperty p = entityType.findProperty(property);
        if (null == p) {
            return;
        }
        if (p instanceof BasedataProp) {
            String field = ((BasedataProp)p).getDisplayProp();
            property = property + "." + field;
        }
        filter.__setProperty(property);
    }

    public static boolean hasGroupByName(Set<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    public static StockCostGatherRptParam buildRptParam(DynamicObject dataEntity, String colsStr, ReportQueryParam queryParam) {
        StockCostGatherRptParam rptParam = new StockCostGatherRptParam();
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (Iterator calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            rptParam.setCalorgIdSet(calOrgIds);
        }
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        HashSet<Long> costaccountIdSet = new HashSet<Long>(costaccounts.size());
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        rptParam.setCostaccountIdSet(costaccountIdSet);
        Map costAccountStartPeriodMap = PeriodHelper.getStartPeriods(costaccountIdSet);
        rptParam.setCostAccountStartPeriodMap(costAccountStartPeriodMap);
        Date startdate = dataEntity.getDate("startdate");
        rptParam.setStartdate(startdate);
        Date enddate = DateUtils.getDayEndTime((Date)dataEntity.getDate("enddate"));
        rptParam.setEnddate(enddate);
        DynamicObjectCollection mulowner = dataEntity.getDynamicObjectCollection("mulowner");
        rptParam.setOwnerFrom(mulowner);
        DynamicObjectCollection mulstorageorg = dataEntity.getDynamicObjectCollection("mulstorageorg");
        rptParam.setStorageOrg(mulstorageorg);
        DynamicObjectCollection mulwarehsgroup = dataEntity.getDynamicObjectCollection("mulwarehsgroup");
        rptParam.setMulwarehsgroup(mulwarehsgroup);
        DynamicObjectCollection mulwarehouse = dataEntity.getDynamicObjectCollection("mulwarehouse");
        rptParam.setWarehouse(mulwarehouse);
        DynamicObjectCollection mullocation = dataEntity.getDynamicObjectCollection("mullocation");
        rptParam.setLocation(mullocation);
        DynamicObject materialgroupstandard = dataEntity.getDynamicObject("materialgroupstandard");
        rptParam.setMaterialgroupstandard(materialgroupstandard);
        DynamicObjectCollection mulmaterialgroup = dataEntity.getDynamicObjectCollection("mulmaterialgroup");
        rptParam.setMulmaterialgroup(mulmaterialgroup);
        DynamicObjectCollection mulmatcategory = dataEntity.getDynamicObjectCollection("mulmatcategory");
        rptParam.setMatcategory(mulmatcategory);
        boolean notShowMaterialGroup = materialgroupstandard == null && (mulmaterialgroup == null || mulmaterialgroup.size() < 1);
        rptParam.setNotShowMaterialGroup(notShowMaterialGroup);
        DynamicObjectCollection mulmaterial = dataEntity.getDynamicObjectCollection("mulmaterial");
        rptParam.setMaterialFrom(mulmaterial);
        DynamicObject materialto = dataEntity.getDynamicObject("materialto");
        rptParam.setMaterialTo(materialto);
        DynamicObjectCollection multracknumber = dataEntity.getDynamicObjectCollection("multracknum");
        rptParam.setMultracknumber(multracknumber);
        DynamicObjectCollection showreceiver = dataEntity.getDynamicObjectCollection("showreceiver");
        rptParam.setShowReceiver(showreceiver);
        String showspecialbill = dataEntity.getString("showspecialbill");
        rptParam.setShowSpecialBill(showspecialbill);
        String qtyshowcondition = dataEntity.getString("qtyshowcondition");
        rptParam.setQtyShowCondition(qtyshowcondition);
        String amountshowcondition = dataEntity.getString("amountshowcondition");
        rptParam.setAmountShowCondition(amountshowcondition);
        boolean displayin = dataEntity.getBoolean("displayin");
        rptParam.setDisPlayIn(displayin);
        boolean displayout = dataEntity.getBoolean("displayout");
        rptParam.setDisPlayOut(displayout);
        boolean noshowzeroinout = dataEntity.getBoolean("noshowzeroinout");
        rptParam.setNoShowZeroInOut(noshowzeroinout);
        boolean showallzero = dataEntity.getBoolean("showallzero");
        rptParam.setShowAllZero(showallzero);
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        rptParam.setOnlyShowSumRow(onlyshowsumrow);
        boolean topsumrow = dataEntity.getBoolean("topsumrow");
        rptParam.setTopSumRow(topsumrow);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        rptParam.setNewBalance(isNewBalance);
        String[] showKeyCols = colsStr.split(",");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stockcoststd_col_repo");
        HashMap<String, IDataEntityProperty> dataEntityPropertyMap = new HashMap<String, IDataEntityProperty>();
        for (String showKeyCol : showKeyCols) {
            if (StringUtils.isEmpty((String)showKeyCol)) continue;
            IDataEntityProperty property = entityType.findProperty(showKeyCol);
            dataEntityPropertyMap.put(showKeyCol, property);
        }
        rptParam.setDataEntityPropertyMap(dataEntityPropertyMap);
        Set notUpdBalBizTypes = CommonSettingHelper.getNotUpdBalBizType();
        rptParam.setNotUpdBalBizTypes(notUpdBalBizTypes);
        StockCostGatherQueryHelper.initRecAndSeds(dataEntity, rptParam);
        rptParam.setShowTotalQty(dataEntity.getBoolean("showtotalqty"));
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection categorys = filterInfo.getDynamicObjectCollection("mulmatcategory");
        rptParam.setMatcategory(categorys);
        return rptParam;
    }

    public static DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)false);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    private static void initRecAndSeds(DynamicObject dataEntity, StockCostGatherRptParam rptParam) {
        HashSet<Long> recSedTypes = new HashSet<Long>(16);
        LinkedHashMap<String, String> recs = new LinkedHashMap<String, String>(16);
        LinkedHashMap<String, String> sends = new LinkedHashMap<String, String>(16);
        DynamicObjectCollection receivers = dataEntity.getDynamicObjectCollection("showreceiver");
        if (receivers != null && receivers.size() != 0) {
            for (DynamicObject receiver : receivers) {
                DynamicObject dynamicObject = receiver.getDynamicObject("fbasedataid");
                String transceiver = dynamicObject.getString("transceiver");
                String transceiverName = dynamicObject.getString("name");
                String transceiverNumber = dynamicObject.getString("id");
                if ("2".equals(transceiver)) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5165", (String)"StockGatherRptQueryPlugin_52", (String)"fi-cal-report", (Object[])new Object[0]), transceiverName);
                    recs.put(transceiverNumber, msg);
                    String msg1 = String.format(ResManager.loadKDString((String)"%1$s\u51fa", (String)"StockGatherRptQueryPlugin_53", (String)"fi-cal-report", (Object[])new Object[0]), transceiverName);
                    sends.put(transceiverNumber, msg1);
                } else if ("0".equals(transceiver)) {
                    recs.put(transceiverNumber, transceiverName);
                } else if ("1".equals(transceiver)) {
                    sends.put(transceiverNumber, transceiverName);
                }
                recSedTypes.add(dynamicObject.getLong("id"));
            }
        }
        HashSet<String> sedSpBills = new HashSet<String>(16);
        HashSet<String> recSpBills = new HashSet<String>(16);
        String showspecialbill = dataEntity.getString("showspecialbill");
        if (showspecialbill != null && !showspecialbill.trim().equals("")) {
            String[] specialbills = showspecialbill.trim().split(",");
            MulComboProp showSpecialBillProp = (MulComboProp)EntityMetadataCache.getDataEntityType((String)"cal_stockcostgatherrpt").findProperty("showspecialbill");
            String[] stringArray = specialbills;
            int n = stringArray.length;
            block25: for (int i = 0; i < n; ++i) {
                String specialbill;
                switch (specialbill = stringArray[i]) {
                    case "transrec": {
                        recs.put("im_adjustbill0", ResManager.loadKDString((String)"\u5f62\u6001\u8f6c\u6362\u5165", (String)"StockCostGatherRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
                        recSpBills.add("im_adjustbill");
                        continue block25;
                    }
                    case "transsend": {
                        sends.put("im_adjustbill1", ResManager.loadKDString((String)"\u5f62\u6001\u8f6c\u6362\u51fa", (String)"StockCostGatherRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
                        sedSpBills.add("im_adjustbill");
                        continue block25;
                    }
                    case "assembbillrec": {
                        recs.put("im_assembbill0", ResManager.loadKDString((String)"\u7ec4\u88c5\u540e", (String)"StockCostGatherRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
                        recSpBills.add("im_assembbill");
                        continue block25;
                    }
                    case "assembbillsend": {
                        sends.put("im_assembbill1", ResManager.loadKDString((String)"\u7ec4\u88c5\u524d", (String)"StockCostGatherRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                        sedSpBills.add("im_assembbill");
                        continue block25;
                    }
                    case "locationtransferbillrec": {
                        recs.put("im_locationtransfer0", ResManager.loadKDString((String)"\u4ed3\u4f4d\u79fb\u52a8\u8c03\u5165", (String)"StockCostGatherRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                        recSpBills.add("im_locationtransfer");
                        continue block25;
                    }
                    case "locationtransferbillsend": {
                        sends.put("im_locationtransfer1", ResManager.loadKDString((String)"\u4ed3\u4f4d\u79fb\u52a8\u8c03\u51fa", (String)"StockCostGatherRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
                        sedSpBills.add("im_locationtransfer");
                        continue block25;
                    }
                    case "costadjustbillrec": {
                        recs.put("cal_costadjustbill0", ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5165", (String)"StockCostGatherRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]));
                        recSpBills.add("cal_costadjustbill");
                        continue block25;
                    }
                    case "costadjustbillsed": {
                        sends.put("cal_costadjustbill1", ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u51fa", (String)"StockCostGatherRptQueryPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]));
                        sedSpBills.add("cal_costadjustbill");
                        continue block25;
                    }
                    case "cal_stdcostdiffbillrec": {
                        recs.put("cal_stdcostdiffbill0", ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5165", (String)"StockCostGatherRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]));
                        recSpBills.add("cal_stdcostdiffbill");
                        continue block25;
                    }
                    case "cal_stdcostdiffbillsed": {
                        sends.put("cal_stdcostdiffbill1", ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u51fa", (String)"StockCostGatherRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]));
                        sedSpBills.add("cal_stdcostdiffbill");
                        continue block25;
                    }
                    default: {
                        if (specialbill.endsWith("rec")) {
                            recs.put(specialbill.replace("rec", "0"), showSpecialBillProp.getItemByName(specialbill));
                            recSpBills.add(specialbill.replace("rec", ""));
                            continue block25;
                        }
                        if (!specialbill.endsWith("sed") && !specialbill.endsWith("send")) continue block25;
                        sends.put(specialbill.replace("sed", "1").replace("send", "1"), showSpecialBillProp.getItemByName(specialbill));
                        sedSpBills.add(specialbill.replace("sed", "").replace("send", ""));
                    }
                }
            }
        }
        rptParam.setRecs(recs);
        rptParam.setSends(sends);
        rptParam.setRecSpBills(recSpBills);
        rptParam.setSedSpBills(sedSpBills);
        rptParam.setRecSedTypes(recSedTypes);
    }
}

