/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.formplugin;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherQueryHelper;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class StockCostGatherRptBplatFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Owner(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("materialto".equals(key)) {
            this.beforeF7SelectToValidate(e);
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        }
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stock_costgather_rpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && !calOrgList.isEmpty()) {
            HashSet<Long> calOrgIds = new HashSet<Long>(calOrgList.size());
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>(16);
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray.length <= 0) continue;
            ownerIdSet.addAll(Arrays.asList(ownerIsArray));
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d27\u4e3b", (String)"StockGatherRptQueryPlugin_38", (String)"fi-cal-report", (Object[])new Object[0]));
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet(16);
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)this.getModel().getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)this.getModel().getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        if (calOrgList == null || calOrgList.isEmpty()) {
            return;
        }
        HashSet materialIdSet = new HashSet(16);
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        formShowParameter.setF7ClickByFilter(true);
        formShowParameter.setShowApproved(false);
        formShowParameter.setShowUsed(false);
        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7SelectToValidate(BeforeF7SelectEvent e) {
        if (((DynamicObjectCollection)this.getModel().getValue("mulmaterial")).size() != 0) {
            Object selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)this.getModel().getValue("mulmaterial")).get(0)).getDynamicObject(1).get("number");
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
        }
        ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (calOrgList == null || calOrgList.isEmpty() || costaccounts == null || costaccounts.isEmpty() || startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Date> beginDateSet = new HashSet<Date>(costaccounts.size());
        HashSet<Long> costaccountIdSet = new HashSet<Long>(costaccounts.size());
        for (DynamicObject costaccount : costaccounts) {
            long costAccountId = costaccount.getDynamicObject("fbasedataid").getLong("id");
            costaccountIdSet.add(costAccountId);
        }
        QFilter filter = new QFilter("id", "in", costaccountIdSet);
        DynamicObjectCollection calAcctDyc = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        for (DynamicObject costAcct : calAcctDyc) {
            DynamicObject periodDyc = this.getYearPeriodByDate(costAcct, startdate);
            if (periodDyc == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"StockGatherDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]));
                return false;
            }
            StockCostGatherRptBplatFormPlugin.getBeginPeriod(costAcct, beginDateSet);
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>(16);
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype,calpolicy.currency,calpolicy.currency.amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        HashMap<Integer, Object> currencyAmtprecisionMap = new HashMap<Integer, Object>(16);
        HashSet<Integer> amtprecisionSet = new HashSet<Integer>(16);
        Long defaultCurrency = 0L;
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
            Long currencyId = calpolicy.getLong("calpolicy.currency");
            int amtprecision = calpolicy.getInt("calpolicy.currency.amtprecision");
            amtprecisionSet.add(amtprecision);
            currencyAmtprecisionMap.put(amtprecision, currencyId);
        }
        if (!amtprecisionSet.isEmpty()) {
            defaultCurrency = (Long)currencyAmtprecisionMap.get(Collections.max(amtprecisionSet));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Date min = Collections.min(beginDateSet);
        if (startdate.compareTo(min) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5fc5\u987b\u5728\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e4b\u540e\u3002", (String)"StockCostDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject calOrg : calOrgList) {
            if (PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stock_costgather_rpt", (String)"47150e89000000ac", (Long)calOrg.getDynamicObject("fbasedataid").getLong("id"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (enddate.before(startdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"StockGatherRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        LocalDateTime startDateTime = startdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime endDateTime = enddate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (startDateTime.plusYears(1L).isBefore(endDateTime)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0e\u5f00\u59cb\u65e5\u671f\u95f4\u9694\u8d85\u8fc7\u4e00\u5e74\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u67e5\u8be2\u3002", (String)"StockGatherRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        boolean showtotalflag = dataEntity.getBoolean("showtotalqty");
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        boolean topsumrow = dataEntity.getBoolean("topsumrow");
        if (showtotalflag || onlyshowsumrow || topsumrow) {
            boolean hasSumCols = false;
            String sumColsStr = (String)this.getModel().getValue("sumkeycols");
            if (!StringUtils.isEmpty((CharSequence)sumColsStr)) {
                String[] sumColsStrs;
                for (String sumCol : sumColsStrs = sumColsStr.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)sumCol)) continue;
                    hasSumCols = true;
                    break;
                }
            }
            if (!hasSumCols) {
                String showColsStr = (String)this.getModel().getValue("showkeycols");
                ArrayList<String> sumColList = new ArrayList<String>(16);
                if (!StringUtils.isEmpty((CharSequence)showColsStr)) {
                    String[] showColsStrs;
                    for (String showCol : showColsStrs = showColsStr.split(",")) {
                        if (StringUtils.isEmpty((CharSequence)showCol)) continue;
                        sumColList.add(showCol);
                    }
                }
                if (!sumColList.isEmpty()) {
                    FilterInfo filter1 = queryParam.getFilter();
                    if (sumColList.size() == 3) {
                        this.getModel().setValue("sumkeycols", (Object)",material,");
                        filter1.getFilterItem("sumkeycols").setValue((Object)",material,");
                    } else {
                        for (String sumCol : sumColList) {
                            if ("material".equals(sumCol) || "calorg".equals(sumCol) || "costaccount".equals(sumCol) || "ownertype".equals(sumCol)) continue;
                            this.getModel().setValue("sumkeycols", (Object)("," + sumCol + ","));
                            filter1.getFilterItem("sumkeycols").setValue((Object)("," + sumCol + ","));
                            break;
                        }
                    }
                }
            }
        }
        this.getModel().setValue("startdate", (Object)DateUtils.getDayStartTime((Date)startdate));
        this.getModel().setValue("enddate", (Object)DateUtils.getDayEndTime((Date)enddate));
        String colsStr = (String)this.getModel().getValue("showkeycols");
        StockCostGatherRptParam rptParam = StockCostGatherQueryHelper.buildRptParam(dataEntity, colsStr, queryParam);
        List headFilters = queryParam.getFilter().getHeadFilters();
        List<QFilter> balanceHeadFilters = StockCostGatherQueryHelper.getBalanceHeadFilters(headFilters);
        rptParam.setBalanceHeadFilters(balanceHeadFilters);
        rptParam.setDefaultCurrency(defaultCurrency);
        this.getQueryParam().getCustomParam().put(StockCostGatherRptParam.class.getName(), rptParam);
        return super.verifyQuery(queryParam);
    }

    private DynamicObject getYearPeriodByDate(DynamicObject calAcctDyc, Date date) {
        DynamicObject periodDyc = null;
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    private static void getBeginPeriod(DynamicObject costAccount, Set<Date> beginDateSet) {
        Long startPeriodId;
        DynamicObject period;
        if (costAccount == null) {
            return;
        }
        DynamicObject startPeriod = PeriodHelper.getSysCtrlEntity((Long)costAccount.getLong("id"));
        if (startPeriod != null && (period = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)(startPeriodId = Long.valueOf(startPeriod.getLong("startperiod.id")))).toArray())) != null) {
            Date begindate = period.getDate("begindate");
            beginDateSet.add(begindate);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stock_costgather_rpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        this.resetFilterGrid();
        this.setSumKeyCol();
    }

    private void costAccountChanged() {
        DynamicObjectCollection costAccountList = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        this.getModel().setValue("mulowner", null);
        if (costAccountList == null || costAccountList.isEmpty()) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        int size = costAccountList.size();
        HashSet<Object> calpolicyIdSet = new HashSet<Object>(size);
        HashSet<Long> costaccountIdSet = new HashSet<Long>(size);
        for (DynamicObject costAccount : costAccountList) {
            calpolicyIdSet.add(costAccount.getDynamicObject("fbasedataid").getDynamicObject("calpolicy").getPkValue());
            costaccountIdSet.add(costAccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        if (periods.isEmpty()) {
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        HashSet<Date> beginDateSet = new HashSet<Date>(periods.size());
        HashSet<Date> endDateSet = new HashSet<Date>(periods.size());
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            Date beginDate = period.getDate("begindate");
            Date endDate = period.getDate("enddate");
            beginDateSet.add(beginDate);
            endDateSet.add(endDate);
        }
        if (beginDateSet.isEmpty() || endDateSet.isEmpty()) {
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        Date max = (Date)Collections.max(endDateSet);
        Date min = (Date)Collections.min(beginDateSet);
        this.getModel().setValue("startdate", (Object)min);
        this.getModel().setValue("enddate", (Object)max);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("showkeycols".equals(key)) {
            this.changedShowKeyCols(e);
            this.setSumKeyCol();
        } else if ("sumkeycols".equals(key)) {
            this.changedSumKeyCols(e);
        }
    }

    private void setSumKeyCol() {
        String colsStr = (String)this.getModel().getValue("showkeycols");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        if (!kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            String[] colsStrs = colsStr.split(",");
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cal_stock_std_col_repo").getProperties();
            for (String col : colsStrs) {
                if (col.isEmpty() || !properties.containsKey((Object)col) || "costaccount".equals(col) || "calorg".equals(col) || "ownertype".equals(col)) continue;
                ComboItem item = "material".equals(col) ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5b58\u8d27", (String)"StockGatherReportBplatForm_1", (String)"fi-cal-report", (Object[])new Object[0])), col) : new ComboItem(((IDataEntityProperty)properties.get((Object)col)).getDisplayName(), col);
                propertyItems.add(item);
            }
        }
        if (propertyItems.size() > 0) {
            ComboEdit sumkeycols = (ComboEdit)this.getControl("sumkeycols");
            sumkeycols.setComboItems(propertyItems);
        }
    }

    private void changedSumKeyCols(PropertyChangedArgs e) {
        String colsStr = (String)this.getModel().getValue("sumkeycols");
        if (!kd.bos.util.StringUtils.isEmpty((String)colsStr)) {
            String material;
            String warehouse;
            String storageorgunitT;
            String storageorgunit;
            String ownerLessCol = null;
            String[] colsStrs = colsStr.split(",");
            HashSet<String> colsStrSet = new HashSet<String>(16);
            StringBuilder sb = new StringBuilder();
            for (String col : colsStrs) {
                if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
                colsStrSet.add(col);
                sb.append(col);
                sb.append(",");
            }
            colsStr = sb.toString();
            if (colsStrSet.contains("ownertype") && !colsStrSet.contains("owner")) {
                colsStr = colsStr.replace("ownertype", " ");
                ownerLessCol = "ownertype";
            }
            if ((storageorgunit = this.checkCoupleItem(colsStr, "warehouse", "storageorgunit")) != null) {
                colsStr = storageorgunit;
            }
            if ((storageorgunitT = this.checkCoupleItem(colsStr, "location", "storageorgunit")) != null && !colsStr.contains("storageorgunit")) {
                colsStr = storageorgunitT;
            }
            if ((warehouse = this.checkCoupleItem(colsStr, "location", "warehouse")) != null && !colsStr.contains("warehouse")) {
                colsStr = warehouse;
            }
            if ((material = this.checkCoupleItem(colsStr, "assist", "material")) != null && !colsStr.contains("material")) {
                colsStr = material;
            }
            if (storageorgunit != null || storageorgunitT != null || warehouse != null || ownerLessCol != null || material != null) {
                this.getModel().setValue("sumkeycols", (Object)colsStr);
            }
        }
    }

    private void changedShowKeyCols(PropertyChangedArgs e) {
        String warehouse;
        String storageorgunitT;
        String storageorgunit;
        String colsStr = (String)this.getModel().getValue("showkeycols");
        String hasCostMatCal = null;
        if (StringUtils.isEmpty((CharSequence)colsStr)) {
            colsStr = "calorg,costaccount,material";
            hasCostMatCal = "material";
        }
        boolean hasGroup = false;
        String[] colsStrs = colsStr.split(",");
        StringBuilder sb = new StringBuilder();
        HashSet<String> colsStrSet = new HashSet<String>(16);
        for (String col : colsStrs) {
            if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
            if ("group".equals(col)) {
                hasGroup = true;
            }
            sb.append(col);
            sb.append(",");
            colsStrSet.add(col);
        }
        if (!colsStrSet.contains("calorg")) {
            sb.append("calorg");
            sb.append(",");
            hasCostMatCal = "calorg";
        }
        if (!colsStrSet.contains("material")) {
            sb.append("material");
            sb.append(",");
            hasCostMatCal = "material";
        }
        if (!colsStrSet.contains("costaccount")) {
            sb.append("costaccount");
            sb.append(",");
            hasCostMatCal = "costaccount";
        }
        if ((storageorgunit = this.checkCoupleItem(colsStr = sb.toString(), "warehouse", "storageorgunit")) != null) {
            colsStr = storageorgunit;
        }
        if ((storageorgunitT = this.checkCoupleItem(colsStr, "location", "storageorgunit")) != null && !colsStr.contains("storageorgunit")) {
            colsStr = storageorgunitT;
        }
        if ((warehouse = this.checkCoupleItem(colsStr, "location", "warehouse")) != null && !colsStr.contains("warehouse")) {
            colsStr = warehouse;
        }
        if (storageorgunit != null || storageorgunitT != null || warehouse != null || hasCostMatCal != null) {
            this.getModel().setValue("showkeycols", (Object)colsStr);
        }
        if (hasGroup) {
            DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
            long matgroupstandardId = 730148448254487552L;
            if (null == materialgroupstandard) {
                this.getModel().setValue("materialgroupstandard", (Object)matgroupstandardId);
            }
        }
    }

    private String checkCoupleItem(String str, String hasVal, String addVal) {
        CharSequence[] items = str.split(",");
        int hasValIdx = -1;
        int addValIdx = -1;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals(hasVal)) {
                hasValIdx = i;
                continue;
            }
            if (!items[i].equals(addVal)) continue;
            addValIdx = i;
        }
        if (hasValIdx > -1 && addValIdx == -1) {
            items[hasValIdx] = hasVal + "," + addVal;
            return String.join((CharSequence)",", items) + ",";
        }
        return null;
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        DynamicObjectCollection calOrgList = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            this.getModel().setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>(calOrgList.size());
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulcalrange", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "materialto", "materialgroupstandard", "mulmaterialgroup", "multracknum");
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(evt -> {
            String key = evt.getFieldName();
            if ("material".equals(key)) {
                this.hyperLinkMaterialNameClick(evt);
            }
        });
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void hyperLinkMaterialNameClick(HyperLinkClickEvent evt) {
        String chosenGroup;
        List<String> needSendToDetail;
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        String groupType = filter.getString("mulgrouptype");
        if (groupType == null) {
            groupType = "A";
        }
        if (this.hasGroup(groupType, "B")) {
            // empty if block
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail = Arrays.stream((chosenGroup = (String)this.getModel().getValue("showkeycols")).split(",")).filter(a -> !StringUtils.isEmpty((CharSequence)a)).collect(Collectors.toList()), "storageorgunit")) {
            filter.getFilterItem("mulstorageorg").setValue((Object)row.getDynamicObject("storageorgunit"));
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail, "warehsgroup")) {
            DynamicObject warehsgroup = row.getDynamicObject("warehsgroup");
            if (warehsgroup == null) {
                filter.addFilterItem("mulwarehsgroup", (Object)0L);
            } else {
                filter.getFilterItem("mulwarehsgroup").setValue((Object)warehsgroup);
            }
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail, "warehouse")) {
            filter.getFilterItem("mulwarehouse").setValue((Object)row.getDynamicObject("warehouse"));
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail, "location") && row.getString("location") != null && StringUtils.isNotEmpty((CharSequence)row.getString("location").trim())) {
            filter.getFilterItem("mullocation").setValue((Object)row.getDynamicObject("location"));
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail, "owner")) {
            String ownerType = "bos_org";
            DynamicObject info = row.getDynamicObject("owner");
            if ("bos_org".equals(ownerType)) {
                filter.getFilterItem("mulowner").setValue((Object)info);
            } else if ("bd_supplier".equals(ownerType)) {
                filter.getFilterItem("mulsupplierownerfrom").setValue((Object)info);
            } else if ("bd_customer".equals(ownerType)) {
                filter.getFilterItem("mulcustomerownerfrom").setValue((Object)info);
            }
            filter.addFilterItem("ownertypehead", (Object)ownerType, "=");
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail, "group")) {
            filter.getFilterItem("mulmaterialgroup").setValue((Object)row.getDynamicObject("group"));
        }
        if (StockCostGatherRptBplatFormPlugin.hasGroupByName(needSendToDetail, "materialcategory")) {
            filter.addFilterItem("mulmatcategory", (Object)row.getDynamicObject("materialcategory"), "=");
        }
        DynamicObjectCollection showreceiver = filter.getDynamicObjectCollection("showreceiver");
        HashSet<Long> receiver = new HashSet<Long>();
        if (showreceiver != null) {
            for (DynamicObject receiverObject : showreceiver) {
                receiver.add(receiverObject.getLong("id"));
            }
        }
        String showspecialbill = Optional.ofNullable(filter.getString("showspecialbill")).orElse("");
        DynamicObject info = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        info.set("id", row.getDynamicObject("material").get("id"));
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.add((Object)info);
        filter.getFilterItem("mulmaterial").setValue((Object)coll);
        filter.getFilterItem("materialto").setValue((Object)info);
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        Date finalendDate = new Date(endDate.getTime());
        filter.getFilterItem("startdate").setValue((Object)startDate);
        filter.getFilterItem("enddate").setValue((Object)finalendDate);
        filter.getFilterItem("noshowzeroinout").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("onlyshowsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItem("topsumrow").setValue((Object)Boolean.FALSE);
        filter.getFilterItems().remove(filter.getFilterItem("mulgrouptype"));
        filter.getFilterItems().remove(filter.getFilterItem("groupbyperiod"));
        filter.getFilterItems().remove(filter.getFilterItem("sumkeycols"));
        filter.getFilterItems().remove(filter.getFilterItem("showkeycols"));
        filter.getFilterItems().remove(filter.getFilterItem("calshowtotal"));
        filter.getFilterItems().remove(filter.getFilterItem("showqtycols"));
        filter.getFilterItems().remove(filter.getFilterItem("showtotalqty"));
        filter.getFilterItem("showreceiver").setValue(receiver);
        filter.getFilterItem("showspecialbill").setValue((Object)showspecialbill);
        queryParam.setFilter(filter);
        FilterGrid grid = (FilterGrid)this.getControl("commonfs");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)grid.getEntityNumber());
        ArrayList<String> groupKeys = new ArrayList<String>(needSendToDetail);
        HashSet<String> pageQueryFields = new HashSet<String>();
        Container container = (Container)this.getView().getControl("flexpanelap2");
        List items = container.getItems();
        Container containerSecond = (Container)this.getView().getControl("flexpanelap5");
        List itemsSecond = containerSecond.getItems();
        items.addAll(itemsSecond);
        for (Control item : items) {
            String key = item.getKey();
            if (!StringUtils.isEmpty((CharSequence)key) && key.startsWith("mul")) {
                pageQueryFields.add(key.substring(3));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            pageQueryFields.add(key);
        }
        if (needSendToDetail != null && !needSendToDetail.isEmpty()) {
            needSendToDetail.removeAll(pageQueryFields);
            needSendToDetail.remove("ownertype");
            needSendToDetail.remove("group");
            needSendToDetail.remove("materialcategory");
            needSendToDetail.remove("storageorgunit");
            for (String needSend : needSendToDetail) {
                if (!groupKeys.contains(needSend)) continue;
                Object obj = row.get(needSend);
                SimpleFilterRow filterRow = new SimpleFilterRow();
                filterRow.setLogic("0");
                IDataEntityProperty pro = type.findProperty(needSend);
                if (pro instanceof FlexProp) continue;
                boolean isBaseData = pro instanceof BasedataProp;
                String string = needSend = isBaseData ? needSend + ".number" : needSend;
                if (obj == null) {
                    filterRow.setFieldName(needSend);
                    filterRow.setCompareType(this.getIsNull(pro));
                } else {
                    filterRow.setFieldName(needSend);
                    filterRow.setCompareType(this.getEqual(pro));
                    ArrayList<FilterValue> vals = new ArrayList<FilterValue>(1);
                    FilterValue fVal = new FilterValue();
                    Object val = row.get(needSend);
                    if (pro instanceof DateTimeProp && val instanceof Date) {
                        val = ((DateTimeProp)pro).getDateFormat().format((Date)val);
                    }
                    fVal.setValue(val);
                    vals.add(fVal);
                    filterRow.setValue(vals);
                }
                condition.getFilterRow().add(filterRow);
            }
        }
        StockDetailDailyRptParam stockDetailRptParam = new StockDetailDailyRptParam();
        stockDetailRptParam.setCondition(condition);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setCustomParam(StockDetailDailyRptParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)stockDetailRptParam));
        showParameter.setFormId("cal_stockdetaildaily_rpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public static boolean hasGroupByName(Collection<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !kd.bos.util.StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    private String getIsNull(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSISNULL.getId();
        }
        return pro instanceof ItemClassTypeProp ? CompareTypeEnum.COMBOBOXISNULL.getId() : CompareTypeEnum.ISNULL.getId();
    }

    private String getEqual(IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return CompareTypeEnum.ITEMCLASSEQUALS.getId();
        }
        return pro instanceof ItemClassTypeProp ? CompareTypeEnum.CHECKBOXEQUAL.getId() : CompareTypeEnum.EQUAL.getId();
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.contains(value);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("exportexcel".equals(evt.getItemKey())) {
            this.verifyColumnNum(evt);
        }
    }

    private void verifyColumnNum(BeforeItemClickEvent evt) {
        int groupTypeSize;
        String[] specialBillCol;
        int specialBillSize;
        DynamicObjectCollection receivers = (DynamicObjectCollection)this.getModel().getValue("showreceiver");
        int columnNum = 0;
        String specialBillStr = (String)this.getModel().getValue("showspecialbill");
        if (specialBillStr == null) {
            specialBillStr = ",";
        }
        if ((specialBillSize = (specialBillCol = specialBillStr.split(",")).length) > 0) {
            Object COSTADJUST_SED;
            --specialBillSize;
            String COSTADJUST_REC = "costadjustbillrec";
            if (specialBillStr.contains(COSTADJUST_REC)) {
                ++columnNum;
                --specialBillSize;
            }
            if (specialBillStr.contains((CharSequence)(COSTADJUST_SED = "costadjustbillsed"))) {
                ++columnNum;
                --specialBillSize;
            }
            specialBillSize = specialBillSize < 0 ? 0 : specialBillSize;
        }
        int receiverSize = receivers.size();
        for (DynamicObject receiver : receivers) {
            if (!"2".equals(receiver.getDynamicObject("fbasedataid").getString("transceiver"))) continue;
            ++receiverSize;
        }
        String groupType = (String)this.getModel().getValue("showkeycols");
        if (StringUtils.isEmpty((CharSequence)groupType)) {
            groupTypeSize = 1;
        } else {
            String[] groupTypeCol = groupType.split(",");
            groupTypeSize = groupTypeCol.length - 1;
            if (groupType.contains("material")) {
                --groupTypeSize;
            }
        }
        int EXCEL_BASECOLUMN_NUM = 6;
        int EXCEL_BASEITEM_NUM = 4;
        columnNum = columnNum + EXCEL_BASECOLUMN_NUM + (EXCEL_BASEITEM_NUM + specialBillSize + receiverSize) * 3 + groupTypeSize;
        if (columnNum > 256) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8981\u5bfc\u51fa\u7684\u5217\u6570\u8d85\u8fc7256\u5217\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff0c\u8bf7\u51cf\u5c11\u663e\u793a\u6536\u53d1\u7c7b\u578b\u7684\u52fe\u9009\u9879\u6216\u91cd\u65b0\u8bbe\u7f6e\u5176\u4ed6\u67e5\u8be2\u6761\u4ef6\u3002", (String)"StockCostGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.setSumKeyCol();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("material");
        removedPros.add("owner");
        removedPros.add("ownertype");
        removedPros.add("storageorgunit");
        removedPros.add("warehouse");
        removedPros.add("location");
        removedPros.add("period");
        removedPros.add("endperiod");
        removedPros.add("baseunit");
        removedPros.add("currencyid");
        removedPros.add("qtyprecision");
        removedPros.add("calrange");
        removedPros.add("accounttype");
        removedPros.add("materialmodel");
        removedPros.add("group");
        removedPros.add("assist");
        removedPros.add("warehsgroup");
        removedPros.add("tstype");
        removedPros.add("entityid");
        removedPros.add("recorsed");
        removedPros.add("entryid");
        removedPros.add("billstatus");
        removedPros.add("billtype");
        removedPros.add("createtype");
        removedPros.add("difftype");
        removedPros.add("bookdate");
        removedPros.add("issplitcreate");
        removedPros.add("isinitbill");
        removedPros.add("calbilltype");
        removedPros.add("invscheme");
        removedPros.add("costadjusttype");
        removedPros.add("biztype");
        removedPros.add("materialnum");
        removedPros.add("materialcategory");
        return !removedPros.contains(split[0]);
    }
}

