/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class AddTransceiverColumnMapFunction
extends MapFunction {
    private static final List<String> SPBILLS = Arrays.asList("im_adjustbill", "im_assembbill", "im_locationtransfer", "im_disassemblebill");
    private RowMeta rowMeta;
    private StockCostGatherRptParam reportParam;

    public AddTransceiverColumnMapFunction(RowMeta rowMeta, StockCostGatherRptParam reportParam) {
        this.rowMeta = rowMeta;
        this.reportParam = reportParam;
    }

    public RowX map(RowX rowX) {
        Map<String, String> recs = this.reportParam.getRecs();
        Map<String, String> sends = this.reportParam.getSends();
        String entityid = rowX.getString(this.rowMeta.getFieldIndex("entityid"));
        String recorsed = rowX.getString(this.rowMeta.getFieldIndex("recorsed"));
        String tstype = rowX.getString(this.rowMeta.getFieldIndex("tstype"));
        BigDecimal rec_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_qty"));
        BigDecimal rec_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_amount"));
        BigDecimal sed_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_qty"));
        BigDecimal sed_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_amount"));
        String biztype = rowX.getString(this.rowMeta.getFieldIndex("calbilltype"));
        if (StringUtils.isEmpty((String)recorsed) && !StringUtils.isEmpty((String)biztype)) {
            if ("IN".equals(biztype) || "A".equals(biztype)) {
                recorsed = "0";
            }
            if ("OUT".equals(biztype) || "B".equals(biztype)) {
                recorsed = "1";
            }
        }
        String concat = entityid + recorsed;
        for (String column : recs.keySet()) {
            boolean isNotSpRecSedType;
            String recQty = "rec" + column + "_qty";
            String recAmount = "rec" + column + "_amount";
            String spEntity = column.substring(0, column.length() - 1);
            boolean isRecSp = this.reportParam.getRecSpBills().contains(spEntity);
            boolean isSedSp = this.reportParam.getSedSpBills().contains(spEntity);
            boolean bl = isNotSpRecSedType = !isRecSp && !isSedSp;
            if (SPBILLS.contains(entityid) && isNotSpRecSedType) continue;
            if (("cal_costadjustbill".equals(entityid) || "cal_costadjust_subentity".equals(entityid)) && "cal_costadjustbill0".equals(column) && "cal_costadjustbill0".equals(concat)) {
                rowX.set(this.rowMeta.getFieldIndex(recAmount), (Object)rec_amount);
                continue;
            }
            if ("cal_stdcostdiffbill".equals(entityid) && "cal_stdcostdiffbill0".equals(column) && "cal_stdcostdiffbill0".equals(concat)) {
                rowX.set(this.rowMeta.getFieldIndex(recAmount), (Object)rec_amount);
                continue;
            }
            if (!column.equals(concat) && !column.equals(tstype)) continue;
            rowX.set(this.rowMeta.getFieldIndex(recQty), (Object)rec_qty);
            rowX.set(this.rowMeta.getFieldIndex(recAmount), (Object)rec_amount);
        }
        for (String column : sends.keySet()) {
            String sedQty = "sed" + column + "_qty";
            String sedAmount = "sed" + column + "_amount";
            if (("cal_costadjustbill".equals(entityid) || "cal_costadjust_subentity".equals(entityid)) && "cal_costadjustbill1".equals(column) && "cal_costadjustbill1".equals(concat)) {
                rowX.set(this.rowMeta.getFieldIndex(sedAmount), (Object)sed_amount);
                continue;
            }
            if ("cal_stdcostdiffbill".equals(entityid) && "cal_stdcostdiffbill1".equals(column) && "cal_stdcostdiffbill1".equals(concat)) {
                rowX.set(this.rowMeta.getFieldIndex(sedAmount), (Object)sed_amount);
                continue;
            }
            if (!column.equals(concat) && !column.equals(tstype)) continue;
            rowX.set(this.rowMeta.getFieldIndex(sedQty), (Object)sed_qty);
            rowX.set(this.rowMeta.getFieldIndex(sedAmount), (Object)sed_amount);
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

