/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class CalculateEndDataMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private StockCostGatherRptParam reportParam;

    public CalculateEndDataMapFunction(RowMeta rowMeta, StockCostGatherRptParam reportParam) {
        this.rowMeta = rowMeta;
        this.reportParam = reportParam;
    }

    public RowX map(RowX rowX) {
        BigDecimal bgn_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("bgn_qty"));
        BigDecimal rec_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_qty"));
        BigDecimal sed_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_qty"));
        BigDecimal end_qty = bgn_qty.add(rec_qty).subtract(sed_qty);
        rowX.set(this.rowMeta.getFieldIndex("end_qty"), (Object)end_qty);
        BigDecimal bgn_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("bgn_amount"));
        BigDecimal rec_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_amount"));
        BigDecimal sed_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_amount"));
        BigDecimal end_amount = bgn_amount.add(rec_amount).subtract(sed_amount);
        rowX.set(this.rowMeta.getFieldIndex("end_amount"), (Object)end_amount);
        int pricePrecision = 10;
        Map<String, String> recs = this.reportParam.getRecs();
        Map<String, String> sends = this.reportParam.getSends();
        for (String column : recs.keySet()) {
            BigDecimal recColumnQty;
            if (column.equals("cal_costadjustbill0") || "cal_stdcostdiffbill0".equals(column) || (recColumnQty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec" + column + "_qty"))).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal recColumnAmount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec" + column + "_amount"));
            rowX.set(this.rowMeta.getFieldIndex("rec" + column + "_price"), (Object)recColumnAmount.divide(recColumnQty, pricePrecision, 4));
        }
        for (String column : sends.keySet()) {
            BigDecimal sedColumnQty;
            if (column.equals("cal_costadjustbill1") || "cal_stdcostdiffbill1".equals(column) || (sedColumnQty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed" + column + "_qty"))).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal sedColumnAmount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed" + column + "_amount"));
            rowX.set(this.rowMeta.getFieldIndex("sed" + column + "_price"), (Object)sedColumnAmount.divide(sedColumnQty, pricePrecision, 4));
        }
        if (bgn_qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal bgn_price = bgn_amount.divide(bgn_qty, pricePrecision, 4);
            rowX.set(this.rowMeta.getFieldIndex("bgn_price"), (Object)bgn_price);
        }
        if (rec_qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rec_price = rec_amount.divide(rec_qty, pricePrecision, 4);
            rowX.set(this.rowMeta.getFieldIndex("rec_price"), (Object)rec_price);
        }
        if (sed_qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal sed_price = sed_amount.divide(sed_qty, pricePrecision, 4);
            rowX.set(this.rowMeta.getFieldIndex("sed_price"), (Object)sed_price);
        }
        if (end_qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal end_price = end_amount.divide(end_qty, pricePrecision, 4);
            rowX.set(this.rowMeta.getFieldIndex("end_price"), (Object)end_price);
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

