/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.function;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class CostAdjustMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private StockCostGatherRptParam rptParam;

    public CostAdjustMapFunction(RowMeta rowMeta, StockCostGatherRptParam rptParam) {
        this.rowMeta = rowMeta;
        this.rptParam = rptParam;
    }

    public RowX map(RowX rowX) {
        String entityid;
        BigDecimal adjustamt = rowX.getBigDecimal(this.rowMeta.getFieldIndex("adjustamt"));
        if (adjustamt == null) {
            adjustamt = BigDecimal.ZERO;
        }
        if (!StringUtils.isEmpty((String)(entityid = rowX.getString(this.rowMeta.getFieldIndex("entityid")))) && !"cal_stdcostdiffbill".equals(entityid)) {
            String costadjusttype = rowX.getString(this.rowMeta.getFieldIndex("costadjusttype"));
            if ("A".equals(costadjusttype)) {
                rowX.set(this.rowMeta.getFieldIndex("rec_amount"), (Object)adjustamt);
            } else {
                rowX.set(this.rowMeta.getFieldIndex("sed_amount"), (Object)adjustamt);
            }
        }
        if ("cal_stdcostdiffbill".equals(entityid)) {
            String biztype = rowX.getString(this.rowMeta.getFieldIndex("calbilltype"));
            if ("A".equals(biztype)) {
                rowX.set(this.rowMeta.getFieldIndex("calbilltype"), (Object)"IN");
                rowX.set(this.rowMeta.getFieldIndex("rec_amount"), (Object)adjustamt);
            } else {
                rowX.set(this.rowMeta.getFieldIndex("calbilltype"), (Object)"OUT");
                rowX.set(this.rowMeta.getFieldIndex("sed_amount"), (Object)adjustamt);
            }
        }
        Date startdate = this.rptParam.getStartdate();
        Date preDay = this.getPreDay(startdate);
        Date bookdate = rowX.getDate(this.rowMeta.getFieldIndex("bookdate"));
        if (bookdate.compareTo(preDay) <= 0) {
            BigDecimal bgn_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("bgn_qty"));
            BigDecimal rec_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_qty"));
            BigDecimal sed_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_qty"));
            rowX.set(this.rowMeta.getFieldIndex("bgn_qty"), (Object)bgn_qty.add(rec_qty).subtract(sed_qty));
            BigDecimal bgn_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("bgn_amount"));
            BigDecimal rec_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_amount"));
            BigDecimal sed_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_amount"));
            rowX.set(this.rowMeta.getFieldIndex("bgn_amount"), (Object)bgn_amount.add(rec_amount).subtract(sed_amount));
            rowX.set(this.rowMeta.getFieldIndex("rec_qty"), (Object)BigDecimal.ZERO);
            rowX.set(this.rowMeta.getFieldIndex("rec_amount"), (Object)BigDecimal.ZERO);
            rowX.set(this.rowMeta.getFieldIndex("sed_qty"), (Object)BigDecimal.ZERO);
            rowX.set(this.rowMeta.getFieldIndex("sed_amount"), (Object)BigDecimal.ZERO);
        }
        return rowX;
    }

    private Date getPreDay(Date filter_startdate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(filter_startdate);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

