/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.function;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class CostRecordMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private StockCostGatherRptParam rptParam;

    public CostRecordMapFunction(RowMeta rowMeta, StockCostGatherRptParam rptParam) {
        this.rowMeta = rowMeta;
        this.rptParam = rptParam;
    }

    public RowX map(RowX rowX) {
        BigDecimal baseqty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
        String accounttype = rowX.getString(this.rowMeta.getFieldIndex("accounttype"));
        BigDecimal standardcost = rowX.getBigDecimal(this.rowMeta.getFieldIndex("standardcost"));
        BigDecimal actualcost = rowX.getBigDecimal(this.rowMeta.getFieldIndex("actualcost"));
        String calbilltype = rowX.getString(this.rowMeta.getFieldIndex("calbilltype"));
        if ("IN".equals(calbilltype)) {
            rowX.set(this.rowMeta.getFieldIndex("rec_qty"), (Object)baseqty);
            rowX.set(this.rowMeta.getFieldIndex("recorsed"), (Object)"0");
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype)) {
                rowX.set(this.rowMeta.getFieldIndex("rec_amount"), (Object)standardcost);
            } else {
                rowX.set(this.rowMeta.getFieldIndex("rec_amount"), (Object)actualcost);
            }
        } else {
            rowX.set(this.rowMeta.getFieldIndex("sed_qty"), (Object)baseqty);
            rowX.set(this.rowMeta.getFieldIndex("recorsed"), (Object)"1");
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype)) {
                rowX.set(this.rowMeta.getFieldIndex("sed_amount"), (Object)standardcost);
            } else {
                rowX.set(this.rowMeta.getFieldIndex("sed_amount"), (Object)actualcost);
            }
        }
        Date startdate = this.rptParam.getStartdate();
        Date preDay = this.getPreDay(startdate);
        Date bookdate = rowX.getDate(this.rowMeta.getFieldIndex("bookdate"));
        if (bookdate.compareTo(preDay) <= 0) {
            BigDecimal bgn_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("bgn_qty"));
            BigDecimal rec_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_qty"));
            BigDecimal sed_qty = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_qty"));
            rowX.set(this.rowMeta.getFieldIndex("bgn_qty"), (Object)bgn_qty.add(rec_qty).subtract(sed_qty));
            BigDecimal bgn_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("bgn_amount"));
            BigDecimal rec_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("rec_amount"));
            BigDecimal sed_amount = rowX.getBigDecimal(this.rowMeta.getFieldIndex("sed_amount"));
            rowX.set(this.rowMeta.getFieldIndex("bgn_amount"), (Object)bgn_amount.add(rec_amount).subtract(sed_amount));
            rowX.set(this.rowMeta.getFieldIndex("rec_qty"), (Object)BigDecimal.ZERO);
            rowX.set(this.rowMeta.getFieldIndex("rec_amount"), (Object)BigDecimal.ZERO);
            rowX.set(this.rowMeta.getFieldIndex("sed_qty"), (Object)BigDecimal.ZERO);
            rowX.set(this.rowMeta.getFieldIndex("sed_amount"), (Object)BigDecimal.ZERO);
        }
        return rowX;
    }

    private Date getPreDay(Date filter_startdate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(filter_startdate);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

