/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.function;

import java.util.Date;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class FilterCostPeriodsReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<Long, DynamicObject> costAccountStartPeriodMap;
    private Date endDate;

    public FilterCostPeriodsReduceFunction(RowMeta rowMeta, StockCostGatherRptParam stockCostGatherRptParam) {
        this.rowMeta = rowMeta;
        this.costAccountStartPeriodMap = stockCostGatherRptParam.getCostAccountStartPeriodMap();
        this.endDate = stockCostGatherRptParam.getEnddate();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX rowX : iterable) {
            Date beginDate;
            int costaccountIndex;
            Long costaccountId = rowX.getLong(costaccountIndex = this.rowMeta.getFieldIndex("costaccount"));
            DynamicObject startPeriod = this.costAccountStartPeriodMap.get(costaccountId);
            if (startPeriod != null && (beginDate = startPeriod.getDate("begindate")).compareTo(this.endDate) > 0) continue;
            collector.collect(rowX);
        }
    }
}

