/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.report.newreport.base.NewReportDataHelper;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherQueryHelper;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.AddMaterialGroupTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.AddTransceiverColumnTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.CalculateEndDataTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.DisplaySettingFilterTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.FilterCostPeriodsDataxTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.ResultDataTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.transform.StockCostGatherDataXTransform;

public class StockCostGatherReportHandle
implements IReportDataHandle {
    private static final List<String> SPBILLS = Arrays.asList("im_adjustbill", "im_assembbill", "im_locationtransfer", "im_disassemblebill");
    private StockCostGatherRptParam reportParam;
    private LocaleString locale_periodBegin = new LocaleString(this.getLocale_periodBegin());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_assistProperty = new LocaleString(this.getLocale_assistProperty());
    private LocaleString local_baseUnit = new LocaleString(this.getLocal_baseUnit());

    private String getLocale_periodBegin() {
        return ResManager.loadKDString((String)"\u671f\u521d", (String)"StockGatherRptQueryPlugin_57", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u6536\u5165", (String)"StockGatherRptQueryPlugin_58", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u53d1\u51fa", (String)"StockGatherRptQueryPlugin_59", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b", (String)"StockGatherRptQueryPlugin_60", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockGatherRptQueryPlugin_25", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockGatherRptQueryPlugin_26", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockGatherRptQueryPlugin_27", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistProperty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"StockGatherRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"SalesEstimateDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (StockCostGatherRptParam)ctx.getParam(StockCostGatherRptParam.class.getName());
        boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup() && !StockCostGatherQueryHelper.hasGroupByName(ctx.getShowKeyCols(), "group");
        this.reportParam.setNotShowMaterialGroup(notShowMaterialGroup);
        this.reportParam.setHasMaterialGroup(StockCostGatherQueryHelper.hasGroupByName(ctx.getShowKeyCols(), "group"));
        this.addDefaultGroupField(ctx);
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (null == fixedFs) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    private void addDefaultGroupField(ReportDataCtx ctx) {
        ctx.getShowKeyCols().add("baseunit");
        ctx.getShowKeyCols().add("currencyid");
        ctx.getShowKeyCols().add("materialnum");
        ctx.getShowKeyCols().add("materialmodel");
        ctx.getShowKeyCols().add("qtyprecision");
        boolean notShowMaterialGroup = this.reportParam.isNotShowMaterialGroup();
        boolean hasMaterialGroup = this.reportParam.isHasMaterialGroup();
        if (!notShowMaterialGroup && !hasMaterialGroup) {
            ctx.getShowKeyCols().add("group");
        }
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(StockCostGatherQueryHelper.getFilter(this.reportParam, true));
        return fs;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        ArrayList<SrcBlockConf> resultSrcBlockConf = new ArrayList<SrcBlockConf>();
        boolean isNewBalance = this.reportParam.isNewBalance();
        Set<Long> costaccountIdSet = this.reportParam.getCostaccountIdSet();
        long costaccountId = costaccountIdSet.stream().findFirst().orElse(0L);
        DynamicObject periodDyc = StockCostGatherQueryHelper.getYearPeriodByDate(costaccountId, this.reportParam.getStartdate());
        Date periodBeginDate = periodDyc == null ? null : periodDyc.getDate("begindate");
        int yearPeriod = periodDyc == null ? 1 : periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
        Date endDate = this.reportParam.getEnddate();
        QFilter periodf = new QFilter("period", "<", (Object)yearPeriod);
        periodf.and(new QFilter("endperiod", ">=", (Object)yearPeriod));
        DynamicObjectCollection receiverColl = this.reportParam.getShowReceiver();
        HashSet<Long> recSedTypes = new HashSet<Long>(16);
        if (receiverColl != null && receiverColl.size() != 0) {
            for (DynamicObject receiver : receiverColl) {
                recSedTypes.add(receiver.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        Set<String> sedSpBills = this.reportParam.getSedSpBills();
        Set<String> recSpBills = this.reportParam.getRecSpBills();
        block15: for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity;
            switch (srcEntity = srcBlockConf.getSrcEntity()) {
                case "cal_balance": {
                    if (isNewBalance) break;
                    srcBlockConf.setDataFs(periodf);
                    srcBlockConf.setAllowNotMatch(true);
                    resultSrcBlockConf.add(srcBlockConf);
                    break;
                }
                case "cal_bal": {
                    if (!isNewBalance) break;
                    srcBlockConf.setDataFs(periodf);
                    NewReportDataHelper.addNewBalDimCols(ctx, srcBlockConf, this.reportParam);
                    List calBalDataTransform = srcBlockConf.getDataTransform();
                    calBalDataTransform.add(new StockCostGatherDataXTransform(ctx, this.reportParam, srcEntity));
                    srcBlockConf.setAllowNotMatch(true);
                    resultSrcBlockConf.add(srcBlockConf);
                    break;
                }
                case "cal_costrecord": {
                    String[] calBillTypes;
                    for (String calBillType : calBillTypes = new String[]{"IN", "OUT"}) {
                        Iterator filter = new QFilter("issplitcreate", "=", (Object)false);
                        filter.and(new QFilter("isinitbill", "=", (Object)false));
                        if (periodBeginDate != null) {
                            filter.and(new QFilter("bookdate", ">=", (Object)periodBeginDate));
                        }
                        filter.and(new QFilter("bookdate", "<=", (Object)endDate));
                        filter.and(new QFilter("calbilltype", "=", (Object)calBillType));
                        filter.and(new QFilter("costaccount", "in", costaccountIdSet));
                        filter.and("billstatus", "=", "C");
                        Set<Long> notUpdBalBizTypes = this.reportParam.getNotUpdBalBizTypes();
                        if (!notUpdBalBizTypes.isEmpty()) {
                            filter.and("biztype", "not in", notUpdBalBizTypes);
                        }
                        boolean isRec = calBillType.equals("IN");
                        if (recSedTypes.size() > 0 || recSpBills.size() > 0 || sedSpBills.size() > 0) {
                            filter.and(new QFilter("invscheme.transceivertype", "in", recSedTypes));
                        }
                        SrcBlockConf spBillsBlockConf = new SrcBlockConf();
                        spBillsBlockConf.setDefVals(srcBlockConf.getDefVals());
                        spBillsBlockConf.setRepoColFullSrcColMap(srcBlockConf.getRepoColFullSrcColMap());
                        spBillsBlockConf.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
                        spBillsBlockConf.setSrcEntity(srcBlockConf.getSrcEntity());
                        spBillsBlockConf.setType(srcBlockConf.getType());
                        QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
                        if (recSedTypes.size() > 0 || recSpBills.size() > 0 || sedSpBills.size() > 0) {
                            q = new QFilter("bizentityobject.id", "not in", SPBILLS);
                        }
                        q.and((QFilter)filter);
                        spBillsBlockConf.setDataFs(q);
                        List dataTransform = spBillsBlockConf.getDataTransform();
                        dataTransform.add(new StockCostGatherDataXTransform(ctx, this.reportParam, srcEntity));
                        spBillsBlockConf.setAllowNotMatch(true);
                        resultSrcBlockConf.add(spBillsBlockConf);
                        if (recSedTypes.size() <= 0 && recSpBills.size() <= 0 && sedSpBills.size() <= 0) continue;
                        SrcBlockConf spBillsBlockConf1 = new SrcBlockConf();
                        spBillsBlockConf1.setDefVals(srcBlockConf.getDefVals());
                        spBillsBlockConf1.setRepoColFullSrcColMap(srcBlockConf.getRepoColFullSrcColMap());
                        spBillsBlockConf1.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
                        spBillsBlockConf1.setSrcEntity(srcBlockConf.getSrcEntity());
                        spBillsBlockConf1.setType(srcBlockConf.getType());
                        QFilter q1 = isRec ? new QFilter("bizentityobject.id", "in", recSpBills) : new QFilter("bizentityobject.id", "in", sedSpBills);
                        QFilter filter1 = new QFilter("issplitcreate", "=", (Object)false);
                        filter1.and(new QFilter("isinitbill", "=", (Object)false));
                        if (periodBeginDate != null) {
                            filter1.and(new QFilter("bookdate", ">=", (Object)periodBeginDate));
                        }
                        filter1.and(new QFilter("bookdate", "<=", (Object)endDate));
                        filter1.and(new QFilter("calbilltype", "=", (Object)calBillType));
                        filter1.and(new QFilter("costaccount", "in", costaccountIdSet));
                        filter1.and("billstatus", "=", (Object)"C");
                        if (!notUpdBalBizTypes.isEmpty()) {
                            filter1.and("biztype", "not in", notUpdBalBizTypes);
                        }
                        q1.and(filter1);
                        spBillsBlockConf1.setDataFs(q1);
                        List dataTransform1 = spBillsBlockConf1.getDataTransform();
                        dataTransform1.add(new StockCostGatherDataXTransform(ctx, this.reportParam, srcEntity));
                        spBillsBlockConf1.setAllowNotMatch(true);
                        resultSrcBlockConf.add(spBillsBlockConf1);
                    }
                    continue block15;
                }
                case "cal_costadjustbill": {
                    String[] costAdjustCalBillTypes;
                    boolean showCostAdjBillRecSp;
                    boolean showRecSedTypeOrSpBills = recSedTypes.size() > 0 || recSpBills.size() > 0 || sedSpBills.size() > 0;
                    boolean bl = showCostAdjBillRecSp = showRecSedTypeOrSpBills && recSpBills.contains("cal_costadjustbill");
                    if (showRecSedTypeOrSpBills && !showCostAdjBillRecSp) break;
                    DynamicObjectCollection storageOrgs = this.reportParam.getStorageOrg();
                    HashSet<Long> storageOrgSet = new HashSet<Long>(16);
                    if (storageOrgs != null && !storageOrgs.isEmpty()) {
                        for (String[] storageOrg : storageOrgs) {
                            storageOrgSet.add(storageOrg.getDynamicObject("fbasedataid").getLong("id"));
                        }
                    }
                    for (String calBillType : costAdjustCalBillTypes = new String[]{"A", "B"}) {
                        QFilter filter = new QFilter("biztype", "=", (Object)calBillType);
                        filter.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
                        filter.and(new QFilter("costaccount", "in", costaccountIdSet));
                        if (!storageOrgSet.isEmpty()) {
                            filter.and(new QFilter("entryentity.storageorgunit", "in", storageOrgSet));
                        }
                        QFilter standf = new QFilter("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
                        standf.and(new QFilter("difftype", "<>", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue()));
                        standf.and(new QFilter("createtype", "<>", (Object)CostAdjustBilCreateTypeEnum.STAND_CHANGE.getValue()));
                        standf.and(new QFilter("createtype", "<>", (Object)CostAdjustBilCreateTypeEnum.BILL_SYNC.getValue()));
                        QFilter notStandf = new QFilter("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
                        notStandf.and(new QFilter("difftype", "=", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue()));
                        filter.and(standf.or(notStandf));
                        if (periodBeginDate != null) {
                            filter.and(new QFilter("bookdate", ">=", (Object)periodBeginDate));
                        }
                        filter.and(new QFilter("bookdate", "<=", (Object)endDate));
                        filter.and("isupdatecost", "=", (Object)"1");
                        SrcBlockConf blockConf = new SrcBlockConf();
                        blockConf.setDefVals(srcBlockConf.getDefVals());
                        blockConf.setRepoColFullSrcColMap(srcBlockConf.getRepoColFullSrcColMap());
                        blockConf.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
                        blockConf.setSrcEntity(srcBlockConf.getSrcEntity());
                        blockConf.setType(srcBlockConf.getType());
                        blockConf.setDataFs(filter);
                        List dataTransform = blockConf.getDataTransform();
                        dataTransform.add(new StockCostGatherDataXTransform(ctx, this.reportParam, srcEntity));
                        blockConf.setAllowNotMatch(true);
                        resultSrcBlockConf.add(blockConf);
                    }
                    continue block15;
                }
                case "cal_stdcostdiffbill": {
                    String[] costAdjustCalBillTypes;
                    boolean showCostAdjBillRecSpStdDiff;
                    boolean showRecSedTypeOrSpBillsStdDiff = recSedTypes.size() > 0 || recSpBills.size() > 0 || sedSpBills.size() > 0;
                    boolean bl = showCostAdjBillRecSpStdDiff = showRecSedTypeOrSpBillsStdDiff && recSpBills.contains("cal_stdcostdiffbill");
                    if (showRecSedTypeOrSpBillsStdDiff && !showCostAdjBillRecSpStdDiff) break;
                    DynamicObjectCollection storageOrgs = this.reportParam.getStorageOrg();
                    HashSet<Long> storageOrgSet = new HashSet<Long>(16);
                    if (storageOrgs != null && !storageOrgs.isEmpty()) {
                        for (DynamicObject storageOrg : storageOrgs) {
                            storageOrgSet.add(storageOrg.getDynamicObject("fbasedataid").getLong("id"));
                        }
                    }
                    for (String calBillType : costAdjustCalBillTypes = new String[]{"A", "B"}) {
                        QFilter filter = new QFilter("biztype", "=", (Object)calBillType);
                        filter.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
                        filter.and(new QFilter("costaccount", "in", costaccountIdSet));
                        if (!storageOrgSet.isEmpty()) {
                            filter.and(new QFilter("entryentity.storageorgunit", "in", storageOrgSet));
                        }
                        QFilter standf = new QFilter("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
                        standf.and(new QFilter("createtype", "<>", (Object)CostAdjustBilCreateTypeEnum.STAND_CHANGE.getValue()));
                        filter.and(standf);
                        if (periodBeginDate != null) {
                            filter.and(new QFilter("bookdate", ">=", (Object)periodBeginDate));
                        }
                        filter.and(new QFilter("bookdate", "<=", (Object)endDate));
                        filter.and("isupdatecost", "=", (Object)"1");
                        SrcBlockConf blockConf = new SrcBlockConf();
                        blockConf.setDefVals(srcBlockConf.getDefVals());
                        blockConf.setRepoColFullSrcColMap(srcBlockConf.getRepoColFullSrcColMap());
                        blockConf.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
                        blockConf.setSrcEntity(srcBlockConf.getSrcEntity());
                        blockConf.setType(srcBlockConf.getType());
                        blockConf.setDataFs(filter);
                        List dataTransform = blockConf.getDataTransform();
                        dataTransform.add(new StockCostGatherDataXTransform(ctx, this.reportParam, srcEntity));
                        blockConf.setAllowNotMatch(true);
                        resultSrcBlockConf.add(blockConf);
                    }
                    break;
                }
            }
        }
        ctx.getReportConf().setSrcBlockConf(resultSrcBlockConf);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new AddMaterialGroupTransform(ctx));
        transCollector.add(new AddTransceiverColumnTransform(ctx));
        transCollector.add(new FilterCostPeriodsDataxTransform(this.reportParam));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(new GroupPlan((Collection)ctx.getShowKeyCols(), (Collection)ctx.getShowQtyCols()));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CalculateEndDataTransform(ctx));
        transCollector.add(new DisplaySettingFilterTransform(ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ResultDataTransform(ctx));
        this.reportParam.closeMaterialCategory();
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("adjustamt");
        repoColFilter.add("baseqty");
        repoColFilter.add("standardcost");
        repoColFilter.add("actualcost");
        repoColFilter.add("calbilltype");
        repoColFilter.add("recorsed");
        repoColFilter.add("accounttype");
        repoColFilter.add("biztype");
        repoColFilter.add("bookdate");
        repoColFilter.add("entityid");
        repoColFilter.add("tstype");
        repoColFilter.add("costadjusttype");
        repoColFilter.add("invstatus");
        repoColFilter.add("invtype");
        repoColFilter.add("mversion");
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        repoColFilter.addAll(allKeyCols);
        repoColFilter.addAll(this.reportParam.getOtherBalDims());
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> resultcols = new ArrayList<AbstractReportColumn>(cols.size());
        ArrayList<AbstractReportColumn> periodbegincols = new ArrayList<AbstractReportColumn>(16);
        ArrayList<AbstractReportColumn> periodincols = new ArrayList<AbstractReportColumn>(16);
        ArrayList<AbstractReportColumn> periodOutcols = new ArrayList<AbstractReportColumn>(16);
        ArrayList<AbstractReportColumn> periodEndcols = new ArrayList<AbstractReportColumn>(16);
        HashSet<String> unableShowFields = new HashSet<String>(16);
        unableShowFields.add("qtyprecision");
        ReportColumn materialauxpty = new ReportColumn();
        materialauxpty.setCaption(this.locale_assistProperty);
        materialauxpty.setWidth(width);
        materialauxpty.setFieldKey("materialauxpty");
        materialauxpty.setFieldType("basedata");
        materialauxpty.setEntityId("bd_material");
        materialauxpty.setHide(true);
        resultcols.add((AbstractReportColumn)materialauxpty);
        for (AbstractReportColumn abstractReportColumn : cols) {
            ReportColumn reportCol = (ReportColumn)abstractReportColumn;
            String string = reportCol.getFieldKey();
            if (string.contains("bgn_")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodbegincols.add(abstractReportColumn);
                continue;
            }
            if (string.contains("rec_")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodincols.add(abstractReportColumn);
                continue;
            }
            if (string.contains("sed_")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodOutcols.add(abstractReportColumn);
                continue;
            }
            if (string.contains("end_")) {
                reportCol.setZeroShow(false);
                reportCol.setNoDisplayScaleZero(false);
                periodEndcols.add(abstractReportColumn);
                continue;
            }
            if (unableShowFields.contains(string)) continue;
            if (string.equals("baseunit")) {
                abstractReportColumn.setCaption(this.local_baseUnit);
            }
            resultcols.add(abstractReportColumn);
        }
        ReportColumnGroup begingroupCol = new ReportColumnGroup();
        begingroupCol.setCaption(this.locale_periodBegin);
        begingroupCol.setFieldKey("bgn_");
        cols.add((AbstractReportColumn)begingroupCol);
        for (Object beginCol : periodbegincols) {
            begingroupCol.getChildren().add(beginCol);
        }
        resultcols.add((AbstractReportColumn)begingroupCol);
        if (this.reportParam.isDisPlayIn()) {
            ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
            reportColumnGroup.setCaption(this.locale_periodIn);
            reportColumnGroup.setFieldKey("rec_");
            cols.add((AbstractReportColumn)reportColumnGroup);
            for (AbstractReportColumn abstractReportColumn : periodincols) {
                reportColumnGroup.getChildren().add(abstractReportColumn);
            }
            resultcols.add((AbstractReportColumn)reportColumnGroup);
        }
        Map<String, String> map = this.reportParam.getRecs();
        for (Map.Entry entry : map.entrySet()) {
            this.createDecimalColumn(resultcols, (String)entry.getValue(), "rec" + (String)entry.getKey());
        }
        if (this.reportParam.isDisPlayOut()) {
            ReportColumnGroup outgroupCol = new ReportColumnGroup();
            outgroupCol.setCaption(this.locale_periodOut);
            outgroupCol.setFieldKey("sed_");
            cols.add((AbstractReportColumn)outgroupCol);
            for (AbstractReportColumn abstractReportColumn : periodOutcols) {
                outgroupCol.getChildren().add(abstractReportColumn);
            }
            resultcols.add((AbstractReportColumn)outgroupCol);
        }
        Map<String, String> sends = this.reportParam.getSends();
        for (Map.Entry<String, String> entry : sends.entrySet()) {
            this.createDecimalColumn(resultcols, entry.getValue(), "sed" + entry.getKey());
        }
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setCaption(this.locale_periodEnd);
        reportColumnGroup.setFieldKey("end_");
        cols.add((AbstractReportColumn)reportColumnGroup);
        for (AbstractReportColumn abstractReportColumn : periodEndcols) {
            reportColumnGroup.getChildren().add(abstractReportColumn);
        }
        resultcols.add((AbstractReportColumn)reportColumnGroup);
        return resultcols;
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, String name, String fieldKey) {
        LocaleString groupName = new LocaleString(name);
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        boolean isCostAdj = fieldKey.contains("cal_costadjustbill");
        if (!isCostAdj) {
            ReportColumn qty = new ReportColumn();
            qty.setCaption(this.locale_qty);
            qty.setWidth(width);
            qty.setFieldKey(fieldKey + "_qty");
            qty.setFieldType("qty");
            qty.setMeasureUnitField("baseunit");
            groupCol.getChildren().add(qty);
            ReportColumn price = new ReportColumn();
            price.setCaption(this.locale_price);
            price.setWidth(width);
            price.setFieldKey(fieldKey + "_price");
            price.setFieldType("price");
            price.setCurrencyField("currencyid");
            groupCol.getChildren().add(price);
        }
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "_amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(amount);
        cols.add((AbstractReportColumn)groupCol);
    }
}

