/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;
import kd.fi.cal.report.newreport.stockcostgatherrpt.function.AddTransceiverColumnMapFunction;

public class AddTransceiverColumnTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private StockCostGatherRptParam reportParam;

    public AddTransceiverColumnTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = (StockCostGatherRptParam)ctx.getParam(StockCostGatherRptParam.class.getName());
    }

    public DataSetX doTransform(DataSetX srcData) {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(16);
        Map<String, String> recs = this.reportParam.getRecs();
        Map<String, String> sends = this.reportParam.getSends();
        HashSet<String> tsSumFields = new HashSet<String>(16);
        for (String column : recs.keySet()) {
            String recQty = "rec" + column + "_qty";
            String recAmount = "rec" + column + "_amount";
            if ("cal_costadjustbill0".equals(column) || "cal_stdcostdiffbill0".equals(column)) {
                fields.add(new Field(recAmount, (DataType)DataType.BigDecimalType));
                values.add(BigDecimal.ZERO);
                tsSumFields.add(recAmount);
                continue;
            }
            fields.add(new Field(recQty, (DataType)DataType.BigDecimalType));
            fields.add(new Field(recAmount, (DataType)DataType.BigDecimalType));
            values.add(BigDecimal.ZERO);
            values.add(BigDecimal.ZERO);
            tsSumFields.add(recQty);
            tsSumFields.add(recAmount);
        }
        for (String column : sends.keySet()) {
            String sedQty = "sed" + column + "_qty";
            String sedAmount = "sed" + column + "_amount";
            if ("cal_costadjustbill1".equals(column) || "cal_stdcostdiffbill1".equals(column)) {
                fields.add(new Field(sedAmount, (DataType)DataType.BigDecimalType));
                values.add(BigDecimal.ZERO);
                tsSumFields.add(sedAmount);
                continue;
            }
            fields.add(new Field(sedQty, (DataType)DataType.BigDecimalType));
            fields.add(new Field(sedAmount, (DataType)DataType.BigDecimalType));
            values.add(BigDecimal.ZERO);
            values.add(BigDecimal.ZERO);
            tsSumFields.add(sedQty);
            tsSumFields.add(sedAmount);
        }
        this.ctx.getShowQtyCols().addAll(tsSumFields);
        srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        RowMeta rowMeta = srcData.getRowMeta();
        srcData = srcData.map((MapFunction)new AddTransceiverColumnMapFunction(rowMeta, this.reportParam));
        return srcData;
    }
}

