/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;
import kd.fi.cal.report.newreport.stockcostgatherrpt.function.CalculateEndDataMapFunction;

public class CalculateEndDataTransform
implements IDataXTransform {
    private StockCostGatherRptParam reportParam;

    public CalculateEndDataTransform(ReportDataCtx ctx) {
        this.reportParam = (StockCostGatherRptParam)ctx.getParam(StockCostGatherRptParam.class.getName());
    }

    public DataSetX doTransform(DataSetX srcData) {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(16);
        Map<String, String> recs = this.reportParam.getRecs();
        Map<String, String> sends = this.reportParam.getSends();
        for (String column : recs.keySet()) {
            if ("cal_costadjustbill0".equals(column) || "cal_stdcostdiffbill0".equals(column)) continue;
            fields.add(new Field("rec" + column + "_price", (DataType)DataType.BigDecimalType));
            values.add(BigDecimal.ZERO);
        }
        for (String column : sends.keySet()) {
            if ("cal_costadjustbill1".equals(column) || "cal_stdcostdiffbill1".equals(column)) continue;
            fields.add(new Field("sed" + column + "_price", (DataType)DataType.BigDecimalType));
            values.add(BigDecimal.ZERO);
        }
        fields.add(new Field("bgn_price", (DataType)DataType.BigDecimalType));
        fields.add(new Field("rec_price", (DataType)DataType.BigDecimalType));
        fields.add(new Field("sed_price", (DataType)DataType.BigDecimalType));
        fields.add(new Field("end_price", (DataType)DataType.BigDecimalType));
        values.add(BigDecimal.ZERO);
        values.add(BigDecimal.ZERO);
        values.add(BigDecimal.ZERO);
        values.add(BigDecimal.ZERO);
        srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        RowMeta rowMeta = srcData.getRowMeta();
        srcData = srcData.map((MapFunction)new CalculateEndDataMapFunction(rowMeta, this.reportParam));
        return srcData;
    }
}

