/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.transform;

import kd.bos.algox.DataSetX;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class DisplaySettingFilterTransform
implements IDataXTransform {
    private StockCostGatherRptParam reportParam;

    public DisplaySettingFilterTransform(ReportDataCtx ctx) {
        this.reportParam = (StockCostGatherRptParam)ctx.getParam(StockCostGatherRptParam.class.getName());
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.filterByQtyCondition(srcData);
        srcData = this.filterByAmountCondition(srcData);
        srcData = this.noShowZeroInOut(srcData);
        srcData = this.filterByAllZeroCondition(srcData);
        return srcData;
    }

    private DataSetX filterByQtyCondition(DataSetX dataSet) {
        String qtyShowCondition = this.reportParam.getQtyShowCondition();
        if (StringUtils.isNotEmpty((String)qtyShowCondition)) {
            if ("A".equals(qtyShowCondition)) {
                return dataSet.filter("end_qty = 0");
            }
            if ("B".equals(qtyShowCondition)) {
                return dataSet.filter("end_qty <> 0");
            }
            if ("C".equals(qtyShowCondition)) {
                return dataSet.filter("end_qty > 0");
            }
            if ("D".equals(qtyShowCondition)) {
                return dataSet.filter("end_qty < 0");
            }
        }
        return dataSet;
    }

    private DataSetX filterByAmountCondition(DataSetX dataSet) {
        String amountShowCondition = this.reportParam.getAmountShowCondition();
        if (StringUtils.isNotEmpty((String)amountShowCondition)) {
            if ("A".equals(amountShowCondition)) {
                return dataSet.filter("end_amount = 0");
            }
            if ("B".equals(amountShowCondition)) {
                return dataSet.filter("end_amount <> 0");
            }
            if ("C".equals(amountShowCondition)) {
                return dataSet.filter("end_amount > 0");
            }
            if ("D".equals(amountShowCondition)) {
                return dataSet.filter("end_amount < 0");
            }
        }
        return dataSet;
    }

    private DataSetX noShowZeroInOut(DataSetX dataSet) {
        boolean noShowZeroInOut = this.reportParam.isNoShowZeroInOut();
        if (noShowZeroInOut) {
            return dataSet.filter("rec_qty <> 0 or rec_amount <> 0 or sed_qty <> 0 or sed_amount <> 0");
        }
        return dataSet;
    }

    private DataSetX filterByAllZeroCondition(DataSetX calGroupByDs) {
        boolean showAllZero = this.reportParam.isShowAllZero();
        if (!showAllZero) {
            String filter = "bgn_qty <> 0 or bgn_amount <> 0 or rec_qty <> 0 or rec_amount <> 0 or sed_qty <> 0 or sed_amount <> 0 or end_qty <> 0 or end_amount <> 0 ";
            calGroupByDs = calGroupByDs.filter(filter);
        }
        return calGroupByDs;
    }
}

