/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.resource.ResManager;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;

public class ResultDataTransform
implements IDataTransform {
    private ReportDataCtx ctx;
    private StockCostGatherRptParam reportParam;
    private String[] groups = new String[]{"calorg", "costaccount", "currencyid"};

    public ResultDataTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = (StockCostGatherRptParam)ctx.getParam(StockCostGatherRptParam.class.getName());
    }

    public DataSet doTransform(DataSet srcData) {
        boolean onlyShowSumRow;
        List<String> groupTypes = this.createGroupTypes();
        if (groupTypes == null) {
            ArrayList<String> orders = new ArrayList<String>(16);
            orders.addAll(this.createUnSumKeyGroupTypes());
            orders.add("materialnum");
            srcData = srcData.orderBy(orders.toArray(new String[0]));
            return srcData;
        }
        srcData = srcData.filter("linetype = '0'");
        srcData = srcData.removeFields(new String[]{"linetype"});
        String[] fieldNames = srcData.getRowMeta().getFieldNames();
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNames) {
            sb.append(fieldName).append(",");
        }
        sb.append("0 as ordercol").append(",").append("0 as linetype").append(",").append("0 as ordercol1");
        srcData = srcData.select(sb.toString());
        DataSet resultDs = srcData.addField("material", "materialauxpty").union(this.unionGroupDataSet(srcData, true, groupTypes));
        boolean topSumRow = this.reportParam.isTopSumRow();
        resultDs = topSumRow ? resultDs.union(this.unionGroupDataSet(srcData, false, groupTypes).addField("0", "materialauxpty")) : resultDs;
        ArrayList<String> orders = new ArrayList<String>(groupTypes.size() + 2);
        orders.addAll(groupTypes);
        orders.add(topSumRow ? "ordercol desc" : "ordercol");
        orders.add("materialnum");
        resultDs = resultDs.orderBy(orders.toArray(new String[0]));
        resultDs = topSumRow ? resultDs : resultDs.union(this.unionGroupDataSet(srcData, false, groupTypes).addField("0", "materialauxpty"));
        ArrayList<String> sumLineOrders = new ArrayList<String>(4);
        sumLineOrders.add("calorg");
        sumLineOrders.add("costaccount");
        sumLineOrders.add(topSumRow ? "ordercol1 desc" : "ordercol1");
        resultDs = resultDs.orderBy(sumLineOrders.toArray(new String[0]));
        boolean showTotalQty = this.reportParam.isShowTotalQty();
        if (showTotalQty) {
            DataSet sumLineDs = this.createSumLine(srcData).addField("0", "materialauxpty");
            resultDs = topSumRow ? sumLineDs.union(resultDs) : resultDs.union(sumLineDs);
        }
        resultDs = (onlyShowSumRow = this.reportParam.isOnlyShowSumRow()) ? resultDs.filter("ordercol <> 0") : resultDs;
        return resultDs;
    }

    private DataSet unionGroupDataSet(DataSet dataSet, boolean subTotal, List<String> groupTypes) {
        DataSet groupByDs;
        String[] groupFields = subTotal ? groupTypes.toArray(new String[0]) : this.groups;
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(groupFields);
        ArrayList<String> fields = new ArrayList<String>(32);
        for (Field field : dataSet.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.contains("_qty") || alia.contains("_amount")) {
                groupbyDataSet.sum(alia);
            } else if (alia.contains("_price")) {
                String aliaPre = alia.substring(0, alia.lastIndexOf("_"));
                String qtyf = aliaPre + "_qty";
                alia = "case when " + qtyf + " = 0 then 0 else " + aliaPre + "_amount/" + qtyf + " end as " + alia;
            } else if (alia.equals("materialnum")) {
                String totalName = subTotal ? ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockGatherRptQueryPlugin_29", (String)"fi-cal-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_45", (String)"fi-cal-report", (Object[])new Object[0]);
                alia = "'" + totalName + "' as " + alia;
            } else if (field.getDataType() instanceof StringType) {
                if (!subTotal || groupTypes.indexOf(alia) < 0) {
                    alia = "' ' as " + alia;
                }
            } else if (alia.equals("ordercol")) {
                alia = (subTotal ? "1" : "2") + " as " + alia;
            } else if (alia.equals("ordercol1")) {
                alia = (subTotal ? "0" : "1") + " as " + alia;
            } else if (alia.equals("linetype")) {
                alia = (subTotal ? "1" : "2") + " as " + alia;
            } else {
                if (!subTotal && (alia.equals("costaccount") || alia.equals("calorg") || alia.equals("currencyid"))) {
                    fields.add(alia);
                    continue;
                }
                if (!subTotal || groupTypes.indexOf(alia) < 0) {
                    alia = "0 as " + alia;
                }
            }
            fields.add(alia);
        }
        if (subTotal) {
            fields.add("materialauxpty");
            groupByDs = groupbyDataSet.max("material", "materialauxpty").finish().select(fields.toArray(new String[0]));
        } else {
            groupByDs = groupbyDataSet.finish().select(fields.toArray(new String[0]));
        }
        return groupByDs;
    }

    private List<String> createGroupTypes() {
        Set sumKeyCols = this.ctx.getSumKeyCols();
        if (sumKeyCols.isEmpty()) {
            return null;
        }
        ArrayList<String> groupTypes = new ArrayList<String>(8);
        groupTypes.addAll(sumKeyCols);
        groupTypes.add("calorg");
        groupTypes.add("costaccount");
        groupTypes.add("currencyid");
        return groupTypes;
    }

    private DataSet createSumLine(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy();
        ArrayList<String> fields = new ArrayList<String>(32);
        for (Field field : dataSet.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.contains("_qty") || alia.contains("_amount")) {
                groupbyDataSet.sum(alia);
            } else if (alia.contains("_price")) {
                String aliaPre = alia.substring(0, alia.lastIndexOf("_"));
                String qtyf = aliaPre + "_qty";
                alia = "case when " + qtyf + " = 0 then 0 else " + aliaPre + "_amount/" + qtyf + " end as " + alia;
            } else if (alia.equals("materialnum")) {
                String totalName = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockGatherRptQueryPlugin_32", (String)"fi-cal-report", (Object[])new Object[0]);
                alia = "'" + totalName + "' as " + alia;
            } else {
                alia = field.getDataType() instanceof StringType ? "' ' as " + alia : (alia.equals("ordercol") ? "2 as " + alia : (alia.equals("ordercol1") ? "2 as " + alia : (alia.equals("linetype") ? "2 as " + alia : ("currencyid".equals(alia) ? this.reportParam.getDefaultCurrency() + " as " + alia : "0 as " + alia))));
            }
            fields.add(alia);
        }
        return groupbyDataSet.finish().select(fields.toArray(new String[0]));
    }

    private List<String> createUnSumKeyGroupTypes() {
        Set showKeyCols = this.ctx.getShowKeyCols();
        showKeyCols.remove("material");
        Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
        ArrayList<String> groupTypes = new ArrayList<String>(8);
        showKeyCols.removeIf(next -> !allKeyCols.contains(next));
        groupTypes.addAll(showKeyCols);
        groupTypes.add("currencyid");
        return groupTypes;
    }
}

