/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockcostgatherrpt.transform;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stockcostgatherrpt.StockCostGatherRptParam;
import kd.fi.cal.report.newreport.stockcostgatherrpt.function.CostAdjustMapFunction;
import kd.fi.cal.report.newreport.stockcostgatherrpt.function.CostRecordMapFunction;

public class StockCostGatherDataXTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private StockCostGatherRptParam rptParam;
    private String srcEntity;

    public StockCostGatherDataXTransform(ReportDataCtx ctx, StockCostGatherRptParam rptParam, String srcEntity) {
        this.ctx = ctx;
        this.rptParam = rptParam;
        this.srcEntity = srcEntity;
    }

    public DataSetX doTransform(DataSetX srcData) {
        switch (this.srcEntity) {
            case "cal_bal": {
                Set allKeyCols = ReportUtil.filterBigtableCols((ReportConf)this.ctx.getReportConf(), colConf -> "A".equals(colConf.getCalType()));
                Set showKeyCols = this.ctx.getShowKeyCols();
                allKeyCols.add("invstatus");
                allKeyCols.add("invtype");
                allKeyCols.add("mversion");
                if (!showKeyCols.contains("group")) {
                    allKeyCols.remove("group");
                }
                if (allKeyCols.size() <= 0) break;
                allKeyCols.addAll(showKeyCols);
                StringBuilder builder = new StringBuilder();
                for (String keyCol : allKeyCols) {
                    builder.append(keyCol);
                    builder.append(",");
                }
                String groupSelect = builder.substring(0, builder.length() - 1);
                boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
                if (!balCompress) {
                    srcData = srcData.groupBy(groupSelect.split(",")).max("bgn_qty").sum("bgn_amount");
                    break;
                }
                srcData = srcData.groupBy(groupSelect.split(",")).sum("bgn_qty").sum("bgn_amount");
                break;
            }
            case "cal_costrecord": {
                srcData = srcData.map((MapFunction)new CostRecordMapFunction(srcData.getRowMeta(), this.rptParam));
                break;
            }
            case "cal_costadjustbill": 
            case "cal_stdcostdiffbill": {
                srcData = srcData.map((MapFunction)new CostAdjustMapFunction(srcData.getRowMeta(), this.rptParam));
            }
        }
        return srcData;
    }

    private Date getPreDay(Date filter_startdate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(filter_startdate);
        calendar.add(5, -1);
        return calendar.getTime();
    }
}

