/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class StockDetailDailyRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_invStatus;
    private Date filter_startDate;
    private Date filter_endDate;
    private DynamicObjectCollection filter_billtype;
    private String[] filter_billno;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private String queryType = null;
    private boolean isQueryByFilter = true;
    private static final Log logger = LogFactory.getLog(StockDetailDailyRptFormPlugin.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private static String[] engage_fields = new String[]{"calorg", "owner", "storageorgunit", "warehouse", "materialgroupname", "accounttype", "assist", "auditdate", "audittime", "baseunit.name", "baseunit.number", "baseunitname", "billid", "billstatus", "billtype.name", "billtype.number", "billtypename", "bizdate", "bizentityobject", "calbilltype", "calorg.name", "calorg.number", "calorgname", "configuredcode.desc", "configuredcode.number", "costaccount.name", "costaccount.number", "costaccountname", "costelement.name", "costelement.number", "costsubelement.name", "costsubelement.number", "createtype", "cur_index_adjust", "currency.amtprecision", "currency.isshowsign", "currency.name", "currency.number", "currency.priceprecision", "currency.sign", "difftype", "endperiod", "entryid", "isinitbill", "issplitcreate", "location.name", "location.number", "locationcode", "locationname", "material.name", "material.number", "materialgroup.longnumber", "materialgroup.name", "materialgroup.number", "materialgroupname", "materialgroupstandard.ispreset", "materialgroupstandard.name", "materialgroupstandard.number", "materialmodelnum", "materialname", "materialnumber", "month", "mversion.name", "mversion.number", "owner.name", "owner.number", "ownercode", "ownername", "ownertype", "period", "periodinamountbak", "periodinqtybak", "priorityorder", "priorityorder_first", "srcobject", "startperiod", "storageorgunit.name", "storageorgunit.number", "storageorgunitcode", "storageorgunitname", "warehouse.group.name", "warehouse.group.number", "warehouse.isopenlocation", "warehouse.name", "warehouse.number", "warehousecode", "warehousename", "warehsgroup.longnumber", "warehsgroup.name", "warehsgroup.number", "warehsgroupcode", "warehsgroupname", "year", "yearshow", "isvoucher", "comment", "billno", "bookdate", "projectname", "materialcategory.name", "materialcategory.number", "costrecordid", "materialcategory.longnumber", "materialgroup.fullname", "materialmodelnum", "warehouse.group.fullname", "warehouse.group.longnumber", "warehsgroup.fullname", "tracknumber.name", "tracknumber.description"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billnoid"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulcalrange", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "mulmaterial", "mulowner", "materialgroupstandard", "mulmaterialgroup", "materialto");
        report.addHyperClickListener(evt -> {
            String key = evt.getFieldName();
            if ("billno".equals(key)) {
                this.hyperLinkBillNoClick(evt);
            }
        });
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "billnoid".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showStoragebillnos(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            StockDetailDailyReportUtils.calOrgChanged(this.getModel());
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4Mulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        this.isQueryByFilter = true;
        if ("bar_first".equals(key)) {
            this.queryType = "first";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_previous".equals(key)) {
            this.queryType = "previous";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_next".equals(key)) {
            this.queryType = "next";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_last".equals(key)) {
            this.queryType = "last";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_viewbill".equals(key)) {
            this.viewBill();
        } else if ("refresh".equals(key)) {
            this.isQueryByFilter = false;
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection calorgs = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (calorgs == null || costAccount == null || startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockCostDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!this.hasPermission(userId, calorgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u5148\u8fdb\u884c\u6388\u6743\u6216\u4fee\u6539\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StockCostDetailRptFormPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (enddate.before(startdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"StockCostDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Date> beginDateSet = new HashSet<Date>(costAccount.size());
        HashSet<Long> costaccountIdSet = new HashSet<Long>(costAccount.size());
        for (DynamicObject costaccount : costAccount) {
            long costAccountId = costaccount.getDynamicObject("fbasedataid").getLong("id");
            costaccountIdSet.add(costAccountId);
        }
        QFilter filter = new QFilter("id", "in", costaccountIdSet);
        DynamicObjectCollection calAcctDyc = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        for (Object costAcct : calAcctDyc) {
            Long startPeriodId;
            DynamicObject period;
            Object startPeriodDynamic;
            DynamicObject periodDyc = this.getYearPeriodByDate(costAcct.getLong("id"), startdate);
            if (periodDyc == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"StockCostDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return false;
            }
            if (costAcct == null || (startPeriodDynamic = PeriodHelper.getSysCtrlEntity((Long)costAcct.getLong("id"))) == null || (period = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)(startPeriodId = Long.valueOf(startPeriodDynamic.getLong("startperiod.id")))).toArray())) == null) continue;
            Date accountStartPeriod = period.getDate("begindate");
            beginDateSet.add(accountStartPeriod);
            if (accountStartPeriod != null) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4", (String)"StockCostDetailRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        if (beginDateSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u542f\u7528\u671f\u95f4", (String)"StockCostDetailRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Date min = (Date)Collections.min(beginDateSet);
        if (startdate.compareTo(min) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u5fc5\u987b\u5728\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e4b\u540e\u3002", (String)"StockCostDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject costaccount : costAccount) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        this.getModel().setValue("startdate", (Object)DateUtils.getDayStartTime((Date)startdate));
        this.getModel().setValue("enddate", (Object)DateUtils.getDayEndTime((Date)enddate));
        StockDetailDailyRptParam param = this.createParam(queryParam);
        this.getQueryParam().getCustomParam().put(StockDetailDailyRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    private boolean hasPermission(Long userId, DynamicObjectCollection calorgs) {
        boolean flag = true;
        for (DynamicObject baseData : calorgs) {
            DynamicObject calOrg = baseData.getDynamicObject("fbasedataid");
            if (PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockdetaildaily_rpt", (String)"47150e89000000ac", (Long)calOrg.getLong("id"))) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private StockDetailDailyRptParam createParam(ReportQueryParam queryParam) {
        StockDetailDailyRptParam param = new StockDetailDailyRptParam();
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection costAccountObject = filter.getDynamicObjectCollection("mulcostaccount");
        Date startPeriod = filter.getDate("startdate");
        Date endPeriod = filter.getDate("enddate");
        HashMap<Long, Boolean> costAccountIdAndElement = new HashMap<Long, Boolean>();
        HashSet<Long> costAccountIds = new HashSet<Long>();
        for (DynamicObject costAccount : costAccountObject) {
            long costAccountId = costAccount.getLong("id");
            costAccountIds.add(costAccountId);
        }
        Map costAccountIdAndStartPeriod = PeriodHelper.getStartPeriods(costAccountIds);
        String ownerType = (String)filter.getValue("ownertypehead");
        DynamicObjectCollection ownerFrom = null;
        if (!StringUtils.isEmpty((String)ownerType)) {
            switch (ownerType) {
                case "bos_org": {
                    ownerFrom = filter.getDynamicObjectCollection("mulowner");
                    break;
                }
                case "bd_supplier": {
                    ownerFrom = filter.getDynamicObjectCollection("mulsupplierownerfrom");
                    break;
                }
                case "bd_customer": {
                    ownerFrom = filter.getDynamicObjectCollection("mulcustomerownerfrom");
                }
            }
        }
        DynamicObjectCollection calRange = filter.getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection storageOrgs = filter.getDynamicObjectCollection("mulstorageorg");
        Set warehouseGroupIds = ReportUtil.getWarehsGroupSet((FilterInfo)filter);
        DynamicObjectCollection warehouses = filter.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection locations = filter.getDynamicObjectCollection("mullocation");
        String[] lotIds = null;
        if (StringUtils.isNotEmpty((String)filter.getString("lotnumber"))) {
            lotIds = filter.getString("lotnumber").split(";");
        }
        DynamicObjectCollection tracknumbers = filter.getDynamicObjectCollection("multracknum");
        DynamicObjectCollection projects = filter.getDynamicObjectCollection("mulproject");
        DynamicObjectCollection invTypes = filter.getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection invStatuss = filter.getDynamicObjectCollection("mulinvstatus");
        String qtyShowCondition = filter.getString("qtyshowcondition");
        String amountShowCondition = filter.getString("amountshowcondition");
        boolean onlyqueryemptygroup = filter.getBoolean("onlyqueryemptygroup");
        boolean onlyShowSumRow = filter.getBoolean("onlyshowsumrow");
        boolean topSumRow = filter.getBoolean("topsumrow");
        boolean noshowzeroinout = filter.getBoolean("noshowzeroinout");
        Long currencyId = filter.getDynamicObject("localcurrency").getLong("id");
        DynamicObjectCollection filter_materialFrom = filter.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filter.getDynamicObject("materialto");
        DynamicObject materialgroupstandard = filter.getDynamicObject("materialgroupstandard");
        DynamicObjectCollection materialgroup = filter.getDynamicObjectCollection("mulmaterialgroup");
        List<String> accountAndYearStartPeriod = this.getCostAccountAndStartPeriod();
        DynamicObjectCollection mulMatCategory = filter.getDynamicObjectCollection("mulmatcategory");
        String billnoid = filter.getString("billnoid");
        DynamicObjectCollection mulbilltype = filter.getDynamicObjectCollection("mulbilltype");
        String showspecialbill = Optional.ofNullable(filter.getString("showspecialbill")).orElse("");
        param.setCostAccountIds(costAccountIds);
        param.setBeginDate(startPeriod);
        param.setEndDate(endPeriod);
        param.setOwnerFrom(ownerFrom);
        param.setOwnerType(ownerType);
        param.setCalRange(calRange);
        param.setStorageOrgs(storageOrgs);
        param.setWarehouseGroupIds(warehouseGroupIds);
        param.setWarehouses(warehouses);
        param.setLocations(locations);
        param.setLotIds(lotIds);
        param.setProjects(projects);
        param.setTracknumbers(tracknumbers);
        param.setInvTypes(invTypes);
        param.setInvStatuss(invStatuss);
        param.setCurrencyId(currencyId);
        param.setOnlyqueryemptygroup(onlyqueryemptygroup);
        param.setNewBalance(this.isNewBalance);
        param.setOnlyshowsumrow(onlyShowSumRow);
        param.setTopsumrow(topSumRow);
        param.setQtyShowCondition(qtyShowCondition);
        param.setAmountShowCondition(amountShowCondition);
        param.setNoshowzeroinout(noshowzeroinout);
        param.setMaterialFrom(filter_materialFrom);
        param.setMaterialTo(filter_materialTo);
        param.setMaterialgroupstandard(materialgroupstandard);
        param.setMulmaterialgroup(materialgroup);
        param.setAccountAndYearAndPeriod(accountAndYearStartPeriod);
        param.setMatcategory(mulMatCategory);
        param.setBillno(billnoid);
        param.setBilltypes(mulbilltype);
        param.setCostAccountIdAndElement(costAccountIdAndElement);
        param.setCostAccountIdAndStartPeriod(costAccountIdAndStartPeriod);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        StockDetailDailyRptFormPlugin.initRecAndSeds(dataEntity, param, showspecialbill);
        return param;
    }

    private static void initRecAndSeds(DynamicObject dataEntity, StockDetailDailyRptParam rptParam, String showspecialbill) {
        HashSet<Long> recSedTypes = new HashSet<Long>(16);
        DynamicObjectCollection receivers = dataEntity.getDynamicObjectCollection("showreceiver");
        if (receivers != null && receivers.size() != 0) {
            for (DynamicObject receiver : receivers) {
                DynamicObject dynamicObject = receiver.getDynamicObject("fbasedataid");
                recSedTypes.add(dynamicObject.getLong("id"));
            }
        }
        HashSet<String> sedSpBills = new HashSet<String>(16);
        HashSet<String> recSpBills = new HashSet<String>(16);
        if (showspecialbill != null && !showspecialbill.trim().equals("")) {
            String[] specialbills;
            String[] stringArray = specialbills = showspecialbill.trim().split(",");
            int n = stringArray.length;
            block21: for (int i = 0; i < n; ++i) {
                String specialbill;
                switch (specialbill = stringArray[i]) {
                    case "transrec": {
                        recSpBills.add("im_adjustbill");
                        continue block21;
                    }
                    case "transsend": {
                        sedSpBills.add("im_adjustbill");
                        continue block21;
                    }
                    case "assembbillrec": {
                        recSpBills.add("im_assembbill");
                        continue block21;
                    }
                    case "assembbillsend": {
                        sedSpBills.add("im_assembbill");
                        continue block21;
                    }
                    case "locationtransferbillrec": {
                        recSpBills.add("im_locationtransfer");
                        continue block21;
                    }
                    case "locationtransferbillsend": {
                        sedSpBills.add("im_locationtransfer");
                        continue block21;
                    }
                    case "costadjustbillrec": {
                        recSpBills.add("cal_costadjustbill");
                        continue block21;
                    }
                    case "costadjustbillsed": {
                        sedSpBills.add("cal_costadjustbill");
                        continue block21;
                    }
                    default: {
                        if (specialbill.endsWith("rec")) {
                            recSpBills.add(specialbill.replace("rec", ""));
                            continue block21;
                        }
                        if (!specialbill.endsWith("sed") && !specialbill.endsWith("send")) continue block21;
                        sedSpBills.add(specialbill.replace("sed", "").replace("send", ""));
                    }
                }
            }
        }
        rptParam.setRecSpBills(recSpBills);
        rptParam.setSedSpBills(sedSpBills);
        rptParam.setRecSedTypes(recSedTypes);
    }

    private List<String> getCostAccountAndStartPeriod() {
        ArrayList<String> accountAndStartPeriodYearMonth = new ArrayList<String>(16);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>(16);
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Map startPeriods = PeriodHelper.getStartPeriods(calOrgIds);
            for (Map.Entry entry : startPeriods.entrySet()) {
                Long costAccountId = (Long)entry.getKey();
                DynamicObject startPeriod = (DynamicObject)entry.getValue();
                int periodyear = 0;
                int periodnumber = 0;
                if (startPeriod != null) {
                    periodyear = startPeriod.getInt("periodyear");
                    periodnumber = startPeriod.getInt("periodnumber");
                }
                accountAndStartPeriodYearMonth.add(costAccountId + "#" + periodyear + "#" + periodnumber);
            }
        }
        return accountAndStartPeriodYearMonth;
    }

    private Set<Integer> getPeriodNumber(int startPeriodValue, int endPeriodValue, DynamicObjectCollection costAccountObjects) {
        HashSet<Integer> periods = new HashSet<Integer>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (DynamicObject costAccountInfo : costAccountObjects) {
            Long id = costAccountInfo.get("id") == null ? 0L : costAccountInfo.getLong("id");
            costAccountIds.add(id);
        }
        DynamicObjectCollection costAccountInfos = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costAccountIds)});
        HashSet<Long> periodTypeIds = new HashSet<Long>(16);
        for (DynamicObject costAccountInfo : costAccountInfos) {
            Long id = costAccountInfo.get("calpolicy.periodtype") == null ? 0L : Long.parseLong(costAccountInfo.get("calpolicy.periodtype").toString());
            periodTypeIds.add(id);
        }
        QFilter qBegin = new QFilter("periodyear*100+periodnumber", ">=", (Object)startPeriodValue);
        qBegin.and("periodyear*100+periodnumber", "<=", (Object)endPeriodValue);
        qBegin.and("periodtype", "in", periodTypeIds);
        qBegin.and("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{qBegin}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            if (periods.contains(info.getInt("periodyear") * 100 + info.getInt("periodnumber"))) continue;
            periods.add(info.getInt("periodyear") * 100 + info.getInt("periodnumber"));
        }
        return periods;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String firstQuery = this.getPageCache().get("firstQuery");
        this.getPageCache().put("materialIds", null);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            return;
        }
        HashSet materialIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccount != null) {
            q = new QFilter("id", "in", (Object)AccountingSysHelper.getOwners((Long)costAccount.getLong("id")));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costaccounts != null && costaccounts.size() > 0) {
            HashSet<Long> costaccountIdSet = new HashSet<Long>();
            for (DynamicObject costaccount : costaccounts) {
                costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("costaccount", "in", costaccountIdSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockdetaildaily_rpt", (String)"47150e89000000ac");
        if (list != null) {
            logger.info("List \u4e0d\u4e3anull,\u5b58\u8d27\u6536\u53d1\u5b58\u660e\u7ec6\u8868(\u6309\u65e5\u671f)-\u6838\u7b97\u7ec4\u7ec7List: " + list + " size: " + list.size());
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else {
            logger.info("List\u4e3anull,\u5b58\u8d27\u6536\u53d1\u5b58\u660e\u7ec6\u8868(\u6309\u65e5\u671f)-\u6838\u7b97\u7ec4\u7ec7");
        }
    }

    private QFilter getBalFilter(ReportQueryParam queryParam) {
        HashSet<Object> set;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        DynamicObjectCollection filter_owner = filterInfo.getDynamicObjectCollection("mulowner");
        DynamicObjectCollection filter_storageOrg = filterInfo.getDynamicObjectCollection("mulstorageorg");
        DynamicObjectCollection filter_warehouse = filterInfo.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = filterInfo.getDynamicObjectCollection("mullocation");
        DynamicObjectCollection filter_materialFrom = filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filterInfo.getDynamicObject("materialto");
        String[] filter_lot = null;
        String lotnumber = filterInfo.getString("lotnumber");
        Set warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        if (StringUtils.isNotEmpty((String)lotnumber)) {
            filter_lot = lotnumber.split(";");
        }
        DynamicObjectCollection filter_project = queryParam.getFilter().getDynamicObjectCollection("mulproject");
        DynamicObjectCollection filter_invType = queryParam.getFilter().getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection filter_invStatus = queryParam.getFilter().getDynamicObjectCollection("mulinvstatus");
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        if (filter_owner != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and("owner", "in", set);
        }
        if (filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", (Object)warehsGroupSet);
        }
        if (filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (filter_lot != null) {
            q.and("lot", "in", (Object)filter_lot);
        }
        if (filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("material", "in", set);
            } else {
                q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        return q;
    }

    private void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject row = evt.getRowData();
        String billId = row.getString("billid");
        if ("0".equals(billId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bizEntityObject = row.getString("bizentityobject");
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewBill() {
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        this.getModel().setValue("mulcalrange", null);
        this.getModel().setValue("mulowner", null);
        this.getModel().setValue("mulsupplierownerfrom", null);
        this.getModel().setValue("mulcustomerownerfrom", null);
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        HashSet<Object> calpolicyIdSet = new HashSet<Object>();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            calpolicyIdSet.add(costaccount.getDynamicObject("fbasedataid").getDynamicObject("calpolicy").getPkValue());
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        TreeSet<Date> beginDate = new TreeSet<Date>();
        HashSet<Date> endDate = new HashSet<Date>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            beginDate.add(period.getDate("begindate"));
            endDate.add(period.getDate("enddate"));
        }
        if (beginDate.isEmpty() && endDate.isEmpty()) {
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            return;
        }
        Date max = (Date)Collections.max(endDate);
        Date min = (Date)Collections.min(beginDate);
        this.getModel().setValue("startdate", (Object)(beginDate.size() == 0 ? null : min));
        this.getModel().setValue("enddate", (Object)(endDate.size() == 0 ? null : max));
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockdetailrpt_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        StockDetailDailyRptParam stockDetailDailyRptParam;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(StockDetailDailyRptParam.class.getName());
        if (!StringUtils.isEmpty((String)openParamStr) && (stockDetailDailyRptParam = (StockDetailDailyRptParam)SerializationUtils.fromJsonString((String)openParamStr, StockDetailDailyRptParam.class)) != null && stockDetailDailyRptParam.getCondition() != null) {
            filterGrid.SetValue(stockDetailDailyRptParam.getCondition());
        }
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        HashSet<String> set = new HashSet<String>(Arrays.asList(engage_fields));
        for (Map info : filterColumns) {
            String fieldName = (String)info.get("fieldName");
            if (set.contains(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private DynamicObjectCollection getBalMaterialDycs(ReportQueryParam queryParam) {
        DynamicObjectCollection hasBeginMaterials;
        DynamicObjectCollection hasEndMaterials;
        Long materialId;
        DynamicObject costAccount = queryParam.getFilter().getDynamicObject("costaccount");
        Long costAccountId = costAccount.getLong("id");
        Date startDate = queryParam.getFilter().getDate("startdate");
        DynamicObject startPeriod = PeriodHelper.getPeriodByDate((Date)startDate, (Long)costAccountId);
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        this.initParams(queryParam);
        QFilter costRecordQ = QFilter.of((String)"entry.baseqty <> 0 or entry.standardcost <> 0 or entry.actualcost <> 0", (Object[])new Object[0]);
        DynamicObjectCollection costRecordMaterials = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.material.id", (QFilter[])new QFilter[]{this.getCostRecordFilter(), costRecordQ});
        QFilter costAdjustQ = QFilter.of((String)"entryentity.adjustamt <> 0", (Object[])new Object[0]);
        DynamicObjectCollection costAdjustMaterials = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"entryentity.material.id", (QFilter[])new QFilter[]{this.getCostAdjustFilter(), costAdjustQ});
        HashSet<Long> inOutMaterialIds = new HashSet<Long>(costRecordMaterials.size() + costAdjustMaterials.size());
        for (DynamicObject inOutMaterial : costRecordMaterials) {
            materialId = inOutMaterial.getLong("entry.material.id");
            inOutMaterialIds.add(materialId);
        }
        for (DynamicObject inOutMaterial : costAdjustMaterials) {
            materialId = inOutMaterial.getLong("entryentity.material.id");
            inOutMaterialIds.add(materialId);
        }
        QFilter q = new QFilter("material.id", "in", inOutMaterialIds);
        QFilter[] qFilters = new QFilter[]{q};
        if (queryParam.getFilter().getBoolean("noshowzeroinout")) {
            return this.filterQtyAndAmount(qFilters, queryParam);
        }
        DynamicObjectCollection materials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)});
        HashSet<Long> materialIds = new HashSet<Long>(materials.size());
        for (DynamicObject material : materials) {
            Long materialId2 = material.getLong("material.id");
            materialIds.add(materialId2);
        }
        HashSet noInOutMaterials = new HashSet(materialIds);
        noInOutMaterials.removeAll(inOutMaterialIds);
        QFilter q1 = new QFilter("material.id", "in", noInOutMaterials);
        q1.and("period", "<", (Object)startPeriodNumber);
        q1.and("endperiod", ">=", (Object)startPeriodNumber);
        if (this.isNewBalance) {
            QFilter newBalanceQ1 = q1.copy();
            newBalanceQ1.and(QFilter.of((String)"baseqty_bal <> 0 or actualcost_bal <> 0", (Object[])new Object[0]));
            hasEndMaterials = QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{newBalanceQ1, this.getBalFilter(queryParam)});
        } else {
            q1.and(QFilter.of((String)"periodendqty <> 0 or periodendactualcost <> 0", (Object[])new Object[0]));
            hasEndMaterials = QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{q1, this.getBalFilter(queryParam)});
        }
        HashSet<Long> hasBeginEndMaterialIds = new HashSet<Long>(inOutMaterialIds.size());
        for (DynamicObject hasBeginMaterial : hasEndMaterials) {
            Long materialId3 = hasBeginMaterial.getLong("material.id");
            hasBeginEndMaterialIds.add(materialId3);
        }
        if (this.isNewBalance) {
            QFilter newBalanceQ2 = QFilter.of((String)"period != 0", (Object[])new Object[0]).and("period", "<=", (Object)startPeriodNumber).and(QFilter.of((String)"baseqty <> 0 or actualcost <> 0 ", (Object[])new Object[0]));
            newBalanceQ2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"baseqty <> 0 or actualcost <> 0 ", (Object[])new Object[0])));
            hasBeginMaterials = QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{newBalanceQ2, this.getBalFilter(queryParam)});
        } else {
            QFilter q2 = QFilter.of((String)"period != 0", (Object[])new Object[0]).and("period", "<=", (Object)startPeriodNumber).and(QFilter.of((String)"periodbeginqty <> 0 or periodbeginactualcost <> 0 ", (Object[])new Object[0]));
            q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"periodbeginqty <> 0 or periodbeginactualcost <> 0 ", (Object[])new Object[0])));
            hasBeginMaterials = QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{q2, this.getBalFilter(queryParam)});
        }
        for (DynamicObject hasBeginMaterial : hasBeginMaterials) {
            Long materialId4 = hasBeginMaterial.getLong("material.id");
            hasBeginEndMaterialIds.add(materialId4);
        }
        hasBeginEndMaterialIds.addAll(inOutMaterialIds);
        QFilter q3 = new QFilter("material.id", "in", hasBeginEndMaterialIds);
        QFilter q4 = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter[] qFilters2 = new QFilter[]{q3, q4};
        return this.filterQtyAndAmount(qFilters2, queryParam);
    }

    private DynamicObjectCollection filterQtyAndAmount(QFilter[] qFilters, ReportQueryParam queryParam) {
        DataSet balDs;
        String selectFields = "material.id,material.number,periodinqty,periodinactualcost,periodissueqty,periodissueactualcost,periodendqty,periodendactualcost";
        if (this.isNewBalance) {
            String moreFields = ",material.id,material.number,baseqty_in as periodinqty,actualcost_in as periodinactualcost,baseqty_out as periodissueqty,actualcost_out as periodissueactualcost,baseqty_bal as periodendqty,actualcost_bal as periodendactualcost";
            String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",material.id,material.number").split(",");
            balDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)select, (QFilter[])qFilters, null);
            balDs = balDs.groupBy(groupSelect).max("periodinqty").sum("periodinactualcost").max("periodissueqty").sum("periodissueactualcost").max("periodendqty").sum("periodendactualcost").finish();
            balDs = balDs.select(selectFields).orderBy(new String[]{"material.number"});
        } else {
            balDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)selectFields, (QFilter[])qFilters, (String)"material.number");
        }
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        DynamicObjectCollection filter_materialgroupfrom = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        boolean notShowMaterialGroup = materialgroupstandard == null && (filter_materialgroupfrom == null || filter_materialgroupfrom.size() < 1);
        DataSet materialGroupDs = ReportUtil.getClassifiedMaterialDataSet((FilterInfo)filterInfo, (boolean)notShowMaterialGroup, (DynamicObject)materialgroupstandard);
        balDs = this.filterByMaterialGroup(balDs, materialGroupDs);
        DataSet balFilterQtyAmountDs = balDs.groupBy(new String[]{"material.id", "material.number"}).sum("periodinqty").sum("periodinactualcost").sum("periodissueqty").sum("periodissueactualcost").sum("periodendqty").sum("periodendactualcost").finish();
        balFilterQtyAmountDs = balFilterQtyAmountDs.orderBy(new String[]{"material.number"});
        DynamicObjectCollection balCol = ORM.create().toPlainDynamicObjectCollection(balFilterQtyAmountDs);
        return balCol;
    }

    private DataSet filterByMaterialGroup(DataSet balDs, DataSet materialGroupDs) {
        if (balDs.copy().isEmpty() || materialGroupDs == null || materialGroupDs.isEmpty()) {
            return balDs;
        }
        return balDs.join(materialGroupDs).on("material.id", "material").select(balDs.getRowMeta().getFieldNames(), new String[]{"group"}).finish();
    }

    private DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    private static int getBeginPeriod(DynamicObject costAccount) {
        if (costAccount == null) {
            return 0;
        }
        DynamicObject startPeriod = PeriodHelper.getSysCtrlEntity((Long)costAccount.getLong("id"));
        int peridNumber = 0;
        if (startPeriod != null) {
            Long startPeriodId = startPeriod.getLong("startperiod.id");
            DynamicObject peirod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)startPeriodId).toArray());
            peridNumber = peirod.getInt("periodyear") * 100 + peirod.getInt("periodnumber");
        }
        return peridNumber;
    }

    private void initParams(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startDate = this.filterInfo.getDate("startdate");
        this.filter_endDate = this.filterInfo.getDate("enddate");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.filter_billtype = this.filterInfo.getDynamicObjectCollection("mulbilltype");
        if (!"".equals(this.filterInfo.getString("billnoid").trim())) {
            this.filter_billno = this.filterInfo.getString("billnoid").split(" ");
        }
    }

    private QFilter getCostRecordFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_billtype != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_billtype) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_billno != null) {
            q.and("billno", "in", (Object)this.filter_billno);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entry.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entry.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entry.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entry.invstatus", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : this.filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("entry.material", "in", set);
            } else {
                q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getCostAdjustFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("billstatus", "=", (Object)"C");
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_billtype != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_billtype) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_billno != null) {
            q.and("billno", "in", (Object)this.filter_billno);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : this.filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("entryentity.material", "in", set);
            } else {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        return q;
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cal_billnos");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", " ");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }
}

