/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction.CalBalMapFunc;

public class CalBalTransform
implements IDataXTransform {
    private Integer period;

    public CalBalTransform(Integer period) {
        this.period = period;
    }

    public DataSetX doTransform(DataSetX srcData) {
        String dimFields = CalBalanceModelHelper.getDimFields((boolean)false).concat(",").concat("year").concat(",").concat("calorg").concat(",").concat("baseunit").concat(",").concat("currency").concat(",").concat("materialmodelnum").concat(",").concat("materialgroup");
        String[] groupSelectField = dimFields.split(",");
        ArrayList<String> fixGroup = new ArrayList<String>(Arrays.asList(groupSelectField));
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        srcData = balCompress ? srcData.groupBy(fixGroup.toArray(new String[fixGroup.size()])).sum("periodbeginqty").sum("periodbeginactualcost") : srcData.groupBy(fixGroup.toArray(new String[fixGroup.size()])).max("periodbeginqty").sum("periodbeginactualcost");
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Object> values = new ArrayList<Object>();
        fields.add(new Field("month", (DataType)DataType.IntegerType));
        fields.add(new Field("period", (DataType)DataType.IntegerType));
        fields.add(new Field("bizentityobject", (DataType)DataType.StringType));
        fields.add(new Field("yearincost", (DataType)DataType.BigDecimalType));
        fields.add(new Field("yearshow", (DataType)DataType.StringType));
        values.add(0);
        values.add(0);
        values.add("balance");
        values.add(BigDecimal.ZERO);
        values.add("");
        srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        srcData = srcData.map((MapFunction)new CalBalMapFunc(srcData.getRowMeta(), this.period));
        return srcData;
    }
}

