/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class BillNoFilterReduceGroupFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private StockDetailDailyRptParam param;
    private List<String> billEntity;

    public BillNoFilterReduceGroupFunc(RowMeta rowMeta, StockDetailDailyRptParam param, List<String> billEntity) {
        this.rowMeta = rowMeta;
        this.param = param;
        this.billEntity = billEntity;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        boolean billNoFilter = !this.getBillNos().isEmpty() || !this.getBillTypes().isEmpty();
        ArrayList<RowX> cur = new ArrayList<RowX>();
        boolean hasData = false;
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            String bizEntityObject = (String)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if (billNoFilter) {
                if (this.billEntity.contains(bizEntityObject)) {
                    hasData = true;
                }
                cur.add(row);
                continue;
            }
            collector.collect(row);
        }
        if (billNoFilter && hasData) {
            for (RowX rowX : cur) {
                collector.collect(rowX);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private Set<Long> getBillTypes() {
        HashSet<Long> billTypes = new HashSet<Long>();
        DynamicObjectCollection billtypes = this.param.getBilltypes();
        if (billtypes != null) {
            for (DynamicObject billtype : billtypes) {
                billTypes.add(billtype.getLong("id"));
            }
        }
        return billTypes;
    }

    private Set<String> getBillNos() {
        HashSet<String> cur = new HashSet<String>();
        String billno = this.param.getBillno();
        if (!StringUtils.isEmpty((String)billno)) {
            String[] billNoVal;
            for (String billNo : billNoVal = billno.split(",")) {
                if (StringUtils.isEmpty((String)billNo)) continue;
                cur.add(billNo);
            }
        }
        return cur;
    }
}

