/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;

public class CalBalanceMapFunc
extends MapFunction {
    private static final long serialVersionUID = -9121496405382351106L;
    private RowMeta rowMeta;
    private Integer period;

    public CalBalanceMapFunc(RowMeta rowMeta, Integer period) {
        this.rowMeta = rowMeta;
        this.period = period;
    }

    public RowX map(RowX rowX) {
        BigDecimal periodendactualcost = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodendactualcost");
        BigDecimal periodendqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodendqty");
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodbeginqty", periodendqty);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodbeginactualcost", periodendactualcost);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "yearshow", String.valueOf(this.period / 100));
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "year", this.period / 100);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "month", this.period % 100);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "period", this.period % 100);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "bizentityobject", "balance");
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

