/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class CostAdjustMapFunc
extends MapFunction {
    private static final long serialVersionUID = 877347271536998993L;
    private RowMeta rowMeta;
    private String billTypeName;
    private StockDetailDailyRptParam param;

    public CostAdjustMapFunc(RowMeta rowMeta, String billTypeName, StockDetailDailyRptParam param) {
        this.rowMeta = rowMeta;
        this.billTypeName = billTypeName;
        this.param = param;
    }

    public RowX map(RowX rowX) {
        String year;
        String biztype = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "calbilltype") == null ? "" : (String)StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "calbilltype");
        String accounttype = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "accounttype") == null ? "" : (String)StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "accounttype");
        String difftype = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "difftype") == null ? "" : (String)StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "difftype");
        String createtype = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "createtype") == null ? "" : (String)StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "createtype");
        BigDecimal adjustamt = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "adjustamt");
        Date auditdate = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "auditdate") == null ? null : (Date)StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "auditdate");
        Integer period = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "period").toString());
        Date bookdate = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "bookdate") == null ? null : (Date)StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "bookdate");
        String string = year = StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "year") == null ? "" : StockDetailDailyReportUtils.getRowValue(rowX, this.rowMeta, "year").toString();
        if ("A".equals(biztype)) {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "calbilltype", "IN");
        } else {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "calbilltype", "OUT");
        }
        if ("A".equals(biztype) && "D".equals(accounttype) && !"B".equals(difftype) && !"C1".equals(createtype)) {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodinamount", adjustamt);
        } else if ("A".equals(biztype) && !"D".equals(accounttype) && "B".equals(difftype)) {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodinamount", adjustamt);
        } else {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodinamount", BigDecimal.ZERO);
        }
        if ("B".equals(biztype) && "D".equals(accounttype) && !"B".equals(difftype) && !"C1".equals(createtype)) {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodoutamount", adjustamt);
        } else if ("B".equals(biztype) && !"D".equals(accounttype) && "B".equals(difftype)) {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodoutamount", adjustamt);
        } else {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodoutamount", BigDecimal.ZERO);
        }
        if ("A".equals(biztype)) {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodinamountbak", adjustamt);
        } else {
            StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodinamountbak", BigDecimal.ZERO);
        }
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "periodinqtybak", BigDecimal.ZERO);
        if (bookdate != null) {
            if (bookdate.compareTo(this.getPreDayDate(this.param.getBeginDate())) <= 0) {
                StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "bizentityobject", "cal_costadjust_subentity_pre");
            } else {
                StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "bizentityobject", "cal_costadjust_subentity_next");
            }
        }
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "srcobject", "costadjustbill");
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "billtypename", this.billTypeName);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "priorityorder_first", "1");
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "audittime", auditdate);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "month", period);
        StockDetailDailyReportUtils.setRowValue(rowX, this.rowMeta, "yearshow", year);
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private Date getPreDayDate(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, -1);
        instance.set(10, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        return instance.getTime();
    }
}

