/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class CostRecordMapFunc
extends MapFunction {
    private static final long serialVersionUID = 9106535641384786437L;
    private RowMeta rowMeta;
    private StockDetailDailyRptParam param;

    public CostRecordMapFunc(RowMeta rowMeta, StockDetailDailyRptParam param) {
        this.rowMeta = rowMeta;
        this.param = param;
    }

    public RowX map(RowX row) {
        String year;
        String calBillType = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "calbilltype") == null ? "" : (String)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "calbilltype");
        String accountType = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "accounttype") == null ? "" : (String)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "accounttype");
        BigDecimal baseqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "baseqty");
        BigDecimal standardcost = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "standardcost");
        BigDecimal actualcost = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "actualcost");
        BigDecimal unitstandardcost = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "unitstandardcost");
        BigDecimal unitactualcost = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "unitactualcost");
        Date auditdate = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "auditdate") == null ? null : (Date)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "auditdate");
        Integer period = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "period").toString());
        Date bookdate = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "bookdate") == null ? null : (Date)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "bookdate");
        String string = year = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "year") == null ? "" : StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "year").toString();
        if ("IN".equals(calBillType)) {
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinqty", baseqty);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinqtybak", baseqty);
        }
        if ("OUT".equals(calBillType)) {
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodoutqty", baseqty);
        }
        if ("IN".equals(calBillType)) {
            if ("D".equals(accountType)) {
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamount", standardcost);
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamountbak", standardcost);
            } else {
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamount", actualcost);
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamountbak", actualcost);
            }
        } else if ("OUT".equals(calBillType)) {
            if ("D".equals(accountType)) {
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodoutamount", standardcost);
            } else {
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodoutamount", actualcost);
            }
        }
        if ("D".equals(accountType)) {
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "unitprice", unitstandardcost);
        } else {
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "unitprice", unitactualcost);
        }
        if (bookdate != null) {
            if (bookdate.compareTo(this.getPreDayDate(this.param.getBeginDate())) <= 0) {
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "bizentityobject", "cal_costrecord_subentity_pre");
            } else {
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "bizentityobject", "cal_costrecord_subentity_next");
            }
        }
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "srcobject", "costrecord");
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "1");
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "audittime", auditdate);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "yearshow", year);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "month", period);
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private Date getPreDayDate(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, -1);
        instance.set(10, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        return instance.getTime();
    }
}

