/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class FilterGroupFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private StockDetailDailyRptParam param;

    public FilterGroupFunc(RowMeta rowMeta, StockDetailDailyRptParam param) {
        this.rowMeta = rowMeta;
        this.param = param;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        boolean noshowzeroinout = this.param.isNoshowzeroinout();
        boolean onlyshowsumrow = this.param.isOnlyshowsumrow();
        ArrayList<RowX> cur = new ArrayList<RowX>();
        boolean inOut = false;
        for (RowX rowX : iterable) {
            if (noshowzeroinout) {
                BigDecimal periodinqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodinqty");
                BigDecimal periodinamount = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodinamount");
                BigDecimal periodoutqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodoutqty");
                BigDecimal periodoutamount = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodoutamount");
                if (BigDecimal.ZERO.compareTo(periodinqty) != 0 || BigDecimal.ZERO.compareTo(periodinamount) != 0 || BigDecimal.ZERO.compareTo(periodoutqty) != 0 || BigDecimal.ZERO.compareTo(periodoutamount) != 0) {
                    inOut = true;
                }
            } else {
                inOut = true;
            }
            if (onlyshowsumrow) {
                int priorityorder = StringUtils.isEmpty((String)StockDetailDailyReportUtils.getStringDefaultOrValue(rowX, this.rowMeta, "priorityorder")) ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getStringDefaultOrValue(rowX, this.rowMeta, "priorityorder"));
                if (priorityorder == 0) continue;
                cur.add(rowX);
                continue;
            }
            cur.add(rowX);
        }
        if (inOut) {
            for (RowX rowX : cur) {
                collector.collect(rowX);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

