/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class FinalDataPriceMapFunc
extends MapFunction {
    private RowMeta rowMeta;
    private Set<String> color;

    public FinalDataPriceMapFunc(RowMeta rowMeta, Set<String> color) {
        this.rowMeta = rowMeta;
        this.color = color;
    }

    public RowX map(RowX rowX) {
        BigDecimal periodendprice;
        BigDecimal periodoutprice;
        BigDecimal periodinprice;
        BigDecimal unitprice = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "unitprice");
        String bizEntityObject = StockDetailUtils.getStringDefaultOrValue(rowX, this.rowMeta, "bizentityobject");
        BigDecimal periodinqty = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodinqty");
        BigDecimal periodinamount = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodinamount");
        BigDecimal bigDecimal = periodinprice = BigDecimal.ZERO.compareTo(periodinqty) == 0 ? BigDecimal.ZERO : periodinamount.divide(periodinqty, 10, RoundingMode.HALF_UP);
        if (BigDecimal.ZERO.compareTo(periodinqty) != 0 && BigDecimal.ZERO.compareTo(unitprice) != 0) {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinprice", unitprice);
        } else if (BigDecimal.ZERO.compareTo(periodinprice) != 0) {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinprice", periodinprice);
        }
        BigDecimal periodoutqty = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodoutqty");
        BigDecimal periodoutamount = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodoutamount");
        BigDecimal bigDecimal2 = periodoutprice = BigDecimal.ZERO.compareTo(periodoutqty) == 0 ? BigDecimal.ZERO : periodoutamount.divide(periodoutqty, 10, RoundingMode.HALF_UP);
        if (BigDecimal.ZERO.compareTo(periodoutqty) != 0 && BigDecimal.ZERO.compareTo(unitprice) != 0) {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodoutprice", unitprice);
        } else if (BigDecimal.ZERO.compareTo(periodoutprice) != 0) {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodoutprice", periodoutprice);
        }
        BigDecimal periodendqty = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodendqty");
        BigDecimal periodendamount = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodendamount");
        BigDecimal bigDecimal3 = periodendprice = BigDecimal.ZERO.compareTo(periodendqty) == 0 ? BigDecimal.ZERO : periodendamount.divide(periodendqty, 10, RoundingMode.HALF_UP);
        if (BigDecimal.ZERO.compareTo(periodendqty) == 0) {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodendprice", BigDecimal.ZERO);
        } else {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodendprice", periodendprice);
        }
        StockDetailUtils.setRowValue(rowX, this.rowMeta, "bizentityobject", bizEntityObject);
        if (this.color.contains(bizEntityObject)) {
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "linetype", "1");
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

