/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;

public class PeriodEndReduceGroupFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private String[] orderFields;
    private List<String> ignoreObjects;
    private boolean reSumStartPeriod;
    private String title;

    public PeriodEndReduceGroupFunc(RowMeta rowMeta, String[] orderFields, List<String> ignoreObjects, boolean reSumStartPeriod, String title) {
        this.rowMeta = rowMeta;
        this.orderFields = orderFields;
        this.ignoreObjects = ignoreObjects;
        this.reSumStartPeriod = reSumStartPeriod;
        this.title = title;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Object bizEntityObject;
        DataSet cur = this.createDataSet(iterable, this.rowMeta);
        cur = cur.orderBy(this.orderFields);
        BigDecimal preQty = BigDecimal.ZERO;
        BigDecimal preMoney = BigDecimal.ZERO;
        BigDecimal inQtySum = BigDecimal.ZERO;
        BigDecimal inAmtSum = BigDecimal.ZERO;
        BigDecimal outQtySum = BigDecimal.ZERO;
        BigDecimal outAmtSum = BigDecimal.ZERO;
        BigDecimal curPeriodEndQty = BigDecimal.ZERO;
        BigDecimal curPeriodEndAmt = BigDecimal.ZERO;
        RowX periodRow = null;
        Integer year = 0;
        Integer month = Integer.MIN_VALUE;
        Long material = 0L;
        Long costaccount = 0L;
        Long calorg = 0L;
        Long baseunit = 0L;
        Long currency = 0L;
        Long materialgroup = 0L;
        ArrayList<RowX> keep = new ArrayList<RowX>();
        for (Row r : cur) {
            RowX row = this.getRowx(r);
            year = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "year").toString());
            month = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "month") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "month").toString());
            material = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "material").toString());
            costaccount = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            calorg = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            baseunit = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "baseunit") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "baseunit").toString());
            currency = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "currency").toString());
            materialgroup = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "materialgroup") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "materialgroup").toString());
            String bizEntityObject2 = (String)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if ("period".equals(bizEntityObject2) && this.reSumStartPeriod) {
                periodRow = this.getRowx(r);
                StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "bizentityobject", "period_copy");
            }
            if (this.ignoreObjects.contains(bizEntityObject2)) {
                if (!this.reSumStartPeriod) continue;
                keep.add(row);
                continue;
            }
            BigDecimal periodinqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinqtybak");
            BigDecimal periodoutqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutqty");
            BigDecimal periodinamount = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinamountbak");
            BigDecimal periodoutamount = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutamount");
            if (!"period".equals(bizEntityObject2)) {
                inQtySum = inQtySum.add(periodinqty);
                inAmtSum = inAmtSum.add(periodinamount);
                outQtySum = outQtySum.add(periodoutqty);
                outAmtSum = outAmtSum.add(periodoutamount);
            }
            BigDecimal curPeriodQty = periodinqty.subtract(periodoutqty);
            BigDecimal curPeriodMoney = periodinamount.subtract(periodoutamount);
            curPeriodEndQty = preQty.add(curPeriodQty);
            curPeriodEndAmt = preMoney.add(curPeriodMoney);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodendqty", curPeriodEndQty);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodendamount", curPeriodEndAmt);
            preQty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodendqty");
            preMoney = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodendamount");
            collector.collect(row);
        }
        if (periodRow != null && this.reSumStartPeriod && "period".equals(bizEntityObject = (String)StockDetailDailyReportUtils.getRowValue(periodRow, this.rowMeta, "bizentityobject"))) {
            int periodYear = StockDetailDailyReportUtils.getRowValue(periodRow, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(periodRow, this.rowMeta, "year").toString());
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "baseunit", baseunit);
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "currency", currency);
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "yearshow", periodYear == 0 ? null : String.valueOf(periodYear));
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "periodendqty", curPeriodEndQty);
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "periodendamount", curPeriodEndAmt);
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "periodinqtybak", curPeriodEndQty);
            StockDetailDailyReportUtils.setRowValue(periodRow, this.rowMeta, "periodinamountbak", curPeriodEndAmt);
            collector.collect(periodRow);
        }
        if (!keep.isEmpty()) {
            for (RowX rowX : keep) {
                collector.collect(rowX);
            }
        }
        if (!this.reSumStartPeriod) {
            RowX row = new RowX(this.rowMeta.getFieldCount());
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "year", year);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "yearshow", String.valueOf(year));
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "material", material);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "period", null);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "month", month);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "costaccount", costaccount);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "calorg", calorg);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "baseunit", baseunit);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "currency", currency);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "materialgroup", materialgroup);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinqty", inQtySum);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamount", inAmtSum);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodoutqty", outQtySum);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodoutamount", outAmtSum);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodendqty", curPeriodEndQty);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodendamount", curPeriodEndAmt);
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "bizentityobject", "total");
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "1");
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "priorityorder", "2");
            StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "billtypename", this.title);
            collector.collect(row);
        }
    }

    public DataSet createDataSet(Iterable<RowX> iterable, RowMeta rowMeta) {
        Algo algo = Algo.create((String)"kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction.PeriodEndReduceGroupFunc");
        Iterator<RowX> funcIterator = iterable.iterator();
        return algo.createDataSet((Iterator)new RowXIterator(funcIterator), rowMeta);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }

    private static class RowXIterator
    implements Iterator<Object[]>,
    Serializable {
        private static final long serialVersionUID = -8990351274825611328L;
        private Iterator<RowX> iterable;

        RowXIterator(Iterator<RowX> iterable) {
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.iterable.hasNext();
        }

        @Override
        public Object[] next() {
            return this.iterable.next().values();
        }
    }
}

