/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class StartPeriodEmptyReduceFunc
extends GroupReduceFunction {
    private StockDetailDailyRptParam param;
    private RowMeta rowMeta;
    private String showTitle;
    private List<String> ignoreObjects;

    public StartPeriodEmptyReduceFunc(RowMeta rowMeta, StockDetailDailyRptParam param, String showTitle, List<String> ignoreObjects) {
        this.rowMeta = rowMeta;
        this.param = param;
        this.showTitle = showTitle;
        this.ignoreObjects = ignoreObjects;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap<Integer, List<Integer>> cur = new HashMap<Integer, List<Integer>>(16);
        Map<Integer, List<Integer>> yearAndPeriod = this.copyMap(this.param.getPeriodNumber());
        Long material = 0L;
        Long calorg = 0L;
        Long costaccount = 0L;
        Long baseunit = 0L;
        Long currency = 0L;
        Long materialgroup = 0L;
        for (RowX row : iterable) {
            String bizEntityObject = (String)StockDetailUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if (this.ignoreObjects.contains(bizEntityObject)) {
                collector.collect(row);
                continue;
            }
            int year = StockDetailUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "year").toString());
            Integer curPeriod = StockDetailUtils.getRowValue(row, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "period").toString());
            material = StockDetailUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "material").toString());
            costaccount = StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            calorg = StockDetailUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            baseunit = StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit") == null ? null : Long.valueOf(Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit").toString()));
            currency = StockDetailUtils.getRowValue(row, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "currency").toString());
            materialgroup = StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup") == null ? null : Long.valueOf(Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup").toString()));
            String bizentityobject = StockDetailUtils.getStringDefaultOrValue(row, this.rowMeta, "bizentityobject");
            if ("period".equals(bizentityobject)) {
                List<Integer> list;
                if (!cur.containsKey(year)) {
                    list = new ArrayList<Integer>(16);
                    list.add(curPeriod);
                    cur.put(year, list);
                } else {
                    list = (List)cur.get(year);
                    if (!list.contains(curPeriod)) {
                        list.add(curPeriod);
                    }
                }
            }
            collector.collect(row);
        }
        for (Map.Entry<Integer, List<Integer>> entry : yearAndPeriod.entrySet()) {
            Integer year = entry.getKey();
            List<Integer> totalPeriods = entry.getValue();
            List curPeriod = (List)cur.get(year);
            if (curPeriod != null) {
                totalPeriods.removeAll(curPeriod);
            }
            if (totalPeriods == null || totalPeriods.isEmpty()) continue;
            for (Integer restPeriod : totalPeriods) {
                RowX row = new RowX(this.rowMeta.getFieldCount());
                StockDetailUtils.setRowValue(row, this.rowMeta, "year", year);
                StockDetailUtils.setRowValue(row, this.rowMeta, "material", material);
                StockDetailUtils.setRowValue(row, this.rowMeta, "materialgroup", materialgroup);
                StockDetailUtils.setRowValue(row, this.rowMeta, "baseunit", baseunit);
                StockDetailUtils.setRowValue(row, this.rowMeta, "currency", currency);
                StockDetailUtils.setRowValue(row, this.rowMeta, "month", restPeriod);
                StockDetailUtils.setRowValue(row, this.rowMeta, "period", restPeriod);
                StockDetailUtils.setRowValue(row, this.rowMeta, "calorg", calorg);
                StockDetailUtils.setRowValue(row, this.rowMeta, "costaccount", costaccount);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqty", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodbeginqty", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamount", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodbeginactualcost", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqtybak", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamountbak", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "billtypename", this.showTitle);
                StockDetailUtils.setRowValue(row, this.rowMeta, "bizentityobject", "period");
                StockDetailUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "0");
                collector.collect(row);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public Map<Integer, List<Integer>> copyMap(List<Integer> periodNumber) {
        HashMap<Integer, List<Integer>> copy = new HashMap<Integer, List<Integer>>(16);
        for (Integer yearPeriod : periodNumber) {
            List<Integer> list;
            int year = yearPeriod / 100;
            int period = yearPeriod % 100;
            if (!copy.containsKey(year)) {
                list = new ArrayList<Integer>(16);
                list.add(period);
                copy.put(year, list);
                continue;
            }
            list = (List)copy.get(year);
            if (!list.contains(period)) {
                list.add(period);
            }
            copy.put(year, list);
        }
        return copy;
    }
}

