/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetaildailyrpt.mapfunction;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyReportUtils;
import kd.fi.cal.report.newreport.stockdetaildailyrpt.StockDetailDailyRptParam;

public class StartPeriodReduceGroupFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private String showField;
    private StockDetailDailyRptParam param;

    public StartPeriodReduceGroupFunc(RowMeta rowMeta, String showField, StockDetailDailyRptParam param) {
        this.rowMeta = rowMeta;
        this.showField = showField;
        this.param = param;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX row;
        BigDecimal periodbeginqtySum = BigDecimal.ZERO;
        BigDecimal periodbeginactualcostSum = BigDecimal.ZERO;
        List<Integer> periodNumber = this.param.getPeriodNumber();
        Collections.sort(periodNumber);
        Integer yearPeriod = periodNumber.get(0);
        Iterator<RowX> iterator = iterable.iterator();
        Integer year = 0;
        Integer month = 0;
        Long material = null;
        Long costaccount = null;
        Long calorg = null;
        Long baseunit = null;
        Long currency = null;
        Long materialgroup = 0L;
        Set<String> sedSpBills = this.param.getSedSpBills();
        Set<String> recSpBills = this.param.getRecSpBills();
        sedSpBills.addAll(recSpBills);
        while (iterator.hasNext()) {
            row = iterator.next();
            material = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "material").toString());
            costaccount = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            calorg = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            baseunit = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "baseunit") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "baseunit").toString());
            currency = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "currency").toString());
            materialgroup = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "materialgroup") == null ? 0L : Long.parseLong(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "materialgroup").toString());
            String bizEntityObject = (String)StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if ("balance".equals(bizEntityObject)) {
                year = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "year").toString());
                month = StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "month") == null ? 0 : Integer.parseInt(StockDetailDailyReportUtils.getRowValue(row, this.rowMeta, "month").toString());
                BigDecimal periodbeginqty = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodbeginqty");
                BigDecimal periodbeginactualcost = StockDetailDailyReportUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodbeginactualcost");
                periodbeginqtySum = periodbeginqtySum.add(periodbeginqty);
                periodbeginactualcostSum = periodbeginactualcostSum.add(periodbeginactualcost);
                continue;
            }
            HashSet<String> cur = new HashSet<String>();
            if (!sedSpBills.isEmpty()) {
                for (String sedSpBill : sedSpBills) {
                    if ("cal_costadjustbill".equals(sedSpBill)) {
                        sedSpBill = "cal_costadjust_subentity";
                    }
                    cur.add(sedSpBill);
                    cur.add(sedSpBill + "_pre");
                    cur.add(sedSpBill + "_next");
                }
                if (!cur.contains(bizEntityObject)) continue;
                collector.collect(row);
                continue;
            }
            collector.collect(row);
        }
        row = new RowX(this.rowMeta.getFieldCount());
        int yearValue = year == null ? 0 : Integer.parseInt(year.toString());
        int yearPeriodValue = yearPeriod == null ? 0 : Integer.parseInt(yearPeriod.toString());
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "year", yearValue == 0 ? yearPeriodValue / 100 : yearValue);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "yearshow", yearValue == 0 ? String.valueOf(yearPeriodValue / 100) : String.valueOf(yearValue));
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "material", material);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "materialgroup", materialgroup);
        int monthValue = month == null ? 0 : Integer.parseInt(month.toString());
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "month", monthValue == 0 ? yearPeriodValue % 100 : monthValue);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "period", monthValue == 0 ? yearPeriodValue % 100 : monthValue);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "costaccount", costaccount);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "calorg", calorg);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "baseunit", baseunit);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "currency", currency);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinqty", BigDecimal.ZERO);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodbeginqty", BigDecimal.ZERO);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamount", BigDecimal.ZERO);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodbeginactualcost", BigDecimal.ZERO);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinqtybak", periodbeginqtySum);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "periodinamountbak", periodbeginactualcostSum);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "billtypename", this.showField);
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "bizentityobject", "period");
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "0");
        StockDetailDailyReportUtils.setRowValue(row, this.rowMeta, "priorityorder", "0");
        collector.collect(row);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

