/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;

public class StockDetailUtils {
    public static BigDecimal getBigDecimalDefaultOrValue(RowX row, RowMeta rowMeta, String field) {
        return StockDetailUtils.getRowValue(row, rowMeta, field) == null || ((BigDecimal)StockDetailUtils.getRowValue(row, rowMeta, field)).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (BigDecimal)StockDetailUtils.getRowValue(row, rowMeta, field);
    }

    public static String getStringDefaultOrValue(RowX row, RowMeta rowMeta, String field) {
        return StockDetailUtils.getRowValue(row, rowMeta, field) == null ? "" : (String)StockDetailUtils.getRowValue(row, rowMeta, field);
    }

    public static Object getRowValue(RowX row, RowMeta rowMeta, String field) {
        return row.get(rowMeta.getFieldIndex(field));
    }

    public static Object getRowValue(Row row, RowMeta rowMeta, String field) {
        return row.get(rowMeta.getFieldIndex(field));
    }

    public static String getStringDefaultOrValue(Row row, RowMeta rowMeta, String field) {
        return StockDetailUtils.getRowValue(row, rowMeta, field) == null ? "" : (String)StockDetailUtils.getRowValue(row, rowMeta, field);
    }

    public static void setRowValue(RowX row, RowMeta rowMeta, String field, Object value) {
        row.set(rowMeta.getFieldIndex(field), value);
    }

    public static void calOrgChanged(IDataModel model) {
        model.setValue("mulstorageorg", null);
        model.setValue("mulowner", null);
        model.setValue("mulwarehouse", null);
        model.setValue("mullocation", null);
        DynamicObjectCollection calOrgs = (DynamicObjectCollection)model.getValue("mulcalorg");
        if (calOrgs == null) {
            model.setValue("costaccount", null);
        } else {
            HashSet<Long> costAccountsIds = new HashSet<Long>();
            for (DynamicObject baseData : calOrgs) {
                DynamicObject calOrg = baseData.getDynamicObject("fbasedataid");
                DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
                if (costAccount == null) continue;
                costAccountsIds.add(costAccount.getLong("id"));
            }
            if (!costAccountsIds.isEmpty()) {
                model.setValue("mulcostaccount", (Object)costAccountsIds.toArray());
            } else {
                model.setValue("mulcostaccount", null);
            }
            model.setValue("ownertypehead", (Object)"bos_org");
        }
    }

    public static List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stockdetail_newrpt");
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>(16);
        if (headFilters != null) {
            for (QFilter q : headFilters) {
                String property = q.getProperty();
                if ("costsubelement_ref_number".equals(property)) {
                    q.__setProperty("costsubelement.number");
                } else if ("costelement_ref_number".equals(property)) {
                    q.__setProperty("costelement.number");
                } else if ("material_ref_number".equals(property)) {
                    q.__setProperty("material.number");
                } else {
                    IDataEntityProperty p = entityType.findProperty(property);
                    if (null == p) continue;
                    if (p instanceof BasedataProp) {
                        String field = ((BasedataProp)p).getDisplayProp();
                        property = property + "." + field;
                    }
                    q.__setProperty(property);
                    List nests = q.getNests(true);
                    for (QFilter.QFilterNest net : nests) {
                        QFilter netFilter = net.getFilter();
                        StockDetailUtils.rebuildBalanceHeadFilter(netFilter, entityType);
                    }
                }
                newHeadFilters.add(q);
            }
        }
        return newHeadFilters;
    }

    private static void rebuildBalanceHeadFilter(QFilter filter, MainEntityType entityType) {
        String property = filter.getProperty();
        IDataEntityProperty p = entityType.findProperty(property);
        if (null == p) {
            return;
        }
        if (p instanceof BasedataProp) {
            String field = ((BasedataProp)p).getDisplayProp();
            property = property + "." + field;
        }
        filter.__setProperty(property);
    }
}

