/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.PrintHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.base.CalAuxptyFilterHelper;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;
import kd.fi.cal.report.newreport.stocksumlrpt.BplatReportUtil;

public class StockDetailNewRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private String queryType = null;
    private boolean isQueryByFilter = true;
    private static final Log logger = LogFactory.getLog(StockDetailNewRptFormPlugin.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private static String[] engage_fields = new String[]{"calorg", "owner", "storageorgunit", "warehouse", "materialgroupname", "accounttype", "assist", "auditdate", "audittime", "baseunit.name", "baseunit.number", "baseunitname", "billid", "billstatus", "billtypename", "bizdate", "bizentityobject", "calorg.name", "calorg.number", "calorgname", "configuredcode.desc", "configuredcode.number", "costaccount.name", "costaccount.number", "costaccountname", "costelement.name", "costelement.number", "costsubelement.name", "costsubelement.number", "createtype", "cur_index_adjust", "currency.amtprecision", "currency.isshowsign", "currency.name", "currency.number", "currency.priceprecision", "currency.sign", "difftype", "endperiod", "entryid", "isinitbill", "issplitcreate", "location.name", "location.number", "locationcode", "locationname", "material.name", "material.number", "materialgroup.longnumber", "materialgroup.name", "materialgroup.number", "materialgroupname", "materialgroupstandard.ispreset", "materialgroupstandard.name", "materialgroupstandard.number", "materialmodelnum", "materialname", "materialnumber", "month", "mversion.name", "mversion.number", "owner.name", "owner.number", "ownercode", "ownername", "ownertype", "period", "periodinamountbak", "periodinqtybak", "priorityorder", "priorityorder_first", "srcobject", "startperiod", "storageorgunit.name", "storageorgunit.number", "storageorgunitcode", "storageorgunitname", "warehouse.group.name", "warehouse.group.number", "warehouse.isopenlocation", "warehouse.name", "warehouse.number", "warehousecode", "warehousename", "warehsgroup.longnumber", "warehsgroup.name", "warehsgroup.number", "warehsgroupcode", "warehsgroupname", "year", "yearshow", "isvoucher", "comment", "billno", "bookdate", "projectname", "materialcategory.name", "materialcategory.number", "materialcategory.longnumber", "materialgroup.fullname", "materialmodelnum", "warehouse.group.fullname", "warehouse.group.longnumber", "warehsgroup.fullname", "tracknumber.name", "tracknumber.description", "diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y"};
    private static final List<String> headFieldList = Arrays.asList("material_ref_number", "material", "materialmodelnum");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulcalrange", "mulowner", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "mulowner", "materialgroupstandard", "mulmaterialgroup", "materialto", "multracknum", "mulnosumbiztype", "auxproperty", "auxdetailbd");
        CalAuxptyFilterHelper.addAuxdetailbasebdRegister((Object)this);
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    StockDetailNewRptFormPlugin.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            StockDetailUtils.calOrgChanged(this.getModel());
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            ReportUtil.materialGroupStdChanged((IDataModel)this.getModel());
        } else if ("mulmaterialgroup".equals(key)) {
            ReportUtil.materialGroupChanged((IDataModel)this.getModel());
        } else if ("mulnojoinsumrange".equals(key)) {
            this.getModel().setValue("mulnosumbiztype", null);
            String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
            if (StringUtils.isEmpty((String)mulnojoinsumrangeStr)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulnosumbiztype"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"mulnosumbiztype"});
            }
        } else if ("auxproperty".equals(key)) {
            CalAuxptyFilterHelper.handleAuxpropertyChangeEvent(newValue, rowIndex, (IFormView)this.getView());
        } else if ("auxdetailbasebd".equals(key)) {
            CalAuxptyFilterHelper.handleAuxdetailBdChagneEvent(newValue, rowIndex, this.getView().getModel());
        } else if ("mulsubelementfilter".equals(key)) {
            DynamicObjectCollection mulsubelementfilter = (DynamicObjectCollection)this.getModel().getValue("mulsubelementfilter");
            if (mulsubelementfilter != null && mulsubelementfilter.size() > 0) {
                this.getModel().setValue("showdetail", (Object)Boolean.TRUE);
            }
        } else if ("showdetail".equals(key)) {
            boolean showdetail = (Boolean)this.getModel().getValue("showdetail");
            if (!showdetail) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
                this.getModel().setValue("mulsubelementfilter", null);
            } else {
                String amountshowcondition = (String)this.getModel().getValue("amountshowcondition");
                String qtyshowcondition = (String)this.getModel().getValue("qtyshowcondition");
                boolean qtyOrAmt = !StringUtils.isEmpty((String)amountshowcondition) || !StringUtils.isEmpty((String)qtyshowcondition);
                this.setMulSubelementFilter(qtyOrAmt);
            }
        } else if ("qtyshowcondition".equals(key)) {
            String qtyshowcondition = (String)this.getModel().getValue("qtyshowcondition");
            String amountshowcondition = (String)this.getModel().getValue("amountshowcondition");
            boolean qtyOrAmt = !StringUtils.isEmpty((String)qtyshowcondition) || !StringUtils.isEmpty((String)amountshowcondition);
            this.setMulSubelementFilter(qtyOrAmt);
        } else if ("amountshowcondition".equals(key)) {
            String qtyshowcondition = (String)this.getModel().getValue("qtyshowcondition");
            String amountshowcondition = (String)this.getModel().getValue("amountshowcondition");
            boolean qtyOrAmt = !StringUtils.isEmpty((String)qtyshowcondition) || !StringUtils.isEmpty((String)amountshowcondition);
            this.setMulSubelementFilter(qtyOrAmt);
        }
    }

    private void setMulSubelementFilter(boolean qtyOrAmt) {
        if (qtyOrAmt) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
            this.getModel().setValue("mulsubelementfilter", null);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            ReportUtil.beforeF7Select4NewMulmaterial((IDataModel)this.getModel(), (BeforeF7SelectEvent)e, (String)"mulcalorg");
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("ownerto".equals(key)) {
            ReportUtil.beforeF7Select4ownerto((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("materialgroupstandard".equals(key)) {
            this.beforeMaterialgroupstandard(e);
        } else if ("mulmaterialgroup".equals(key)) {
            this.beforeF7SelectMaterialGroup(e);
        } else if ("multracknum".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("mulnosumbiztype".equals(key)) {
            this.beforeF7SelectMulnosumbiztype(e);
        } else if ("auxproperty".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxProperty(showParameter);
        } else if ("auxdetailbd".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxpropertydetail(showParameter, (IFormView)this.getView());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        this.isQueryByFilter = true;
        if ("bar_first".equals(key)) {
            this.queryType = "first";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_previous".equals(key)) {
            this.queryType = "previous";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_next".equals(key)) {
            this.queryType = "next";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_last".equals(key)) {
            this.queryType = "last";
            this.isQueryByFilter = false;
            this.getView().invokeOperation("refresh");
        } else if ("bar_viewbill".equals(key)) {
            this.viewBill();
        } else if ("refresh".equals(key)) {
            this.isQueryByFilter = false;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("printview".equals(key)) {
            this.printOperation();
        }
    }

    private void printOperation() {
        try {
            String templeteId;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
            HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)this.getView().getEntityId(), (String)"4730fc9e000000ac");
            boolean hasAll = rs.hasAllOrgPerm();
            List hasPermOrgs = rs.getHasPermOrgs();
            if (this.getModel().getValue("mulcalorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"StockDetailRptFormPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            Object calOrg = this.getModel().getValue("mulcalorg");
            DynamicObjectCollection calOrgs = (DynamicObjectCollection)calOrg;
            HashSet<Long> orgs = new HashSet<Long>();
            for (Object calOrgDynamic : calOrgs) {
                orgs.add(calOrgDynamic == null ? 0L : calOrgDynamic.getDynamicObject("fbasedataid").getLong("id"));
            }
            HashSet<Long> noPermOrgIds = new HashSet<Long>(16);
            for (Long id : orgs) {
                if (hasAll || hasPermOrgs == null || hasPermOrgs.contains(id)) continue;
                noPermOrgIds.add(id);
                return;
            }
            if (noPermOrgIds.size() > 0) {
                logger.info("print user has no permission==>{}", noPermOrgIds);
                return;
            }
            ReportView rptFormView = (ReportView)this.getExportAllView();
            if (rptFormView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
            int rowCount = listModel.getRowCount();
            if (rowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"StockDetailRptFormPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String formId = "cal_stockdetailrpt_newrpt";
            Object defaultTemplateId = PrintHelper.getDefaultTemplateId((String)formId);
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"StockDetailRptFormPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String printName = formId + "_printsetting";
            String curPrintPattern = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)printName);
            Map printSetting = null;
            if (!StringUtils.isEmpty((String)curPrintPattern)) {
                printSetting = (Map)SerializationUtils.fromJsonString((String)curPrintPattern, Map.class);
            }
            if (defaultTemplateId == null && (printSetting == null || printSetting.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            String string = printSetting == null || StringUtils.isEmpty((String)((String)printSetting.get("templateid"))) ? (defaultTemplateId == null ? null : defaultTemplateId.toString()) : (templeteId = (String)printSetting.get("templateid"));
            if (StringUtils.isEmpty((String)templeteId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"StockDetailRptFormPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                return;
            }
            PrintWork work = new PrintWork();
            PrintTask task = new PrintTask();
            task.setTplId(templeteId);
            task.setPageId(listModel.getPageId());
            task.setFormId("cal_stockdetailrpt_newrpt");
            task.setPrintType("report");
            task.setPkIds(null);
            work.setTaskList(Collections.singletonList(task));
            work.setPrintLang(RequestContext.get().getLang().getLangTag());
            work.setExpType("pdf");
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
            String url = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
            url = String.format(url, prtAttach.getTaskId(), ((PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0)).getAttachId());
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            logger.error("StockDetailRptFormPlugin printOperation", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u53ef\u80fd\u8d85\u65f6\u4e86\uff0c\u8bf7\u8bd5\u7740\u70b9\u4e0b\u5237\u65b0\u6309\u94ae\u3002", (String)"StockDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
    }

    public IFormView getExportAllView() {
        ReportQueryParam queryParam = this.getQueryParam();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        this.asyncQuery(queryParam, reportList, null);
        return reportList.getView();
    }

    private void asyncQuery(ReportQueryParam queryParam, ReportList reportList, String materialIds) {
        IReportCache var13 = ReportCacheManager.getInstance().getCache();
        var13.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)reportList.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        reportList.setAsynQuery(true);
        reportList.submitTask(queryParam, (Object)materialIds);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String mulnojoinsumrangeStr;
        DynamicObjectCollection calorgs = (DynamicObjectCollection)this.getModel().getValue("mulcalorg");
        DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calorgs == null || costAccount == null || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!this.hasPermission(userId, calorgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costAccount) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype,calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockDetailRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection mulnosumbiztype = (DynamicObjectCollection)this.getModel().getValue("mulnosumbiztype");
        if (mulnosumbiztype != null && mulnosumbiztype.size() > 0 && (null == (mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange")) || "".equals(mulnojoinsumrangeStr))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u201c\u4e0d\u53c2\u4e0e\u7edf\u8ba1\u7684\u4e1a\u52a1\u7c7b\u578b\u201d\u65f6\uff0c\u201c\u4e0d\u53c2\u4e0e\u7edf\u8ba1\u7684\u7279\u6b8a\u4e1a\u52a1\u8303\u56f4\u201d\u9700\u8981\u8f93\u5165\u3002", (String)"StockGatherRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Boolean> uncalbycostelementSet = new HashSet<Boolean>(16);
        for (DynamicObject calpolicy : costAccountInfoS) {
            boolean calbycostelement = calpolicy.getBoolean("calpolicy.calbycostelement");
            if (calbycostelement) continue;
            uncalbycostelementSet.add(calbycostelement);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean showdetail = dataEntity.getBoolean("showdetail");
        if (showdetail && !uncalbycostelementSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u975e\u5206\u9879\u7684\u8d26\u7c3f\uff0c\u4e0d\u5141\u8bb8\u5f00\u542f\u6309\u5206\u9879\u7ed3\u8f6c\u660e\u7ec6\u67e5\u770b", (String)"StockGatherRptFormPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private boolean hasPermission(Long userId, DynamicObjectCollection calorgs) {
        boolean flag = true;
        for (DynamicObject baseData : calorgs) {
            DynamicObject calOrg = baseData.getDynamicObject("fbasedataid");
            if (PermissionHelper.orgPermVerify((Long)userId, (String)"cal_stockdetailrpt_newrpt", (String)"47150e89000000ac", (Long)calOrg.getLong("id"))) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.getView().setVisible(Boolean.FALSE, new String[]{"showqtycols"});
        String firstQuery = this.getPageCache().get("firstQuery");
        if (StringUtils.isEmpty((String)firstQuery) || this.isQueryByFilter) {
            StringBuilder materialIdStr = new StringBuilder();
            DynamicObjectCollection balCol = this.getBDMaterials(queryParam);
            if (balCol == null || balCol.size() == 0) {
                String currentMateiralId = String.valueOf(-1L);
                this.getPageCache().put("materialIds", null);
                StockDetailRptParam param = this.createParam(queryParam);
                this.getQueryParam().getCustomParam().put(StockDetailNewRptFormPlugin.class.getName(), param);
                return;
            }
            HashSet<String> idSet = new HashSet<String>(balCol.size());
            for (DynamicObject balInfo : balCol) {
                String id = String.valueOf(balInfo.getLong("material.id"));
                if (!idSet.add(id)) continue;
                materialIdStr.append(id).append(',');
            }
        } else if (this.queryType != null) {
            String index = this.getPageCache().get("index");
            String materialIds = this.getPageCache().get("materialIds");
            String[] materialIdArray = materialIds.split(",");
            int indexInt = 0;
            if ("first".equals(this.queryType)) {
                indexInt = 0;
            } else if ("previous".equals(this.queryType)) {
                indexInt = Integer.parseInt(index) - 1;
            } else if ("next".equals(this.queryType)) {
                indexInt = Integer.parseInt(index) + 1;
            } else if ("last".equals(this.queryType)) {
                indexInt = materialIdArray.length - 1;
            }
        }
        StockDetailRptParam param = this.createParam(queryParam);
        this.getQueryParam().getCustomParam().put(StockDetailNewRptFormPlugin.class.getName(), param);
    }

    private DynamicObjectCollection getBDMaterials(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection filter_materialFrom = filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filterInfo.getDynamicObject("materialto");
        QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Object> set = new HashSet<Object>(16);
                for (DynamicObject dynamicObject : filter_materialFrom) {
                    set.add(dynamicObject.getPkValue());
                }
                q.and("id", "in", set);
            } else {
                q.and("number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("number", "<=", (Object)filter_materialTo.getString("number"));
        }
        DynamicObjectCollection dynamicObjects = null;
        if (filter_materialFrom != null || filter_materialTo != null) {
            dynamicObjects = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id as material.id", (QFilter[])new QFilter[]{q}, null);
        }
        return dynamicObjects;
    }

    private Map<Long, Long> getCostAccountAndCurrency(Set<Long> costaccountIdSet) {
        HashMap<Long, Long> currencyIdMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, calpolicy.currency", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        if (costAccountInfoS != null) {
            for (DynamicObject calpolicy : costAccountInfoS) {
                currencyIdMap.put(calpolicy.getLong("id"), calpolicy.getLong("calpolicy.currency"));
            }
        }
        return currencyIdMap;
    }

    private List<Integer> getPeriodNumber(int startPeriodValue, int endPeriodValue, DynamicObjectCollection costAccountObjects) {
        ArrayList<Integer> periods = new ArrayList<Integer>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (DynamicObject costAccountInfo : costAccountObjects) {
            Long id = costAccountInfo.get("id") == null ? 0L : costAccountInfo.getLong("id");
            costAccountIds.add(id);
        }
        DynamicObjectCollection costAccountInfos = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costAccountIds)});
        HashSet<Long> periodTypeIds = new HashSet<Long>(16);
        for (DynamicObject costAccountInfo : costAccountInfos) {
            Long id = costAccountInfo.get("calpolicy.periodtype") == null ? 0L : Long.parseLong(costAccountInfo.get("calpolicy.periodtype").toString());
            periodTypeIds.add(id);
        }
        QFilter qBegin = new QFilter("periodyear*100+periodnumber", ">=", (Object)startPeriodValue);
        qBegin.and("periodyear*100+periodnumber", "<=", (Object)endPeriodValue);
        qBegin.and("periodtype", "in", periodTypeIds);
        qBegin.and("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{qBegin}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            if (periods.contains(info.getInt("periodyear") * 100 + info.getInt("periodnumber"))) continue;
            periods.add(info.getInt("periodyear") * 100 + info.getInt("periodnumber"));
        }
        return periods;
    }

    private void setMaterialFilter(ReportQueryParam queryParam, String filterValue, String filterName) {
        if (queryParam.getFilter().getFilterItem(filterName) != null) {
            if (!"materialIds".equals(filterName)) {
                queryParam.getFilter().getFilterItem(filterName).setValue((Object)filterValue);
            }
        } else {
            queryParam.getFilter().addFilterItem(filterName, (Object)filterValue);
        }
    }

    private StockDetailRptParam createParam(ReportQueryParam queryParam) {
        StockDetailRptParam param = new StockDetailRptParam();
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection costAccountObject = filter.getDynamicObjectCollection("mulcostaccount");
        DynamicObject startPeriodObject = filter.getDynamicObject("startperiod");
        DynamicObject endPeriodObject = filter.getDynamicObject("endperiod");
        int startPeriodValue = startPeriodObject.getInt("periodyear") * 100 + startPeriodObject.getInt("periodnumber");
        int endPeriodValue = endPeriodObject.getInt("periodyear") * 100 + endPeriodObject.getInt("periodnumber");
        Date beginDate = startPeriodObject.getDate("begindate");
        Date endDate = endPeriodObject.getDate("enddate");
        Date filter_endStartDate = endPeriodObject.getDate("begindate");
        param.setFilter_endStartDate(filter_endStartDate);
        String ownerType = (String)filter.getValue("ownertypehead");
        DynamicObjectCollection ownerFrom = null;
        switch (ownerType) {
            case "bos_org": {
                ownerFrom = filter.getDynamicObjectCollection("mulowner");
                break;
            }
            case "bd_supplier": {
                ownerFrom = filter.getDynamicObjectCollection("mulsupplierownerfrom");
                break;
            }
            case "bd_customer": {
                ownerFrom = filter.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        DynamicObjectCollection calRange = filter.getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection storageOrgs = filter.getDynamicObjectCollection("mulstorageorg");
        Set warehouseGroupIds = ReportUtil.getWarehsGroupSet((FilterInfo)filter);
        DynamicObjectCollection warehouses = filter.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection locations = filter.getDynamicObjectCollection("mullocation");
        String[] lotIds = null;
        if (StringUtils.isNotEmpty((String)filter.getString("lotnumber"))) {
            lotIds = filter.getString("lotnumber").split(";");
        }
        DynamicObjectCollection projects = filter.getDynamicObjectCollection("mulproject");
        DynamicObjectCollection tracknumbers = filter.getDynamicObjectCollection("multracknum");
        DynamicObjectCollection invTypes = filter.getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection invStatuss = filter.getDynamicObjectCollection("mulinvstatus");
        String qtyShowCondition = filter.getString("qtyshowcondition");
        String amountShowCondition = filter.getString("amountshowcondition");
        String orderType = filter.getString("ordertype");
        String accountTypes = filter.getString("mulaccounttype");
        HashSet<String> accountTypeContainer = new HashSet<String>(16);
        if (accountTypes != null && accountTypes.length() != 0) {
            String[] accountTypeValues;
            for (String accountType : accountTypeValues = accountTypes.split(",")) {
                accountTypeContainer.add(accountType);
            }
        }
        Boolean onlyqueryemptygroup = filter.getBoolean("onlyqueryemptygroup");
        boolean onlyShowSumRow = filter.getBoolean("onlyshowsumrow");
        boolean topSumRow = filter.getBoolean("topsumrow");
        boolean noshowzeroinout = filter.getBoolean("noshowzeroinout");
        boolean showyeartotal = filter.getBoolean("showyeartotal");
        boolean showtotal = filter.getBoolean("showtotal");
        Long currencyId = filter.getDynamicObject("localcurrency").getLong("id");
        List<Integer> periodNumber = this.getPeriodNumber(startPeriodValue, endPeriodValue, costAccountObject);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        if (costAccountObject != null) {
            for (DynamicObject costAccount : costAccountObject) {
                long id = costAccount.getLong("id");
                costAccountIds.add(id);
            }
        }
        param.setCostaccountIdSet(costAccountIds);
        DynamicObjectCollection calOrgList = filter.getDynamicObjectCollection("mulcalorg");
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        if (calOrgList != null) {
            for (DynamicObject calOrg : calOrgList) {
                long id = calOrg.getLong("id");
                calOrgIds.add(id);
            }
        }
        param.setCalorgIdSet(calOrgIds);
        Map<Long, Long> costAccountAndCurrency = this.getCostAccountAndCurrency(costAccountIds);
        DynamicObjectCollection filter_materialFrom = filter.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filter.getDynamicObject("materialto");
        DynamicObject materialgroupstandard = filter.getDynamicObject("materialgroupstandard");
        DynamicObjectCollection materialgroup = filter.getDynamicObjectCollection("mulmaterialgroup");
        List<String> accountAndStartPeriod = this.getCostAccountAndStartPeriod(startPeriodObject);
        DynamicObjectCollection mulMatCategory = filter.getDynamicObjectCollection("mulmatcategory");
        boolean showdetail = filter.getBoolean("showdetail");
        DynamicObjectCollection subElements = filter.getDynamicObjectCollection("mulsubelementfilter");
        param.setCostAccountObject(costAccountObject);
        param.setStartPeriodValue(startPeriodValue);
        param.setStartPeriodObject(startPeriodObject);
        param.setEndPeriodObject(endPeriodObject);
        param.setEndPeriodValue(endPeriodValue);
        param.setBeginDate(beginDate);
        param.setEndDate(endDate);
        param.setOwnerFrom(ownerFrom);
        param.setOwnerType(ownerType);
        param.setCalRange(calRange);
        param.setStorageOrgs(storageOrgs);
        param.setWarehouseGroupIds(warehouseGroupIds);
        param.setWarehouses(warehouses);
        param.setLocations(locations);
        param.setLotIds(lotIds);
        param.setProjects(projects);
        param.setTracknumbers(tracknumbers);
        param.setInvTypes(invTypes);
        param.setInvStatuss(invStatuss);
        param.setCurrencyId(currencyId);
        param.setOrderType(orderType);
        param.setOnlyqueryemptygroup(onlyqueryemptygroup);
        param.setAccountTypeContainer(accountTypeContainer);
        param.setAccountTypes(accountTypes);
        param.setPeriodNumber(periodNumber);
        param.setIsNewBalance(this.isNewBalance);
        param.setOnlyshowsumrow(onlyShowSumRow);
        param.setTopsumrow(topSumRow);
        param.setQtyShowCondition(qtyShowCondition);
        param.setAmountShowCondition(amountShowCondition);
        param.setCostAccountAndCurrency(costAccountAndCurrency);
        param.setNoshowzeroinout(noshowzeroinout);
        param.setMaterialFrom(filter_materialFrom);
        param.setMaterialTo(filter_materialTo);
        param.setMaterialgroupstandard(materialgroupstandard);
        param.setMulmaterialgroup(materialgroup);
        param.setAccountAndStartPeriod(accountAndStartPeriod);
        param.setMatcategory(mulMatCategory);
        param.setShowyeartotal(showyeartotal);
        param.setShowtotal(showtotal);
        param.setShowDetail(showdetail);
        param.setSubElements(subElements);
        String mulnojoinsumrange = (String)this.getModel().getValue("mulnojoinsumrange");
        param.setMulnojoinsumrange(mulnojoinsumrange);
        HashSet<Long> mulnosumbiztypeIdSet = new HashSet<Long>();
        DynamicObjectCollection mulnosumbiztypes = filter.getDynamicObjectCollection("mulnosumbiztype");
        if (null != mulnosumbiztypes) {
            for (DynamicObject mulnosumbiztype : mulnosumbiztypes) {
                mulnosumbiztypeIdSet.add(mulnosumbiztype.getLong("id"));
            }
        }
        param.setMulnosumbiztypeIdSet(mulnosumbiztypeIdSet);
        HashSet<String> mulbizbillstrSet = new HashSet<String>();
        BplatReportUtil.setMulNoSumBiztypeSet(mulnojoinsumrange, mulbizbillstrSet);
        param.setMulbizbillstrSet(mulbizbillstrSet);
        boolean mulbeginconoutnoindata = filter.getBoolean("mulbeginconoutnoindata");
        param.setMulbeginconoutnoindata(mulbeginconoutnoindata);
        List<Object> auxptyIds = CalAuxptyFilterHelper.getAuxptyIds(this.getView().getModel());
        param.setAuxptyIds(auxptyIds);
        boolean noShowZero = filter.getBoolean("noshowzero");
        param.setNoShowZero(noShowZero);
        List headFilters = queryParam.getFilter().getHeadFilters();
        List<QFilter> balanceHeadFilters = StockDetailUtils.getBalanceHeadFilters(headFilters);
        param.setValueFilter(balanceHeadFilters);
        return param;
    }

    private List<String> getCostAccountAndStartPeriod(DynamicObject startPeriodObject) {
        ArrayList<String> accountAndStartPeriodYearMonth = new ArrayList<String>(16);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>(16);
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Map startPeriods = PeriodHelper.getStartPeriods(calOrgIds);
            for (Map.Entry entry : startPeriods.entrySet()) {
                int period;
                int year;
                Long costAccountId = (Long)entry.getKey();
                DynamicObject startPeriod = (DynamicObject)entry.getValue();
                int periodyear = 0;
                int periodnumber = 0;
                if (startPeriod != null) {
                    periodyear = startPeriod.getInt("periodyear");
                    periodnumber = startPeriod.getInt("periodnumber");
                }
                if (periodyear * 100 + periodnumber < (year = startPeriodObject.getInt("periodyear")) * 100 + (period = startPeriodObject.getInt("periodnumber"))) {
                    periodyear = year;
                    periodnumber = period;
                }
                accountAndStartPeriodYearMonth.add(costAccountId + "#" + periodyear + "#" + periodnumber);
            }
        }
        return accountAndStartPeriodYearMonth;
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Owner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costAccounts != null && !costAccounts.isEmpty()) {
            HashSet<Long> ownerIds = new HashSet<Long>();
            for (DynamicObject costAccount : costAccounts) {
                Long[] owner = AccountingSysHelper.getOwners((Long)costAccount.getLong("id"));
                if (owner == null || owner.length == 0) continue;
                List<Long> owners = Arrays.asList(owner);
                ownerIds.addAll(owners);
            }
            if (!ownerIds.isEmpty()) {
                q = new QFilter("id", "in", ownerIds);
            }
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costaccounts != null && costaccounts.size() > 0) {
            HashSet<Long> costaccountIdSet = new HashSet<Long>();
            for (DynamicObject costaccount : costaccounts) {
                costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("costaccount", "in", costaccountIdSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockdetailrpt_newrpt", (String)"47150e89000000ac");
        if (list != null) {
            logger.info("List \u4e0d\u4e3anull,\u5b58\u8d27\u6536\u53d1\u5b58\u660e\u7ec6\u8868-\u6838\u7b97\u7ec4\u7ec7List: " + list + " size: " + list.size());
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else {
            logger.info("List\u4e3anull,\u5b58\u8d27\u6536\u53d1\u5b58\u660e\u7ec6\u8868-\u6838\u7b97\u7ec4\u7ec7");
        }
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        if (orgIds.isEmpty()) {
            params.put("isShowAllNoOrg", "true");
            formShowParameter.setCustomParams(params);
        } else {
            params.put("useOrgs", orgIds);
            formShowParameter.setCustomParams(params);
        }
        formShowParameter.getListFilterParameter().getQFilters().add(qFilter.and(serviceResponse));
    }

    private void beforeMaterialgroupstandard(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            return;
        }
        HashSet materialIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
            materialIdSet.addAll(ids);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", materialIdSet));
    }

    private void beforeF7SelectMulnosumbiztype(BeforeF7SelectEvent e) {
        String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
        HashSet<String> mulnosumbiztypeSet = new HashSet<String>(16);
        BplatReportUtil.setMulNoSumBiztypeSet(mulnojoinsumrangeStr, mulnosumbiztypeSet);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("billentity.billform", "in", mulnosumbiztypeSet);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Object> idList = new ArrayList<Object>(bizTypes.size());
        for (DynamicObject bizType : bizTypes) {
            idList.add(bizType.get("id"));
        }
        QFilter idf = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(idf.toArray()));
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        QFilter q = this.getCostAccountNextPeriodOf(costAccounts);
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private QFilter getCostAccountNextPeriodOf(DynamicObjectCollection costAccounts) {
        if (costAccounts == null) {
            return new QFilter("id", "=", (Object)-1L);
        }
        ArrayList<Long> costAccountIds = new ArrayList<Long>(16);
        for (DynamicObject costAccount : costAccounts) {
            DynamicObject baseData = costAccount.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            costAccountIds.add(baseData.getLong("id"));
        }
        QFilter q = null;
        if (!costAccountIds.isEmpty()) {
            QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIds);
            String fields = "entry.startperiod as id,entry.calpolicy.periodtype as periodtype,entry.startperiod.periodyear as periodyear,entry.startperiod.periodnumber as periodnumber";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"entry.startperiod");
            boolean flag = true;
            for (Row row : dataSet) {
                Long periodtype = row.getLong("periodtype");
                Integer periodyear = row.getInteger("periodyear");
                Integer periodnumber = row.getInteger("periodnumber");
                QFilter filterType = new QFilter("periodtype.id", "=", (Object)periodtype);
                QFilter filterYear = new QFilter("periodyear", "=", (Object)periodyear);
                QFilter filterNum = new QFilter("periodnumber", ">=", (Object)periodnumber);
                QFilter pfilter = filterYear.and(filterNum);
                QFilter pYear = new QFilter("periodyear", ">", (Object)periodyear);
                pfilter.or(pYear);
                QFilter q1 = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
                q = filterType.and(pfilter).and(q1);
                if (!flag) continue;
                break;
            }
        }
        return q;
    }

    private QFilter getBalFilter(ReportQueryParam queryParam) {
        HashSet<Object> set;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection costAccounts = filterInfo.getDynamicObjectCollection("mulcostaccount");
        DynamicObjectCollection filter_owner = filterInfo.getDynamicObjectCollection("mulowner");
        DynamicObjectCollection filter_mulcalrange = filterInfo.getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection filter_storageOrg = filterInfo.getDynamicObjectCollection("mulstorageorg");
        DynamicObjectCollection filter_warehouse = filterInfo.getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = filterInfo.getDynamicObjectCollection("mullocation");
        DynamicObjectCollection filter_materialFrom = filterInfo.getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = filterInfo.getDynamicObject("materialto");
        String filter_mulaccounttype = filterInfo.getString("mulaccounttype");
        String[] filter_lot = null;
        String lotnumber = filterInfo.getString("lotnumber");
        Set warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        if (StringUtils.isNotEmpty((String)lotnumber)) {
            filter_lot = lotnumber.split(";");
        }
        DynamicObjectCollection filter_project = queryParam.getFilter().getDynamicObjectCollection("mulproject");
        DynamicObjectCollection filter_invType = queryParam.getFilter().getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection filter_invStatus = queryParam.getFilter().getDynamicObjectCollection("mulinvstatus");
        HashSet<Long> costAccountIds = new HashSet<Long>();
        for (DynamicObject costAccount : costAccounts) {
            Long costAccountId = costAccount.getPkValue() == null ? 0L : Long.parseLong(costAccount.getPkValue().toString());
            costAccountIds.add(costAccountId);
        }
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        if (filter_owner != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and("owner", "in", set);
        }
        if (filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", (Object)warehsGroupSet);
        }
        if (filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (filter_lot != null) {
            q.and("lot", "in", (Object)filter_lot);
        }
        if (filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("material", "in", set);
            } else {
                q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        if (filter_mulcalrange != null) {
            set = new HashSet();
            for (DynamicObject dynamicObject : filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        if (StringUtils.isNotEmpty((String)filter_mulaccounttype)) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : filter_mulaccounttype.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("accounttype", "in", accounttypes);
            }
        }
        return q;
    }

    private void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject row = evt.getRowData();
        String billId = row.getString("billid");
        if ("0".equals(billId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bizEntityObject = row.getString("bizentityobject");
        if (StringUtils.isEmpty((String)bizEntityObject)) {
            return;
        }
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewBill() {
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        this.getModel().setValue("mulcalrange", null);
        this.getModel().setValue("mulowner", null);
        this.getModel().setValue("mulsupplierownerfrom", null);
        this.getModel().setValue("mulcustomerownerfrom", null);
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        HashSet<Object> calpolicyIdSet = new HashSet<Object>();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            calpolicyIdSet.add(costaccount.getDynamicObject("fbasedataid").getDynamicObject("calpolicy").getPkValue());
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        HashSet<Long> periodIds = new HashSet<Long>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            periodIds.add(period.getLong("id"));
        }
        if (periodIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long minid = (Long)Collections.min(periodIds);
        this.getModel().setValue("startperiod", (Object)(periodIds.size() == 0 ? null : minid));
        this.getModel().setValue("endperiod", (Object)(periodIds.size() == 0 ? null : maxid));
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockdetailrpt_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.resetFilterGrid();
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getView().getModel(), (IFormView)this.getView());
        boolean showdetail = (Boolean)this.getModel().getValue("showdetail");
        if (showdetail) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
            this.getModel().setValue("mulsubelementfilter", null);
        }
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(StockDetailRptParam.class.getName());
        if (!StringUtils.isEmpty((String)openParamStr)) {
            StockDetailRptParam stockDetailRptParam = (StockDetailRptParam)SerializationUtils.fromJsonString((String)openParamStr, StockDetailRptParam.class);
            if (stockDetailRptParam != null && stockDetailRptParam.getCondition() != null) {
                filterGrid.SetValue(stockDetailRptParam.getCondition());
            }
            if (null == stockDetailRptParam) {
                CalAuxptyFilterHelper.setAuxEntryEnable(this.getView().getModel(), (IFormView)this.getView());
            } else {
                CalAuxptyFilterHelper.buildDetailAuxptyEntry(stockDetailRptParam, this.getModel(), this.getView());
            }
        }
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        HashSet<String> set = new HashSet<String>(Arrays.asList(engage_fields));
        for (Map info : filterColumns) {
            String fieldName = (String)info.get("fieldName");
            if (set.contains(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private DataSet filterByQtyCondition(DataSet balDs, String qtyShowCondition) {
        if (StringUtils.isNotEmpty((String)qtyShowCondition)) {
            String sign = "";
            if ("A".equals(qtyShowCondition)) {
                sign = "=";
            } else if ("B".equals(qtyShowCondition)) {
                sign = "<>";
            } else if ("C".equals(qtyShowCondition)) {
                sign = ">";
            } else if ("D".equals(qtyShowCondition)) {
                sign = "<";
            }
            balDs = balDs.filter("periodendqty " + sign + " 0");
        }
        return balDs;
    }

    private DataSet filterByAmountCondition(DataSet balDs, String amountShowCondition) {
        if (StringUtils.isNotEmpty((String)amountShowCondition)) {
            String sign = "";
            if ("A".equals(amountShowCondition)) {
                sign = "=";
            } else if ("B".equals(amountShowCondition)) {
                sign = "<>";
            } else if ("C".equals(amountShowCondition)) {
                sign = ">";
            } else if ("D".equals(amountShowCondition)) {
                sign = "<";
            }
            balDs = balDs.filter("periodendactualcost " + sign + " 0");
        }
        return balDs;
    }

    private DynamicObjectCollection getBalMaterialDycs(ReportQueryParam queryParam) {
        DynamicObject startPeriod = queryParam.getFilter().getDynamicObject("startperiod");
        DynamicObject endPeriod = queryParam.getFilter().getDynamicObject("endperiod");
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        QFilter inOutFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        String balEntity = "cal_balance";
        if (this.isNewBalance) {
            balEntity = "cal_bal";
        }
        if (queryParam.getFilter().getBoolean("noshowzeroinout")) {
            inOutFilter.and("period", ">=", (Object)startPeriodNumber);
            inOutFilter.and("period", "<=", (Object)endPeriodNumber);
            if (this.isNewBalance) {
                inOutFilter.and(QFilter.of((String)"baseqty_in <> 0 or actualcost_in <> 0 or baseqty_out <> 0 or actualcost_out <> 0", (Object[])new Object[0]));
            } else {
                inOutFilter.and(QFilter.of((String)"periodinqty <> 0 or periodinactualcost <> 0 or periodissueqty <> 0 or periodissueactualcost <> 0", (Object[])new Object[0]));
            }
            DynamicObjectCollection inOutMaterials = QueryServiceHelper.query((String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter});
            HashSet<Long> inOutMaterialIds = new HashSet<Long>(inOutMaterials.size());
            for (DynamicObject inOutMaterial : inOutMaterials) {
                Long materialId = inOutMaterial.getLong("material.id");
                inOutMaterialIds.add(materialId);
            }
            QFilter q = new QFilter("material.id", "in", inOutMaterialIds);
            QFilter[] qFilters = new QFilter[]{q};
            return this.filterQtyAndAmount(qFilters, queryParam);
        }
        DynamicObjectCollection materials = QueryServiceHelper.query((String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)});
        HashSet<Long> materialIds = new HashSet<Long>(materials.size());
        for (DynamicObject material : materials) {
            Long materialId = material.getLong("material.id");
            materialIds.add(materialId);
        }
        inOutFilter.and("period", ">=", (Object)startPeriodNumber);
        inOutFilter.and("period", "<=", (Object)endPeriodNumber);
        if (this.isNewBalance) {
            inOutFilter.and(QFilter.of((String)"baseqty_in <> 0 or actualcost_in <> 0 or baseqty_out <> 0 or actualcost_out <> 0", (Object[])new Object[0]));
        } else {
            inOutFilter.and(QFilter.of((String)"periodinqty <> 0 or periodinactualcost <> 0 or periodissueqty <> 0 or periodissueactualcost <> 0", (Object[])new Object[0]));
        }
        DynamicObjectCollection inOutMaterials = QueryServiceHelper.query((String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter});
        HashSet<Long> inOutMaterialIds = new HashSet<Long>(inOutMaterials.size());
        for (DynamicObject inOutMaterial : inOutMaterials) {
            Long materialId = inOutMaterial.getLong("material.id");
            inOutMaterialIds.add(materialId);
        }
        HashSet noInOutMaterials = new HashSet(materialIds);
        noInOutMaterials.removeAll(inOutMaterialIds);
        QFilter q1 = new QFilter("material.id", "in", noInOutMaterials);
        q1.and("period", "<", (Object)startPeriodNumber);
        q1.and("endperiod", ">=", (Object)startPeriodNumber);
        if (this.isNewBalance) {
            q1.and(QFilter.of((String)"baseqty_bal <> 0 or actualcost_bal <> 0", (Object[])new Object[0]));
        } else {
            q1.and(QFilter.of((String)"periodendqty <> 0 or periodendactualcost <> 0", (Object[])new Object[0]));
        }
        DynamicObjectCollection hasEndMaterials = QueryServiceHelper.query((String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{q1, this.getBalFilter(queryParam)});
        HashSet<Long> hasBeginEndMaterialIds = new HashSet<Long>(inOutMaterialIds.size());
        for (DynamicObject hasBeginMaterial : hasEndMaterials) {
            Long materialId = hasBeginMaterial.getLong("material.id");
            hasBeginEndMaterialIds.add(materialId);
        }
        QFilter q2 = QFilter.of((String)"period != 0", (Object[])new Object[0]).and("period", "<=", (Object)startPeriodNumber);
        if (this.isNewBalance) {
            q2.and(QFilter.of((String)"baseqty <> 0 or actualcost <> 0 ", (Object[])new Object[0]));
            q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"baseqty <> 0 or actualcost <> 0 ", (Object[])new Object[0])));
        } else {
            q2.and(QFilter.of((String)"periodbeginqty <> 0 or periodbeginactualcost <> 0 ", (Object[])new Object[0]));
            q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"periodbeginqty <> 0 or periodbeginactualcost <> 0 ", (Object[])new Object[0])));
        }
        DynamicObjectCollection hasBeginMaterials = QueryServiceHelper.query((String)balEntity, (String)"material.id", (QFilter[])new QFilter[]{q2, this.getBalFilter(queryParam)});
        for (DynamicObject hasBeginMaterial : hasBeginMaterials) {
            Long materialId = hasBeginMaterial.getLong("material.id");
            hasBeginEndMaterialIds.add(materialId);
        }
        hasBeginEndMaterialIds.addAll(inOutMaterialIds);
        QFilter q3 = new QFilter("material.id", "in", hasBeginEndMaterialIds);
        QFilter[] qFilters = new QFilter[]{q3};
        return this.filterQtyAndAmount(qFilters, queryParam);
    }

    private DynamicObjectCollection filterQtyAndAmount(QFilter[] qFilters, ReportQueryParam queryParam) {
        DataSet balDs = null;
        if (this.isNewBalance) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)(CalBalanceModelHelper.getDimFields((boolean)true) + ",material.id,material.number,baseqty_in as periodinqty,actualcost_in as periodinactualcost,baseqty_out as periodissueqty,actualcost_out as periodissueactualcost,baseqty_bal as periodendqty,actualcost_bal as periodendactualcost"), (QFilter[])qFilters, null);
            balDs = dataSet.groupBy((CalBalanceModelHelper.getDimFields((boolean)false) + ",material.id,material.number").split(",")).max("periodinqty").sum("periodinactualcost").max("periodissueqty").sum("periodissueactualcost").max("periodendqty").sum("periodendactualcost").finish().orderBy(new String[]{"material.number"});
        } else {
            balDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"material.id,material.number,periodinqty,periodinactualcost,periodissueqty,periodissueactualcost,periodendqty,periodendactualcost", (QFilter[])qFilters, (String)"material.number");
        }
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        DynamicObjectCollection filter_materialgroupfrom = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        boolean notShowMaterialGroup = materialgroupstandard == null && (filter_materialgroupfrom == null || filter_materialgroupfrom.size() < 1);
        DataSet materialGroupDs = ReportUtil.getClassifiedMaterialDataSet((FilterInfo)filterInfo, (boolean)notShowMaterialGroup, (DynamicObject)materialgroupstandard);
        balDs = this.filterByMaterialGroup(balDs, materialGroupDs);
        DataSet balFilterQtyAmountDs = balDs.groupBy(new String[]{"material.id", "material.number"}).sum("periodinqty").sum("periodinactualcost").sum("periodissueqty").sum("periodissueactualcost").sum("periodendqty").sum("periodendactualcost").finish();
        balFilterQtyAmountDs = this.filterByQtyCondition(balFilterQtyAmountDs, queryParam.getFilter().getString("qtyshowcondition"));
        balFilterQtyAmountDs = this.filterByAmountCondition(balFilterQtyAmountDs, queryParam.getFilter().getString("amountshowcondition"));
        balFilterQtyAmountDs = balFilterQtyAmountDs.orderBy(new String[]{"material.number"});
        DynamicObjectCollection balCol = ORM.create().toPlainDynamicObjectCollection(balFilterQtyAmountDs);
        return balCol;
    }

    private DataSet filterByMaterialGroup(DataSet balDs, DataSet materialGroupDs) {
        if (balDs.copy().isEmpty() || materialGroupDs == null || materialGroupDs.isEmpty()) {
            return balDs;
        }
        return balDs.join(materialGroupDs).on("material.id", "material").select(balDs.getRowMeta().getFieldNames(), new String[]{"group"}).finish();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String mulnojoinsumrangeStr = (String)this.getModel().getValue("mulnojoinsumrange");
        if (StringUtils.isEmpty((String)mulnojoinsumrangeStr)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulnosumbiztype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulnosumbiztype"});
        }
        boolean showdetail = (Boolean)this.getModel().getValue("showdetail");
        if (showdetail) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulsubelementfilter"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulsubelementfilter"});
            this.getModel().setValue("mulsubelementfilter", null);
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            String columnName = event.getColumnName();
            if (!headFieldList.contains(columnName)) continue;
            event.setFilter(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getModel(), (IFormView)this.getView());
    }

    public void click(EventObject evt) {
        CalAuxptyFilterHelper.click(evt, (IFormPlugin)this, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        CalAuxptyFilterHelper.closedCallBack(evt, this.getView());
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        CalAuxptyFilterHelper.loadOtherEntryFilter(scheme, this.getView().getModel(), this.getView());
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        CalAuxptyFilterHelper.saveEntryFilter((IFormView)this.getView(), "auxentry");
    }
}

