/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.handler;

import java.util.HashSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;

public class AddMaterialGroupTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private StockDetailRptParam param;

    public AddMaterialGroupTransform(ReportDataCtx ctx, StockDetailRptParam param) {
        this.ctx = ctx;
        this.param = param;
    }

    public DataSetX doTransform(DataSetX srcData) {
        boolean notShowMaterialGroup;
        DynamicObject materialgroupstandard1 = this.param.getMaterialgroupstandard();
        DynamicObjectCollection mulmaterialgroup = this.param.getMulmaterialgroup();
        boolean bl = notShowMaterialGroup = materialgroupstandard1 == null && (mulmaterialgroup == null || mulmaterialgroup.size() < 1);
        if (notShowMaterialGroup) {
            return srcData;
        }
        Object pkValue = 730148448254487552L;
        DynamicObject materialgroupstandard = this.param.getMaterialgroupstandard();
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        DynamicObjectCollection materialgroup = this.param.getMulmaterialgroup();
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(ReportUtil.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)false, (String)"group.longnumber"));
        }
        OrmInput input = new OrmInput("handleMaterialGroup", "bd_materialgroupdetail", "group,material,material.number as materialnumber", filter.toArray());
        DataSetX groupData = this.ctx.getCurrentJob().fromInput((Input)input);
        groupData = groupData.orderBy(new String[]{"group desc"});
        QFilter materialNumberFilter = this.getMaterialFromToFilter();
        if (materialNumberFilter != null) {
            String materialNumberFilterStr = materialNumberFilter.toString();
            groupData = groupData.filter(materialNumberFilterStr);
        }
        srcData = srcData.join(groupData).on("material", "material").select(srcData.getRowMeta().getFieldNames(), new String[]{"group"});
        return srcData;
    }

    private QFilter getMaterialFromToFilter() {
        DynamicObjectCollection materialfrom = this.param.getMaterialFrom();
        if (materialfrom != null) {
            if (materialfrom.size() == 0) {
                return null;
            }
            if (materialfrom.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : materialfrom) {
                    idSet.add(from.get("number"));
                }
                return new QFilter("materialnumber", "in", idSet);
            }
            DynamicObject from = (DynamicObject)materialfrom.get(0);
            DynamicObject to = this.param.getMaterialTo();
            QFilter filter = new QFilter("materialnumber", ">=", from.get("number"));
            if (to != null) {
                filter.and("materialnumber", "<=", to.get("number"));
            }
            return filter;
        }
        DynamicObject to = this.param.getMaterialTo();
        QFilter filter = null;
        if (to != null) {
            filter = new QFilter("materialnumber", "<=", to.get("number"));
        }
        return filter;
    }
}

