/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.handler;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.CalBalReduceFunc;

public class CalBalTransform
implements IDataXTransform {
    private Integer period;
    private String[] group;

    public CalBalTransform(Integer period, String[] group) {
        this.period = period;
        this.group = group;
    }

    public DataSetX doTransform(DataSetX srcData) {
        String dimFields = CalBalanceModelHelper.getDimFields((boolean)false).concat(",").concat("year").concat(",").concat("calorg").concat(",").concat("baseunit").concat(",").concat("currency").concat(",").concat("materialmodelnum").concat(",").concat("materialgroup").concat(",").concat("yearshow").concat(",").concat("month").concat(",").concat("period").concat(",").concat("bizentityobject");
        String[] groupSelectField = dimFields.split(",");
        ArrayList<String> fixGroup = new ArrayList<String>(Arrays.asList(groupSelectField));
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        srcData = !balCompress ? srcData.groupBy(fixGroup.toArray(new String[fixGroup.size()])).max("periodbeginqty").sum("periodbeginactualcost") : srcData.groupBy(fixGroup.toArray(new String[fixGroup.size()])).sum("periodbeginqty").sum("periodbeginactualcost");
        srcData = srcData.groupBy(this.group).reduceGroup((GroupReduceFunction)new CalBalReduceFunc(srcData.getRowMeta(), this.period));
        return srcData;
    }
}

