/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.entity.balance.BizDataType;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.CalBalanceReduceFunc;

public class CalBalanceTransform
implements IDataXTransform {
    private Integer period;
    private String[] group;
    private StockDetailRptParam param;

    public CalBalanceTransform(Integer period, String[] group, StockDetailRptParam param, ReportDataCtx ctx) {
        this.period = period;
        this.group = group;
        this.param = param;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.param.isShowDetail()) {
            String dimFields = CalBalanceTransform.getDimField().concat(",").concat("year").concat(",").concat("costaccount").concat(",").concat("calorg").concat(",").concat("baseunit").concat(",").concat("currency").concat(",").concat("materialmodelnum").concat(",").concat("materialgroup").concat(",").concat("yearshow").concat(",").concat("month").concat(",").concat("period").concat(",").concat("bizentityobject");
            String[] groupSelectField = dimFields.split(",");
            ArrayList<String> fixGroup = new ArrayList<String>(Arrays.asList(groupSelectField));
            srcData = srcData.groupBy(fixGroup.toArray(new String[fixGroup.size()])).max("periodbeginqty").max("periodendqty").sum("periodbeginactualcost").sum("periodendactualcost");
        }
        srcData = srcData.groupBy(this.group).reduceGroup((GroupReduceFunction)new CalBalanceReduceFunc(srcData.getRowMeta(), this.period));
        return srcData;
    }

    public static String getDimField() {
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
        bizDataTypeSet.add(BizDataType.DIM);
        Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_balancemodel", bizDataTypeSet);
        Set dimFieldSet = (Set)fieldMap.get(BizDataType.DIM);
        StringBuilder sb = new StringBuilder();
        for (String s : dimFieldSet) {
            sb.append(s).append(",");
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }
}

