/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.formplugin.StockDetailNewRptFormPlugin;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.CombinePeriodReduceFunc;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.DetailBeginConDataReduceFuction;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.StartEndPeriodEmptyReduceFunc;

public class CombinePeriodTransform
implements IDataXTransform {
    private StockDetailRptParam param;
    private String[] group;
    private String[] order;

    public CombinePeriodTransform(String[] group, String[] order, ReportDataCtx ctx) {
        this.param = (StockDetailRptParam)ctx.getParam(StockDetailNewRptFormPlugin.class.getName());
        this.group = group;
        this.order = order;
    }

    public DataSetX doTransform(DataSetX srcData) {
        List<String> ignore = Stream.of("balance", "initbalance").collect(Collectors.toList());
        ArrayList<Field> fields = new ArrayList<Field>(16);
        ArrayList<Long> values = new ArrayList<Long>(16);
        fields.add(new Field("orderline", (DataType)DataType.LongType));
        values.add(0L);
        srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        boolean mulbeginconoutnoindata = this.param.isMulbeginconoutnoindata();
        String mulnojoinsumrange = this.param.getMulnojoinsumrange();
        if (StringUtils.isNotEmpty((String)mulnojoinsumrange) && mulbeginconoutnoindata && (mulnojoinsumrange.contains("A") || mulnojoinsumrange.contains("B"))) {
            DataSetX nomalsrcData = srcData.filter("entryid != null");
            DataSetX startsrcData = srcData.filter("entryid = null and bizentityobject !='cal_costrecord_begin_in' and bizentityobject !='cal_costrecord_begin_out'");
            DataSetX costrecordInData = srcData.filter("bizentityobject ='cal_costrecord_begin_in'");
            costrecordInData = costrecordInData.reduceGroup((GroupReduceFunction)new DetailBeginConDataReduceFuction(costrecordInData.getRowMeta(), this.param));
            DataSetX costrecordOutData = srcData.filter("bizentityobject ='cal_costrecord_begin_out'");
            costrecordOutData = costrecordOutData.reduceGroup((GroupReduceFunction)new DetailBeginConDataReduceFuction(costrecordOutData.getRowMeta(), this.param));
            DataSetX costrecordAllData = costrecordInData.union(costrecordOutData).union(startsrcData);
            srcData = nomalsrcData.union(costrecordAllData);
        }
        srcData = srcData.groupBy(this.group).reduceGroup((GroupReduceFunction)new CombinePeriodReduceFunc(srcData.getRowMeta(), this.order, this.param, ignore));
        srcData = srcData.groupBy(new String[]{"calorg", "costaccount", "material"}).reduceGroup((GroupReduceFunction)new StartEndPeriodEmptyReduceFunc(srcData.getRowMeta(), this.param.getPeriodNumber(), ignore));
        return srcData;
    }
}

