/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.handler;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.CostDiffDetailReduceFunc;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.CostDiffReduceFunc;

public class CostDiffTransform
implements IDataXTransform {
    private String costAdjustName;
    private String[] group;
    private StockDetailRptParam param;

    public CostDiffTransform(String costAdjustName, String[] group, StockDetailRptParam param) {
        this.costAdjustName = costAdjustName;
        this.group = group;
        this.param = param;
    }

    public DataSetX doTransform(DataSetX srcData) {
        ArrayList<Field> fields;
        String[] filedNames = srcData.getRowMeta().getFieldNames();
        HashSet<String> filedNameSet = new HashSet<String>(16);
        for (String filedName : filedNames) {
            filedNameSet.add(filedName);
        }
        if (!filedNameSet.contains("priorityorder")) {
            fields = new ArrayList<Field>(16);
            ArrayList<String> values = new ArrayList<String>(16);
            fields.add(new Field("priorityorder", (DataType)DataType.StringType));
            values.add("0");
            srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        }
        if (!filedNameSet.contains("yearshow")) {
            fields = new ArrayList(16);
            ArrayList<String> values = new ArrayList<String>(16);
            fields.add(new Field("yearshow", (DataType)DataType.StringType));
            values.add("");
            srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        }
        DataSetX costAdjust = null;
        if (!this.param.isShowDetail()) {
            costAdjust = srcData.groupBy(this.group).reduceGroup((GroupReduceFunction)new CostDiffReduceFunc(srcData.getRowMeta(), this.costAdjustName));
        } else {
            DynamicObjectCollection subElements = this.param == null ? null : this.param.getSubElements();
            HashSet<Long> subElementIds = new HashSet<Long>();
            if (subElements != null) {
                for (DynamicObject subElement : subElements) {
                    Long id = subElement.getPkValue() == null ? 0L : Long.parseLong(subElement.getPkValue().toString());
                    if (id == 0L) continue;
                    subElementIds.add(id);
                }
            }
            String amountShowCondition = this.param.getAmountShowCondition();
            String qtyShowCondition = this.param.getQtyShowCondition();
            boolean filter_qty_amt = !StringUtils.isEmpty((String)amountShowCondition) || !StringUtils.isEmpty((String)qtyShowCondition);
            costAdjust = srcData.groupBy(this.group).reduceGroup((GroupReduceFunction)new CostDiffDetailReduceFunc(srcData.getRowMeta(), this.costAdjustName, subElementIds, filter_qty_amt));
        }
        return costAdjust;
    }
}

