/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.FinalDataDetailQtyMapFunc;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.FinalDataPriceMapFunc;
import kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.OnlyShowSumReduceFunc;

public class FinalDataTransform
implements IDataXTransform {
    private StockDetailRptParam param;
    private List<String> waitForDelete;

    public FinalDataTransform(StockDetailRptParam param, List<String> waitForDelete) {
        this.param = param;
        this.waitForDelete = waitForDelete;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.removeFields(this.waitForDelete.toArray(new String[0]));
        HashSet<String> color = new HashSet<String>(16);
        color.add("period_all");
        color.add("period");
        color.add("year_final");
        color.add("total");
        color.add("year_total");
        color.add("period_all_detail");
        ArrayList<Field> fields = new ArrayList<Field>(16);
        ArrayList values = new ArrayList(16);
        fields.add(new Field("linetype", (DataType)DataType.StringType));
        values.add(null);
        srcData = srcData.addFields(fields.toArray(new Field[0]), values.toArray());
        Set<String> ignore = Stream.of("period", "period_all", "year_total", "total", "period_all_detail").collect(Collectors.toSet());
        srcData = srcData.map((MapFunction)new FinalDataPriceMapFunc(srcData.getRowMeta(), color));
        if (this.param.isShowDetail()) {
            srcData = srcData.map((MapFunction)new FinalDataDetailQtyMapFunc(srcData.getRowMeta(), ignore));
        }
        if (this.param.isOnlyshowsumrow()) {
            srcData = srcData.reduceGroup((GroupReduceFunction)new OnlyShowSumReduceFunc(srcData.getRowMeta()));
        }
        return srcData;
    }
}

