/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class CalBalanceReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Integer period;

    public CalBalanceReduceFunc(RowMeta rowMeta, Integer period) {
        this.rowMeta = rowMeta;
        this.period = period;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX rowX : iterable) {
            BigDecimal periodendactualcost = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodendactualcost");
            BigDecimal periodendqty = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "periodendqty");
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodbeginqty", periodendqty);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodbeginactualcost", periodendactualcost);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "year", this.period / 100);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "yearshow", String.valueOf(this.period / 100));
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "month", this.period % 100);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "period", this.period % 100);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "bizentityobject", "balance");
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

