/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class CombinePeriodReduceFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private String[] order;
    private StockDetailRptParam param;
    private List<String> ignore;

    public CombinePeriodReduceFunc(RowMeta rowMeta, String[] order, StockDetailRptParam param, List<String> ignore) {
        this.rowMeta = rowMeta;
        this.order = order;
        this.param = param;
        this.ignore = ignore;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String bizEntityObject;
        Integer year = 0;
        Integer month = 0;
        Integer period = 0;
        Long material = null;
        Long costaccount = null;
        Long calorg = null;
        Long baseunit = null;
        Long currency = null;
        Long materialgroup = 0L;
        String materialmodelnum = null;
        Map<String, int[]> accountYearAndStartPeriod = this.getAccountYearAndStartPeriod(this.param.getAccountAndStartPeriod());
        BigDecimal periodbeginqtySum = BigDecimal.ZERO;
        BigDecimal periodbeginactualcostSum = BigDecimal.ZERO;
        BigDecimal periodendqty_startend = BigDecimal.ZERO;
        BigDecimal periodendamount_startend = BigDecimal.ZERO;
        BigDecimal pre_periodendqty_startend = BigDecimal.ZERO;
        BigDecimal pre_periodendamount_startend = BigDecimal.ZERO;
        BigDecimal sum_periodendqty = BigDecimal.ZERO;
        BigDecimal sum_periodendamt = BigDecimal.ZERO;
        RowX material_detail_pre = null;
        RowX matreial_detail_cur = null;
        DataSet curDataSet = this.createDataSet(iterable, this.rowMeta);
        curDataSet = curDataSet.orderBy(this.order);
        for (Row row : curDataSet.copy()) {
            bizEntityObject = (String)StockDetailUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if (!"balance".equals(bizEntityObject) && !"cal_costrecord_begin_out".equals(bizEntityObject) && !"cal_costrecord_begin_in".equals(bizEntityObject)) continue;
            BigDecimal periodbeginqty = row.getBigDecimal("periodbeginqty");
            BigDecimal periodbeginactualcost = row.getBigDecimal("periodbeginactualcost");
            if ("cal_costrecord_begin_out".equals(bizEntityObject) || "cal_costrecord_begin_in".equals(bizEntityObject)) {
                periodbeginqty = row.getBigDecimal("periodinqtybak");
                periodbeginactualcost = row.getBigDecimal("periodinamountbak");
            }
            periodbeginqtySum = periodbeginqtySum.add(periodbeginqty);
            periodbeginactualcostSum = periodbeginactualcostSum.add(periodbeginactualcost);
            periodendqty_startend = periodendqty_startend.add(periodbeginqty);
            periodendamount_startend = periodendamount_startend.add(periodbeginactualcost);
            pre_periodendqty_startend = periodendqty_startend;
            pre_periodendamount_startend = periodendamount_startend;
            sum_periodendqty = sum_periodendqty.add(periodbeginqty);
            sum_periodendamt = sum_periodendamt.add(periodbeginactualcost);
        }
        BigDecimal preQty = periodbeginqtySum;
        BigDecimal preMoney = periodbeginactualcostSum;
        Long preEntryId = 0L;
        Long curEntryId = 0L;
        Long curId = 0L;
        Long preId = 0L;
        BigDecimal sum_periodinqty = BigDecimal.ZERO;
        BigDecimal sum_periodinamount = BigDecimal.ZERO;
        BigDecimal sum_periodoutqty = BigDecimal.ZERO;
        BigDecimal sum_periodoutamount = BigDecimal.ZERO;
        BigDecimal sum_in_qty = BigDecimal.ZERO;
        BigDecimal sum_out_qty = BigDecimal.ZERO;
        BigDecimal sum_in = BigDecimal.ZERO;
        BigDecimal sum_out = BigDecimal.ZERO;
        Integer cur_index_adj = null;
        Long costElementId = null;
        Long costSubElementId = null;
        Object bizdate = null;
        Object auditdate = null;
        Object bookdate = null;
        Object billno = null;
        boolean bill_in_out = false;
        boolean bill_in_out_amt = false;
        BigDecimal pre_sum_in_qty = BigDecimal.ZERO;
        BigDecimal pre_sum_out_qty = BigDecimal.ZERO;
        BigDecimal pre_sum_in = BigDecimal.ZERO;
        BigDecimal pre_sum_out = BigDecimal.ZERO;
        Integer pre_cur_index_adj = null;
        Long pre_costElementId = null;
        Long pre_costSubElementId = null;
        Object pre_bizdate = null;
        Object pre_auditdate = null;
        Object pre_bookdate = null;
        Object pre_billno = null;
        String pre_bizEntryEntity = null;
        boolean pre_in_out = false;
        boolean pre_in_out_amt = false;
        int order_seq = 0;
        boolean qty_flag = false;
        boolean amount_flag = false;
        boolean inOut = !this.param.isNoshowzeroinout();
        boolean startPeriodLegal = false;
        boolean noshowzeroinout = this.param.isNoshowzeroinout();
        ArrayList<RowX> cur = new ArrayList<RowX>();
        for (Row r : curDataSet) {
            RowX row = this.getRowx(r);
            bizEntityObject = (String)StockDetailUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if ("cal_costrecord_begin_out".equals(bizEntityObject) || "cal_costrecord_begin_in".equals(bizEntityObject)) continue;
            year = StockDetailUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "year").toString());
            month = StockDetailUtils.getRowValue(row, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "period").toString());
            period = StockDetailUtils.getRowValue(row, this.rowMeta, "month") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "month").toString());
            material = StockDetailUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "material").toString());
            costaccount = StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            calorg = StockDetailUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            baseunit = StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit").toString());
            currency = StockDetailUtils.getRowValue(row, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "currency").toString());
            materialgroup = StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup").toString());
            String string = materialmodelnum = StockDetailUtils.getRowValue(row, this.rowMeta, "materialmodelnum") == null ? null : StockDetailUtils.getRowValue(row, this.rowMeta, "materialmodelnum").toString();
            if (!this.ignore.contains(bizEntityObject)) {
                BigDecimal periodinqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinqtybak");
                BigDecimal periodoutqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutqty");
                curEntryId = StockDetailUtils.getRowValue(row, this.rowMeta, "entryid") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "entryid").toString());
                bizdate = StockDetailUtils.getRowValue(row, this.rowMeta, "bizdate");
                auditdate = StockDetailUtils.getRowValue(row, this.rowMeta, "audittime");
                bookdate = StockDetailUtils.getRowValue(row, this.rowMeta, "bookdate");
                cur_index_adj = StockDetailUtils.getRowValue(row, this.rowMeta, "cur_index_adjust") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "cur_index_adjust").toString());
                curId = StockDetailUtils.getRowValue(row, this.rowMeta, "billid") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "billid").toString());
                billno = StockDetailUtils.getRowValue(row, this.rowMeta, "billno");
                if (this.param.isShowDetail() && curEntryId != 0L && curEntryId.compareTo(preEntryId) == 0) {
                    periodinqty = BigDecimal.ZERO;
                    periodoutqty = BigDecimal.ZERO;
                }
                if (this.param.isShowDetail() && curId.compareTo(preId) != 0 && bill_in_out) {
                    bill_in_out = false;
                }
                if (this.param.isShowDetail() && curId.compareTo(preId) != 0 && bill_in_out_amt) {
                    bill_in_out_amt = false;
                }
                BigDecimal periodinamount = BigDecimal.ZERO;
                periodinamount = "cal_stdcostdiffbill".equals(bizEntityObject) ? StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinamount") : StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinamountbak");
                BigDecimal periodoutamount = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutamount");
                if (noshowzeroinout && (BigDecimal.ZERO.compareTo(periodinqty) != 0 || BigDecimal.ZERO.compareTo(periodinamount) != 0 || BigDecimal.ZERO.compareTo(periodoutqty) != 0 || BigDecimal.ZERO.compareTo(periodoutamount) != 0)) {
                    inOut = true;
                } else if (!noshowzeroinout) {
                    inOut = true;
                }
                if (BigDecimal.ZERO.compareTo(periodinqty) != 0 || BigDecimal.ZERO.compareTo(periodinamount) != 0 || BigDecimal.ZERO.compareTo(periodoutqty) != 0 || BigDecimal.ZERO.compareTo(periodoutamount) != 0) {
                    bill_in_out = true;
                }
                if (BigDecimal.ZERO.compareTo(periodinamount) != 0 || BigDecimal.ZERO.compareTo(periodoutamount) != 0) {
                    bill_in_out_amt = true;
                }
                if (this.param.isShowDetail()) {
                    costElementId = StockDetailUtils.getRowValue(row, this.rowMeta, "costelement") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costelement").toString());
                    costSubElementId = StockDetailUtils.getRowValue(row, this.rowMeta, "costsubelement") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costsubelement").toString());
                    Long costsubelement = StockDetailUtils.getRowValue(row, this.rowMeta, "costsubelement") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costsubelement").toString());
                    if (costsubelement == 773175233367685120L) {
                        matreial_detail_cur = row;
                        if (material_detail_pre == null) {
                            material_detail_pre = matreial_detail_cur;
                        }
                    }
                }
                String costAccountStr = costaccount.toString();
                if (accountYearAndStartPeriod != null && accountYearAndStartPeriod.get(costAccountStr) != null) {
                    int[] yearAndPeriod = accountYearAndStartPeriod.get(costAccountStr);
                    int startYear = yearAndPeriod[0];
                    int startPeriod = yearAndPeriod[1];
                    if (year > startYear || year == startYear && startPeriod <= month) {
                        startPeriodLegal = true;
                    }
                }
                BigDecimal curPeriodQty = periodinqty.subtract(periodoutqty);
                BigDecimal curPeriodMoney = periodinamount.subtract(periodoutamount);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodendqty", preQty.add(curPeriodQty));
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodendamount", preMoney.add(curPeriodMoney));
                preQty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodendqty");
                preMoney = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodendamount");
                sum_periodinqty = sum_periodinqty.add(periodinqty);
                sum_periodinamount = sum_periodinamount.add(periodinamount);
                sum_periodoutqty = sum_periodoutqty.add(periodoutqty);
                sum_periodoutamount = sum_periodoutamount.add(periodoutamount);
                sum_in_qty = sum_in_qty.add(periodinqty);
                sum_out_qty = sum_out_qty.add(periodoutqty);
                sum_in = sum_in.add(periodinamount);
                sum_out = sum_out.add(periodoutamount);
                if (this.param.isShowDetail()) {
                    if (BigDecimal.ZERO.compareTo(periodinamount) != 0 || BigDecimal.ZERO.compareTo(periodoutamount) != 0) {
                        cur.add(row);
                    }
                    if (preId != 0L && Long.compare(preId, curId) != 0) {
                        if (!pre_in_out_amt && BigDecimal.ZERO.compareTo(pre_sum_in) == 0 && BigDecimal.ZERO.compareTo(pre_sum_out) == 0 && material_detail_pre != null) {
                            cur.add(material_detail_pre);
                        }
                        if (pre_in_out) {
                            RowX detail_id_row = new RowX(this.rowMeta.getFieldCount());
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "year", year);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "yearshow", String.valueOf(year));
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "material", material);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "month", period);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "period", period);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "costaccount", costaccount);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "calorg", calorg);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "baseunit", baseunit);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "currency", currency);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "materialgroup", materialgroup);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "materialmodelnum", materialmodelnum);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodinqty", pre_sum_in_qty);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodinamount", pre_sum_in);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodoutqty", pre_sum_out_qty);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodoutamount", pre_sum_out);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodendqty", BigDecimal.ZERO.compareTo(pre_sum_in_qty) != 0 || BigDecimal.ZERO.compareTo(pre_sum_out_qty) != 0 ? pre_sum_in_qty.add(pre_periodendqty_startend).subtract(pre_sum_out_qty) : pre_periodendqty_startend);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodendamount", BigDecimal.ZERO.compareTo(pre_sum_in) != 0 || BigDecimal.ZERO.compareTo(pre_sum_out) != 0 ? pre_sum_in.add(pre_periodendamount_startend).subtract(pre_sum_out) : pre_periodendamount_startend);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "bizentityobject", "period_all_detail_" + pre_bizEntryEntity);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "priorityorder_first", "1");
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "priorityorder", "0");
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "billtypename", "periodEndName");
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "bookdate", pre_bookdate);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "bizdate", pre_bizdate);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "audittime", pre_auditdate);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "cur_index_adjust", pre_cur_index_adj);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "entryid", preEntryId);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "costelement", pre_costElementId);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "costsubelement", pre_costSubElementId);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "billid", preId);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "billno", pre_billno);
                            StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "orderline", ++order_seq);
                            cur.add(detail_id_row);
                            sum_in_qty = sum_in_qty.subtract(pre_sum_in_qty);
                            sum_in = sum_in.subtract(pre_sum_in);
                            sum_out_qty = sum_out_qty.subtract(pre_sum_out_qty);
                            sum_out = sum_out.subtract(pre_sum_out);
                            pre_periodendqty_startend = StockDetailUtils.getBigDecimalDefaultOrValue(detail_id_row, this.rowMeta, "periodendqty");
                            pre_periodendamount_startend = StockDetailUtils.getBigDecimalDefaultOrValue(detail_id_row, this.rowMeta, "periodendamount");
                            pre_in_out = false;
                            pre_in_out_amt = false;
                            material_detail_pre = matreial_detail_cur;
                        }
                    }
                    preEntryId = curEntryId;
                    preId = curId;
                    pre_sum_in = sum_in;
                    pre_sum_out = sum_out;
                    pre_sum_in_qty = sum_in_qty;
                    pre_sum_out_qty = sum_out_qty;
                    pre_bookdate = bookdate;
                    pre_auditdate = auditdate;
                    pre_bizdate = bizdate;
                    pre_bizEntryEntity = bizEntityObject;
                    pre_cur_index_adj = cur_index_adj;
                    pre_costSubElementId = costSubElementId;
                    pre_costElementId = costElementId;
                    pre_billno = billno;
                    pre_in_out = pre_in_out || bill_in_out;
                    pre_in_out_amt = pre_in_out_amt || bill_in_out_amt;
                    continue;
                }
                cur.add(row);
                continue;
            }
            if (!"initbalance".equals(bizEntityObject) && !"balance".equals(bizEntityObject)) continue;
            String costAccountStr = costaccount.toString();
            if (accountYearAndStartPeriod == null || accountYearAndStartPeriod.get(costAccountStr) == null) continue;
            Object yearAndPeriod = accountYearAndStartPeriod.get(costAccountStr);
            Object startYear = yearAndPeriod[0];
            Object startPeriod = yearAndPeriod[1];
            if (year <= startYear && (year.intValue() != startYear || startPeriod > month)) continue;
            startPeriodLegal = true;
            if (!"initbalance".equals(bizEntityObject)) continue;
            cur.add(row);
        }
        if (this.param.isShowDetail()) {
            if (!pre_in_out_amt && BigDecimal.ZERO.compareTo(pre_sum_in) == 0 && BigDecimal.ZERO.compareTo(pre_sum_out) == 0 && material_detail_pre != null) {
                cur.add(material_detail_pre);
            }
            if (pre_in_out) {
                RowX detail_id_row = new RowX(this.rowMeta.getFieldCount());
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "year", year);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "yearshow", String.valueOf(year));
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "material", material);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "month", period);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "period", period);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "costaccount", costaccount);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "calorg", calorg);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "baseunit", baseunit);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "currency", currency);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "materialgroup", materialgroup);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "materialmodelnum", materialmodelnum);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodinqty", pre_sum_in_qty);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodinamount", pre_sum_in);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodoutqty", pre_sum_out_qty);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodoutamount", pre_sum_out);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodendqty", BigDecimal.ZERO.compareTo(pre_sum_in_qty) != 0 || BigDecimal.ZERO.compareTo(pre_sum_out_qty) != 0 ? pre_sum_in_qty.add(pre_periodendqty_startend).subtract(pre_sum_out_qty) : pre_periodendqty_startend);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "periodendamount", BigDecimal.ZERO.compareTo(pre_sum_in) != 0 || BigDecimal.ZERO.compareTo(pre_sum_out) != 0 ? pre_sum_in.add(pre_periodendamount_startend).subtract(pre_sum_out) : pre_periodendamount_startend);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "bizentityobject", "period_all_detail_" + pre_bizEntryEntity);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "priorityorder_first", "1");
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "priorityorder", "0");
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "billtypename", "periodEndName");
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "bookdate", pre_bookdate);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "bizdate", pre_bizdate);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "audittime", pre_auditdate);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "cur_index_adjust", pre_cur_index_adj);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "entryid", preEntryId);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "costelement", pre_costElementId);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "costsubelement", pre_costSubElementId);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "billid", preId);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "billno", pre_billno);
                StockDetailUtils.setRowValue(detail_id_row, this.rowMeta, "orderline", ++order_seq);
                cur.add(detail_id_row);
            }
        }
        String amountShowCondition = this.param.getAmountShowCondition();
        String qtyShowCondition = this.param.getQtyShowCondition();
        BigDecimal periodendqty = preQty;
        BigDecimal periodendamount = preMoney;
        if (qtyShowCondition != null && "A".equals(qtyShowCondition) && BigDecimal.ZERO.compareTo(periodendqty) == 0) {
            qty_flag = true;
        } else if (qtyShowCondition != null && "B".equals(qtyShowCondition) && BigDecimal.ZERO.compareTo(periodendqty) != 0) {
            qty_flag = true;
        } else if (qtyShowCondition != null && "C".equals(qtyShowCondition) && BigDecimal.ZERO.compareTo(periodendqty) < 0) {
            qty_flag = true;
        } else if (qtyShowCondition != null && "D".equals(qtyShowCondition) && BigDecimal.ZERO.compareTo(periodendqty) > 0) {
            qty_flag = true;
        }
        if (amountShowCondition != null && "A".equals(amountShowCondition) && BigDecimal.ZERO.compareTo(periodendamount) == 0) {
            amount_flag = true;
        } else if (amountShowCondition != null && "B".equals(amountShowCondition) && BigDecimal.ZERO.compareTo(periodendamount) != 0) {
            amount_flag = true;
        } else if (amountShowCondition != null && "C".equals(amountShowCondition) && BigDecimal.ZERO.compareTo(periodendamount) < 0) {
            amount_flag = true;
        } else if (amountShowCondition != null && "D".equals(amountShowCondition) && BigDecimal.ZERO.compareTo(periodendamount) > 0) {
            amount_flag = true;
        }
        if (amountShowCondition == null || StringUtils.isEmpty((String)amountShowCondition)) {
            amount_flag = true;
        }
        if (qtyShowCondition == null || StringUtils.isEmpty((String)qtyShowCondition)) {
            qty_flag = true;
        }
        for (RowX row : cur) {
            if (!startPeriodLegal || !qty_flag || !amount_flag || !inOut) continue;
            collector.collect(row);
        }
        if (startPeriodLegal && qty_flag && amount_flag && inOut) {
            RowX startPeriodRow = new RowX(this.rowMeta.getFieldCount());
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "year", year);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "yearshow", String.valueOf(year));
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "material", material);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "month", month);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "period", month);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "costaccount", costaccount);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "calorg", calorg);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "baseunit", baseunit);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "currency", currency);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "materialgroup", materialgroup);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "materialmodelnum", materialmodelnum);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodinqty", BigDecimal.ZERO);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodbeginqty", BigDecimal.ZERO);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodinamount", BigDecimal.ZERO);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodendqty", periodendqty_startend);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodendamount", periodendamount_startend);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodbeginactualcost", periodbeginactualcostSum);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodinqtybak", periodbeginqtySum);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "periodinamountbak", periodbeginactualcostSum);
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "billtypename", "startPeriodName");
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "bizentityobject", "period");
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "priorityorder_first", "0");
            StockDetailUtils.setRowValue(startPeriodRow, this.rowMeta, "priorityorder", "0");
            collector.collect(startPeriodRow);
            RowX periodEndRow = new RowX(this.rowMeta.getFieldCount());
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "year", year);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "yearshow", String.valueOf(year));
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "material", material);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "month", period);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "period", period);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "costaccount", costaccount);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "calorg", calorg);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "baseunit", baseunit);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "currency", currency);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "materialgroup", materialgroup);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "materialmodelnum", materialmodelnum);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "periodinqty", sum_periodinqty);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "periodinamount", sum_periodinamount);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "periodoutqty", sum_periodoutqty);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "periodoutamount", sum_periodoutamount);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "periodendqty", BigDecimal.ZERO.compareTo(sum_periodinqty) != 0 || BigDecimal.ZERO.compareTo(sum_periodoutqty) != 0 ? sum_periodinqty.add(periodendqty_startend).subtract(sum_periodoutqty) : sum_periodendqty);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "periodendamount", BigDecimal.ZERO.compareTo(sum_periodinamount) != 0 || BigDecimal.ZERO.compareTo(sum_periodoutamount) != 0 ? sum_periodinamount.add(periodendamount_startend).subtract(sum_periodoutamount) : sum_periodendamt);
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "bizentityobject", "period_all");
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "priorityorder_first", "2");
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "priorityorder", "1");
            StockDetailUtils.setRowValue(periodEndRow, this.rowMeta, "billtypename", "periodEndName");
            collector.collect(periodEndRow);
        }
    }

    public DataSet createDataSet(Iterable<RowX> iterable, RowMeta rowMeta) {
        Algo algo = Algo.create((String)"kd.fi.cal.report.newreport.stockdetailrpt.reducefunction.PeriodEndReduceGroupFunc");
        Iterator<RowX> funcIterator = iterable.iterator();
        return algo.createDataSet((Iterator)new RowXIterator(funcIterator), rowMeta);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }

    private Map<String, int[]> getAccountYearAndStartPeriod(List<String> list) {
        HashMap<String, int[]> accountYearAndStartPeriod = new HashMap<String, int[]>(16);
        for (String accountAndYearAndStartPeriod : list) {
            String[] cur = accountAndYearAndStartPeriod.split("#");
            String costAccount = cur[0];
            int startYear = cur[1] == null || StringUtils.isEmpty((String)cur[1]) ? 0 : Integer.parseInt(cur[1]);
            int startPeriod = cur[2] == null || StringUtils.isEmpty((String)cur[2]) ? 0 : Integer.parseInt(cur[2]);
            accountYearAndStartPeriod.put(costAccount, new int[]{startYear, startPeriod});
        }
        return accountYearAndStartPeriod;
    }

    private static class RowXIterator
    implements Iterator<Object[]>,
    Serializable {
        private static final long serialVersionUID = -8990351274825611328L;
        private Iterator<RowX> iterable;

        RowXIterator(Iterator<RowX> iterable) {
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.iterable.hasNext();
        }

        @Override
        public Object[] next() {
            return this.iterable.next().values();
        }
    }
}

