/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class CombineTotalReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public CombineTotalReduceFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        BigDecimal sum_periodinqty = BigDecimal.ZERO;
        BigDecimal sum_periodinamount = BigDecimal.ZERO;
        BigDecimal sum_periodoutqty = BigDecimal.ZERO;
        BigDecimal sum_periodoutamount = BigDecimal.ZERO;
        BigDecimal sum_yearinqty = BigDecimal.ZERO;
        BigDecimal sum_yearinactualcost = BigDecimal.ZERO;
        BigDecimal sum_yearissueqty = BigDecimal.ZERO;
        BigDecimal sum_yearissueactualcost = BigDecimal.ZERO;
        Integer year = 0;
        Integer month = 0;
        Long material = 0L;
        Long costaccount = 0L;
        Long calorg = 0L;
        Long baseunit = 0L;
        Long currency = 0L;
        Long materialgroup = 0L;
        String materialmodelnum = null;
        for (RowX row : iterable) {
            String bizEntityObject = (String)StockDetailUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            year = StockDetailUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "year").toString());
            month = Math.max(month, StockDetailUtils.getRowValue(row, this.rowMeta, "month") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "month").toString()));
            material = StockDetailUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "material").toString());
            costaccount = StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            calorg = StockDetailUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            baseunit = StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit").toString());
            currency = StockDetailUtils.getRowValue(row, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "currency").toString());
            materialgroup = StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup").toString());
            materialmodelnum = StockDetailUtils.getRowValue(row, this.rowMeta, "materialmodelnum") == null ? null : StockDetailUtils.getRowValue(row, this.rowMeta, "materialmodelnum").toString();
            BigDecimal periodinqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinqty");
            BigDecimal periodinamount = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinamount");
            BigDecimal periodoutqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutqty");
            BigDecimal periodoutamount = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutamount");
            BigDecimal yearinqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "yearinqty");
            BigDecimal yearinactualcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "yearinactualcost");
            BigDecimal yearissueqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "yearissueqty");
            BigDecimal yearissueactualcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "yearissueactualcost");
            if ("period_all".equals(bizEntityObject)) {
                sum_periodinqty = sum_periodinqty.add(periodinqty);
                sum_periodinamount = sum_periodinamount.add(periodinamount);
                sum_periodoutqty = sum_periodoutqty.add(periodoutqty);
                sum_periodoutamount = sum_periodoutamount.add(periodoutamount);
            }
            if ("initbalance".equals(bizEntityObject)) {
                sum_yearinqty = sum_yearinqty.add(yearinqty);
                sum_yearinactualcost = sum_yearinactualcost.add(yearinactualcost);
                sum_yearissueqty = sum_yearissueqty.add(yearissueqty);
                sum_yearissueactualcost = sum_yearissueactualcost.add(yearissueactualcost);
            }
            if ("initbalance".equals(bizEntityObject)) continue;
            collector.collect(row);
        }
        RowX yearTotalRow = new RowX(this.rowMeta.getFieldCount());
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "year", year);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "yearshow", String.valueOf(year));
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "material", material);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "period", month);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "month", month);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "costaccount", costaccount);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "calorg", calorg);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "baseunit", baseunit);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "currency", currency);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "materialgroup", materialgroup);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "materialmodelnum", materialmodelnum);
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "periodinqty", sum_periodinqty.add(sum_yearinqty));
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "periodinamount", sum_periodinamount.add(sum_yearinactualcost));
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "periodoutqty", sum_periodoutqty.add(sum_yearissueqty));
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "periodoutamount", sum_periodoutamount.add(sum_yearissueactualcost));
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "bizentityobject", "year_total");
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "priorityorder", "2");
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "priorityorder_first", "1");
        StockDetailUtils.setRowValue(yearTotalRow, this.rowMeta, "billtypename", "yearTotalName");
        collector.collect(yearTotalRow);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

