/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class CostDiffReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private String billTypeName;

    public CostDiffReduceFunc(RowMeta rowMeta, String name) {
        this.rowMeta = rowMeta;
        this.billTypeName = name;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX rowX : iterable) {
            String year;
            String biztype = StockDetailUtils.getRowValue(rowX, this.rowMeta, "calbilltype") == null ? "" : (String)StockDetailUtils.getRowValue(rowX, this.rowMeta, "calbilltype");
            String accounttype = StockDetailUtils.getRowValue(rowX, this.rowMeta, "accounttype") == null ? "" : (String)StockDetailUtils.getRowValue(rowX, this.rowMeta, "accounttype");
            String createtype = StockDetailUtils.getRowValue(rowX, this.rowMeta, "createtype") == null ? "" : (String)StockDetailUtils.getRowValue(rowX, this.rowMeta, "createtype");
            BigDecimal adjustamt = StockDetailUtils.getBigDecimalDefaultOrValue(rowX, this.rowMeta, "adjustamt");
            Date auditdate = StockDetailUtils.getRowValue(rowX, this.rowMeta, "auditdate") == null ? null : (Date)StockDetailUtils.getRowValue(rowX, this.rowMeta, "auditdate");
            Integer period = StockDetailUtils.getRowValue(rowX, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(rowX, this.rowMeta, "period").toString());
            String string = year = StockDetailUtils.getRowValue(rowX, this.rowMeta, "year") == null ? "" : StockDetailUtils.getRowValue(rowX, this.rowMeta, "year").toString();
            if ("A".equals(biztype)) {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "calbilltype", "IN");
            } else {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "calbilltype", "OUT");
            }
            if ("A".equals(biztype) && "D".equals(accounttype) && !"C1".equals(createtype)) {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinamount", adjustamt);
            } else if ("A".equals(biztype) && !"D".equals(accounttype)) {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinamount", BigDecimal.ZERO);
            } else {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinamount", BigDecimal.ZERO);
            }
            if ("B".equals(biztype) && "D".equals(accounttype) && !"C1".equals(createtype)) {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodoutamount", adjustamt);
            } else if ("B".equals(biztype) && !"D".equals(accounttype)) {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodoutamount", BigDecimal.ZERO);
            } else {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodoutamount", BigDecimal.ZERO);
            }
            if ("A".equals(biztype)) {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinamountbak", adjustamt);
            } else {
                StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinamountbak", BigDecimal.ZERO);
            }
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "periodinqtybak", BigDecimal.ZERO);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "bizentityobject", "cal_stdcostdiffbill");
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "srcobject", "costadjustbill");
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "billtypename", this.billTypeName);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "priorityorder_first", "1");
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "audittime", auditdate);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "month", period);
            StockDetailUtils.setRowValue(rowX, this.rowMeta, "yearshow", year);
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

