/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class CostRecordReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public CostRecordReduceFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX row : iterable) {
            String year;
            String calBillType = StockDetailUtils.getRowValue(row, this.rowMeta, "calbilltype") == null ? "" : (String)StockDetailUtils.getRowValue(row, this.rowMeta, "calbilltype");
            String accountType = StockDetailUtils.getRowValue(row, this.rowMeta, "accounttype") == null ? "" : (String)StockDetailUtils.getRowValue(row, this.rowMeta, "accounttype");
            BigDecimal baseqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "baseqty");
            BigDecimal standardcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "standardcost");
            BigDecimal actualcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "actualcost");
            BigDecimal unitstandardcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "unitstandardcost");
            BigDecimal unitactualcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "unitactualcost");
            Date auditdate = StockDetailUtils.getRowValue(row, this.rowMeta, "auditdate") == null ? null : (Date)StockDetailUtils.getRowValue(row, this.rowMeta, "auditdate");
            Integer period = StockDetailUtils.getRowValue(row, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "period").toString());
            String string = year = StockDetailUtils.getRowValue(row, this.rowMeta, "year") == null ? "" : StockDetailUtils.getRowValue(row, this.rowMeta, "year").toString();
            if ("IN".equals(calBillType)) {
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqty", baseqty);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqtybak", baseqty);
            }
            if ("OUT".equals(calBillType)) {
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodoutqty", baseqty);
            }
            if ("IN".equals(calBillType)) {
                if ("D".equals(accountType)) {
                    StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamount", standardcost);
                    StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamountbak", standardcost);
                } else {
                    StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamount", actualcost);
                    StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamountbak", actualcost);
                }
            } else if ("OUT".equals(calBillType)) {
                if ("D".equals(accountType)) {
                    StockDetailUtils.setRowValue(row, this.rowMeta, "periodoutamount", standardcost);
                } else {
                    StockDetailUtils.setRowValue(row, this.rowMeta, "periodoutamount", actualcost);
                }
            }
            if ("D".equals(accountType)) {
                StockDetailUtils.setRowValue(row, this.rowMeta, "unitprice", unitstandardcost);
            } else {
                StockDetailUtils.setRowValue(row, this.rowMeta, "unitprice", unitactualcost);
            }
            StockDetailUtils.setRowValue(row, this.rowMeta, "bizentityobject", "cal_costrecord_subentity");
            StockDetailUtils.setRowValue(row, this.rowMeta, "srcobject", "costrecord");
            StockDetailUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "1");
            StockDetailUtils.setRowValue(row, this.rowMeta, "audittime", auditdate);
            StockDetailUtils.setRowValue(row, this.rowMeta, "month", period);
            StockDetailUtils.setRowValue(row, this.rowMeta, "yearshow", year);
            collector.collect(row);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

