/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailRptParam;

public class DetailBeginConDataReduceFuction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private StockDetailRptParam reportParam;

    public DetailBeginConDataReduceFuction(RowMeta rowMeta, StockDetailRptParam reportParam) {
        this.rowMeta = rowMeta;
        this.reportParam = reportParam;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        List<Integer> periodNumberList = this.reportParam.getPeriodNumber();
        int yearIndex = this.rowMeta.getFieldIndex("year");
        int monthIndex = this.rowMeta.getFieldIndex("month");
        int periodIndex = this.rowMeta.getFieldIndex("period");
        int yearshowIndex = this.rowMeta.getFieldIndex("yearshow");
        String[] fieldNames = this.rowMeta.getFieldNames();
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            int year = row.getInteger(yearIndex);
            int month = row.getInteger(monthIndex);
            int rowPeriodNumber = year * 100 + month;
            for (Integer periodNumber : periodNumberList) {
                if (rowPeriodNumber >= periodNumber) continue;
                RowX newRow = new RowX(this.rowMeta.getFieldCount());
                for (String fieldName : fieldNames) {
                    if ("month".equals(fieldName)) {
                        newRow.set(monthIndex, (Object)(periodNumber % 100));
                        continue;
                    }
                    if ("year".equals(fieldName)) {
                        newRow.set(yearIndex, (Object)(periodNumber / 100));
                        continue;
                    }
                    if ("yearshow".equals(fieldName)) {
                        newRow.set(yearshowIndex, (Object)String.valueOf(periodNumber / 100));
                        continue;
                    }
                    if ("period".equals(fieldName)) {
                        newRow.set(periodIndex, (Object)(periodNumber % 100));
                        continue;
                    }
                    newRow.set(this.rowMeta.getFieldIndex(fieldName), row.get(this.rowMeta.getFieldIndex(fieldName)));
                }
                collector.collect(newRow);
            }
        }
    }
}

