/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class PeriodTotalSumReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private boolean showtotal;
    private boolean topsumrow;
    private String model;

    public PeriodTotalSumReduceGroupFunc(RowMeta rowMeta, boolean showtotal, boolean topsumrow, String model) {
        this.rowMeta = rowMeta;
        this.showtotal = showtotal;
        this.topsumrow = topsumrow;
        this.model = model;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String bizEntityObject;
        Iterator<RowX> iterator = iterable.iterator();
        Integer month = 0;
        Integer year = 0;
        BigDecimal inTotalQty = BigDecimal.ZERO;
        BigDecimal inTotalAmt = BigDecimal.ZERO;
        BigDecimal outTotalQty = BigDecimal.ZERO;
        BigDecimal outTotalAmt = BigDecimal.ZERO;
        BigDecimal endTotalQty = BigDecimal.ZERO;
        BigDecimal endTotalAmt = BigDecimal.ZERO;
        Long curMaterial = 0L;
        Long curCostaccount = 0L;
        Long curCalorg = 0L;
        Long currency = 0L;
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            bizEntityObject = StockDetailUtils.getStringDefaultOrValue(row, this.rowMeta, "bizentityobject");
            String target = "new".equals(this.model) ? "period_all" : "period_all_copy";
            year = StockDetailUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "year").toString());
            month = StockDetailUtils.getRowValue(row, this.rowMeta, "month") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "month").toString());
            curCostaccount = StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            curCalorg = StockDetailUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            if (target.equals(bizEntityObject)) {
                Long rowMaterial = StockDetailUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "material").toString());
                curMaterial = curMaterial.compareTo(rowMaterial) >= 0 ? curMaterial : rowMaterial;
                BigDecimal periodinqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinqty");
                BigDecimal periodinamount = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinamount");
                BigDecimal periodoutqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutqty");
                BigDecimal periodoutamount = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodoutamount");
                BigDecimal periodendqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodendqty");
                BigDecimal periodendamount = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodendamount");
                inTotalQty = inTotalQty.add(periodinqty);
                inTotalAmt = inTotalAmt.add(periodinamount);
                outTotalQty = outTotalQty.add(periodoutqty);
                outTotalAmt = outTotalAmt.add(periodoutamount);
                endTotalQty = endTotalQty.add(periodendqty);
                endTotalAmt = endTotalAmt.add(periodendamount);
            }
            if (this.showtotal) {
                if (!"total".equals(bizEntityObject)) continue;
                collector.collect(row);
                continue;
            }
            if ("initbalance".equals(bizEntityObject)) continue;
            collector.collect(row);
        }
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "year", year);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "yearshow", String.valueOf(year));
        if (!this.topsumrow) {
            StockDetailUtils.setRowValue(newRow, this.rowMeta, "material", Long.MAX_VALUE);
        } else {
            StockDetailUtils.setRowValue(newRow, this.rowMeta, "material", null);
        }
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "period", month);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "month", month);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "costaccount", curCostaccount);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "calorg", curCalorg);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "baseunit", null);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "currency", currency);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "materialgroup", null);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "materialmodelnum", null);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodinqty", inTotalQty);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodinamount", inTotalAmt);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodoutqty", outTotalQty);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodoutamount", outTotalAmt);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodendqty", endTotalQty);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodendamount", endTotalAmt);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "bizentityobject", "total");
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "priorityorder", "2");
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "priorityorder_first", "4");
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "billtypename", "totalName");
        if (this.showtotal) {
            bizEntityObject = StockDetailUtils.getStringDefaultOrValue(newRow, this.rowMeta, "bizentityobject");
            if ("total".equals(bizEntityObject)) {
                collector.collect(newRow);
            }
        } else {
            collector.collect(newRow);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

