/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class StartEndPeriodEmptyReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private List<String> ignore;
    private List<Integer> periodNumber;

    public StartEndPeriodEmptyReduceFunc(RowMeta rowMeta, List<Integer> periodNumber, List<String> ignore) {
        this.rowMeta = rowMeta;
        this.ignore = ignore;
        this.periodNumber = periodNumber;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX row;
        List curPeriod;
        List<Integer> totalPeriods;
        HashMap<Integer, List<Integer>> cur = new HashMap<Integer, List<Integer>>(16);
        HashMap<Integer, List<Integer>> curEnd = new HashMap<Integer, List<Integer>>(16);
        Map<Integer, List<Integer>> yearAndPeriod = this.copyMap(this.periodNumber);
        Long material = 0L;
        Long calorg = 0L;
        Long costaccount = 0L;
        Long baseunit = 0L;
        Long currency = 0L;
        Long materialgroup = 0L;
        String materialmodelnum = null;
        String bizentityobject = null;
        for (RowX row2 : iterable) {
            List<Integer> list;
            String bizEntityObject = (String)StockDetailUtils.getRowValue(row2, this.rowMeta, "bizentityobject");
            if (this.ignore.contains(bizEntityObject)) {
                collector.collect(row2);
                continue;
            }
            int year = StockDetailUtils.getRowValue(row2, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row2, this.rowMeta, "year").toString());
            Integer curPeriod2 = StockDetailUtils.getRowValue(row2, this.rowMeta, "period") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row2, this.rowMeta, "period").toString());
            material = StockDetailUtils.getRowValue(row2, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row2, this.rowMeta, "material").toString());
            costaccount = StockDetailUtils.getRowValue(row2, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row2, this.rowMeta, "costaccount").toString());
            calorg = StockDetailUtils.getRowValue(row2, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row2, this.rowMeta, "calorg").toString());
            baseunit = StockDetailUtils.getRowValue(row2, this.rowMeta, "baseunit") == null ? null : Long.valueOf(Long.parseLong(StockDetailUtils.getRowValue(row2, this.rowMeta, "baseunit").toString()));
            currency = StockDetailUtils.getRowValue(row2, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row2, this.rowMeta, "currency").toString());
            materialgroup = StockDetailUtils.getRowValue(row2, this.rowMeta, "materialgroup") == null ? null : Long.valueOf(Long.parseLong(StockDetailUtils.getRowValue(row2, this.rowMeta, "materialgroup").toString()));
            materialmodelnum = StockDetailUtils.getRowValue(row2, this.rowMeta, "materialmodelnum") == null ? null : StockDetailUtils.getRowValue(row2, this.rowMeta, "materialmodelnum").toString();
            bizentityobject = StockDetailUtils.getStringDefaultOrValue(row2, this.rowMeta, "bizentityobject");
            if ("period".equals(bizentityobject)) {
                if (!cur.containsKey(year)) {
                    list = new ArrayList<Integer>(16);
                    list.add(curPeriod2);
                    cur.put(year, list);
                } else {
                    list = (List)cur.get(year);
                    if (!list.contains(curPeriod2)) {
                        list.add(curPeriod2);
                    }
                }
            }
            if ("period_all".equals(bizentityobject)) {
                if (!curEnd.containsKey(year)) {
                    list = new ArrayList(16);
                    list.add(curPeriod2);
                    curEnd.put(year, list);
                } else {
                    list = (List)curEnd.get(year);
                    if (!list.contains(curPeriod2)) {
                        list.add(curPeriod2);
                    }
                }
            }
            collector.collect(row2);
        }
        for (Map.Entry<Integer, List<Integer>> entry : yearAndPeriod.entrySet()) {
            Integer year = entry.getKey();
            totalPeriods = entry.getValue();
            curPeriod = (List)cur.get(year);
            if (curPeriod != null) {
                totalPeriods.removeAll(curPeriod);
            }
            if (totalPeriods == null || totalPeriods.isEmpty()) continue;
            for (Integer restPeriod : totalPeriods) {
                row = new RowX(this.rowMeta.getFieldCount());
                StockDetailUtils.setRowValue(row, this.rowMeta, "year", year);
                StockDetailUtils.setRowValue(row, this.rowMeta, "yearshow", String.valueOf(year));
                StockDetailUtils.setRowValue(row, this.rowMeta, "material", material);
                StockDetailUtils.setRowValue(row, this.rowMeta, "materialgroup", materialgroup);
                StockDetailUtils.setRowValue(row, this.rowMeta, "baseunit", baseunit);
                StockDetailUtils.setRowValue(row, this.rowMeta, "currency", currency);
                StockDetailUtils.setRowValue(row, this.rowMeta, "month", restPeriod);
                StockDetailUtils.setRowValue(row, this.rowMeta, "period", restPeriod);
                StockDetailUtils.setRowValue(row, this.rowMeta, "calorg", calorg);
                StockDetailUtils.setRowValue(row, this.rowMeta, "costaccount", costaccount);
                StockDetailUtils.setRowValue(row, this.rowMeta, "materialmodelnum", materialmodelnum);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqty", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodbeginqty", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamount", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodbeginactualcost", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqtybak", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamountbak", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "billtypename", "startPeriodName");
                StockDetailUtils.setRowValue(row, this.rowMeta, "bizentityobject", "period");
                StockDetailUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "0");
                StockDetailUtils.setRowValue(row, this.rowMeta, "priorityorder", "0");
                collector.collect(row);
            }
        }
        for (Map.Entry<Integer, List<Integer>> entry : yearAndPeriod.entrySet()) {
            Integer year = entry.getKey();
            totalPeriods = entry.getValue();
            curPeriod = (List)curEnd.get(year);
            if (curPeriod != null) {
                totalPeriods.removeAll(curPeriod);
            }
            if (totalPeriods == null || totalPeriods.isEmpty()) continue;
            for (Integer restPeriod : totalPeriods) {
                row = new RowX(this.rowMeta.getFieldCount());
                StockDetailUtils.setRowValue(row, this.rowMeta, "year", year);
                StockDetailUtils.setRowValue(row, this.rowMeta, "yearshow", String.valueOf(year));
                StockDetailUtils.setRowValue(row, this.rowMeta, "material", material);
                StockDetailUtils.setRowValue(row, this.rowMeta, "materialgroup", materialgroup);
                StockDetailUtils.setRowValue(row, this.rowMeta, "baseunit", baseunit);
                StockDetailUtils.setRowValue(row, this.rowMeta, "currency", currency);
                StockDetailUtils.setRowValue(row, this.rowMeta, "month", restPeriod);
                StockDetailUtils.setRowValue(row, this.rowMeta, "period", restPeriod);
                StockDetailUtils.setRowValue(row, this.rowMeta, "calorg", calorg);
                StockDetailUtils.setRowValue(row, this.rowMeta, "costaccount", costaccount);
                StockDetailUtils.setRowValue(row, this.rowMeta, "materialmodelnum", materialmodelnum);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqty", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodbeginqty", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamount", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodbeginactualcost", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinqtybak", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "periodinamountbak", BigDecimal.ZERO);
                StockDetailUtils.setRowValue(row, this.rowMeta, "billtypename", "periodEndName");
                StockDetailUtils.setRowValue(row, this.rowMeta, "bizentityobject", "period_all");
                StockDetailUtils.setRowValue(row, this.rowMeta, "priorityorder_first", "1");
                StockDetailUtils.setRowValue(row, this.rowMeta, "priorityorder", "1");
                collector.collect(row);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public Map<Integer, List<Integer>> copyMap(List<Integer> periodNumber) {
        HashMap<Integer, List<Integer>> copy = new HashMap<Integer, List<Integer>>(16);
        for (Integer yearPeriod : periodNumber) {
            List<Integer> list;
            int year = yearPeriod / 100;
            int period = yearPeriod % 100;
            if (!copy.containsKey(year)) {
                list = new ArrayList<Integer>(16);
                list.add(period);
                copy.put(year, list);
                continue;
            }
            list = (List)copy.get(year);
            if (!list.contains(period)) {
                list.add(period);
            }
            copy.put(year, list);
        }
        return copy;
    }
}

