/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdetailrpt.reducefunction;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.cal.report.newreport.stockdetailrpt.StockDetailUtils;

public class StartPeriodCostRecordReduceGroupFunc
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;

    public StartPeriodCostRecordReduceGroupFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        BigDecimal periodbeginqtySum = BigDecimal.ZERO;
        BigDecimal periodbeginactualcostSum = BigDecimal.ZERO;
        Iterator<RowX> iterator = iterable.iterator();
        Integer year = 0;
        Integer month = 0;
        Long material = null;
        Long costaccount = null;
        Long calorg = null;
        Long baseunit = null;
        Long currency = null;
        Long materialgroup = 0L;
        String materialmodelnum = null;
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            year = StockDetailUtils.getRowValue(row, this.rowMeta, "year") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "year").toString());
            month = StockDetailUtils.getRowValue(row, this.rowMeta, "month") == null ? 0 : Integer.parseInt(StockDetailUtils.getRowValue(row, this.rowMeta, "month").toString());
            material = StockDetailUtils.getRowValue(row, this.rowMeta, "material") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "material").toString());
            costaccount = StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "costaccount").toString());
            calorg = StockDetailUtils.getRowValue(row, this.rowMeta, "calorg") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "calorg").toString());
            baseunit = StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "baseunit").toString());
            currency = StockDetailUtils.getRowValue(row, this.rowMeta, "currency") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "currency").toString());
            materialgroup = StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup") == null ? 0L : Long.parseLong(StockDetailUtils.getRowValue(row, this.rowMeta, "materialgroup").toString());
            materialmodelnum = StockDetailUtils.getRowValue(row, this.rowMeta, "materialmodelnum") == null ? null : StockDetailUtils.getRowValue(row, this.rowMeta, "materialmodelnum").toString();
            String bizEntityObject = (String)StockDetailUtils.getRowValue(row, this.rowMeta, "bizentityobject");
            if ("period".equals(bizEntityObject) || "cal_costrecord_begin_in".equals(bizEntityObject) || "cal_costrecord_begin_out".equals(bizEntityObject)) {
                BigDecimal periodbeginqty = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinqtybak");
                BigDecimal periodbeginactualcost = StockDetailUtils.getBigDecimalDefaultOrValue(row, this.rowMeta, "periodinamountbak");
                periodbeginqtySum = periodbeginqtySum.add(periodbeginqty);
                periodbeginactualcostSum = periodbeginactualcostSum.add(periodbeginactualcost);
            }
            if (!"period_all".equals(bizEntityObject)) continue;
            collector.collect(row);
        }
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "year", year);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "material", material);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "month", month);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "period", month);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "costaccount", costaccount);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "calorg", calorg);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "baseunit", baseunit);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "currency", currency);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "materialgroup", materialgroup);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "materialmodelnum", materialmodelnum);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodinqty", BigDecimal.ZERO);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodbeginqty", BigDecimal.ZERO);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodinamount", BigDecimal.ZERO);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodbeginactualcost", BigDecimal.ZERO);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodinqtybak", periodbeginqtySum);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodinamountbak", periodbeginactualcostSum);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "billtypename", "startPeriodName");
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "bizentityobject", "period");
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "priorityorder_first", "0");
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "yearshow", String.valueOf(year));
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodendqty", periodbeginqtySum);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "periodendamount", periodbeginactualcostSum);
        StockDetailUtils.setRowValue(newRow, this.rowMeta, "priorityorder", "0");
        collector.collect(newRow);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

