/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffdetaillrpt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailReportParam;

public class StockDiffDetailBplatReportUtil {
    private static final int BATCH_SIZE = 100000;

    public static boolean hasGroupByName(Set<String> showKeyCols, String keyName) {
        boolean hasGroupName = false;
        if (showKeyCols != null && showKeyCols.size() > 0 && !StringUtils.isBlank((String)keyName) && showKeyCols.contains(keyName)) {
            hasGroupName = true;
        }
        return hasGroupName;
    }

    private static String getPriceSelect(String amount, String qty) {
        return "case when unitprice <> 0  and " + qty + " <> 0 then unitprice when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    public static QFilter getFilter(StockDiffDetailReportParam reportParam) {
        HashSet<Long> set;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        List<Object> auxptyIds = reportParam.getAuxptyIds();
        if (auxptyIds != null) {
            q.and("assist", "in", auxptyIds);
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("calrange", "in", calrangeIds);
        }
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            StockDiffDetailBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_balance");
        } else {
            StockDiffDetailBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_balance");
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = reportParam.getWarehsGroupSet();
        if (!warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("location", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("material", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (reportParam.getMatcategory() != null && reportParam.getMatcategory().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getMatcategory()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("stocktype", "in", set);
        }
        if (reportParam.getFilter_invType() != null && reportParam.getFilter_invType().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invType()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("invtype", "in", set);
        }
        if (reportParam.getFilter_invStatus() != null && reportParam.getFilter_invStatus().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invStatus()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("invstatus", "in", set);
        }
        return q;
    }

    public static QFilter getPeriodBeginBalFilter(StockDiffDetailReportParam reportParam) {
        QFilter q = new QFilter("invtype.isforwardamount", "=", (Object)true);
        q.and("period", "=", (Object)0);
        q.and("year*100+month", ">=", (Object)reportParam.getFilter_startPeriodNumber());
        q.and("year*100+month", "<=", (Object)reportParam.getFilter_endPeriodNumber());
        q.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        QFilter filter = StockDiffDetailBplatReportUtil.getFilter(reportParam);
        q.and(filter);
        return q;
    }

    private static void getOwnerFilter(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName) || "cal_initbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null && filter_owner.size() > 0) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    public static QFilter getCostRecordFilter(StockDiffDetailReportParam reportParam) {
        QFilter q = new QFilter("issplitcreate", "=", (Object)false);
        q.and("bookdate", ">=", (Object)reportParam.getFilter_startDate());
        q.and("bookdate", "<=", (Object)reportParam.getFilter_endDate());
        q.and("isinitbill", "=", (Object)false);
        q.and(QFilter.of((String)"entry.accounttype = 'D' or costaccount.enablestandardcost = '1'", (Object[])new Object[0]));
        q.and("entry.invtype.isforwardamount", "=", (Object)true);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    public static DataSet createDataSet(ReportDataCtx ctx, DataSetX srcData) {
        DataSetOutput resultSet = new DataSetOutput(srcData.getRowMeta());
        srcData.output((Output)resultSet);
        String resultId = resultSet.getId();
        ctx.getCurrentJob().commit(60, TimeUnit.MINUTES);
        return ctx.getCurrentJob().readDataSet(resultId);
    }

    public static String getTempSelects(StockDiffDetailReportParam reportParam) {
        String resultStr = "";
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,");
        select.append("entryid,srcobject,difftype,createtype,billsrctype,currency,baseunit,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,linetype");
        resultStr = StockDiffDetailBplatReportUtil.setShowKeyColStr(reportParam, select);
        return resultStr;
    }

    public static QFilter getInitBillFilter(StockDiffDetailReportParam reportParam) {
        HashSet<Long> set;
        QFilter q = new QFilter("costaccount", "in", reportParam.getCostaccountIdSet());
        q.and("calorg", "in", reportParam.getCalorgIdSet());
        boolean newBalanceFlag = reportParam.isNewBalanceFlag();
        if (reportParam.getOwnerFrom() != null && reportParam.getOwnerFrom().size() == 0) {
            if (newBalanceFlag) {
                StockDiffDetailBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_costadjustbill");
            } else {
                StockDiffDetailBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), null, "cal_initbill");
            }
        } else if (newBalanceFlag) {
            StockDiffDetailBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_costadjustbill");
        } else {
            StockDiffDetailBplatReportUtil.getOwnerFilter(q, reportParam.getOwnertype(), reportParam.getOwnerFrom(), "cal_initbill");
        }
        if (reportParam.getStorageOrg() != null && reportParam.getStorageOrg().size() > 0) {
            HashSet<Long> set2 = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getStorageOrg()) {
                set2.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.storageorgunit", "in", set2);
        }
        Set<Object> warehsGroupSet = new HashSet(8);
        warehsGroupSet = reportParam.getWarehsGroupSet();
        if (!warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", warehsGroupSet);
        }
        if (reportParam.getWarehouse() != null && reportParam.getWarehouse().size() > 0) {
            set = new HashSet<Long>(16);
            for (DynamicObject info : reportParam.getWarehouse()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (reportParam.getLocation() != null && reportParam.getLocation().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getLocation()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.location", "in", set);
        }
        if (reportParam.getMaterialFrom() != null && reportParam.getMaterialFrom().size() > 0) {
            if (reportParam.getMaterialFrom().size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : reportParam.getMaterialFrom()) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (reportParam.getMaterialFrom().size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)reportParam.getMaterialFrom().get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (reportParam.getMaterialTo() != null) {
            q.and("entryentity.material.number", "<=", (Object)reportParam.getMaterialTo().getString("number"));
        }
        if (reportParam.getMulcalrange() != null && reportParam.getMulcalrange().size() > 0) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : reportParam.getMulcalrange()) {
                calrangeIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.calrange", "in", calrangeIds);
        }
        if (reportParam.getFilter_invType() != null && reportParam.getFilter_invType().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invType()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (reportParam.getFilter_invStatus() != null && reportParam.getFilter_invStatus().size() > 0) {
            set = new HashSet(16);
            for (DynamicObject info : reportParam.getFilter_invStatus()) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q.and("entryentity.invstatus", "in", set);
        }
        return q;
    }

    public static String getYearTotalFinalSelects(StockDiffDetailReportParam reportParam) {
        String s = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        int period = 99;
        boolean topSumRow = reportParam.isTopSumRow();
        if (topSumRow) {
            period = 0;
        }
        select.append("year as year,");
        select.append(period);
        select.append(" as period,");
        select.append("null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,currency,baseunit,");
        select.append("null as entryid,null as srcobject,'' as difftype,'' as createtype,'' as billsrctype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,0 as periodenddifferamount,periodendstandardamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject,1 as linetype,calorg,costaccount,material");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColNullStr(reportParam, select);
        return resultStr;
    }

    public static String getPeriodTotalFinalSelects(StockDiffDetailReportParam reportParam) {
        String s = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockDetailRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,period as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,currency,baseunit,");
        select.append("null as entryid,null as srcobject,'' as difftype,'' as createtype,'' as billsrctype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject,1 as linetype,calorg,costaccount,material");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColNullStr(reportParam, select);
        return resultStr;
    }

    public static String getCostRecordDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("case when standardcost = null then 0 else standardcost end as actualcost,null as differ,");
        select.append("case when standardcost = null then 0 else standardcost end as standardcost,");
        select.append("'costrecord' as srcobject");
        return select.toString();
    }

    public static String getCostAdjustDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("0 as actualcost,");
        select.append("case when adjustamt = null then 0 else adjustamt end as differ,0 as standardcost,");
        select.append("'costadjustbill' as srcobject");
        return select.toString();
    }

    public static String getCostDiffbillDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryentity.id as entryid,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,");
        select.append("0 as actualcost,");
        select.append("entryentity.subentryentity.sub_adjustamt as sub_adjustamt,0 as standardcost,entryentity.subentryentity.ddiff_m as ddiff_m,");
        select.append("'stdcostdiffbill' as srcobject");
        return select.toString();
    }

    public static DataSet getDetailByBatch(Set<Object> ids, String entityName, String selectFields) {
        if (ids == null || ids.size() < 1) {
            QFilter qFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            return QueryServiceHelper.queryDataSet((String)StockDiffDetailBplatReportUtil.class.getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        List<Set<Object>> balIdsArray = StockDiffDetailBplatReportUtil.getBatchIdList(ids);
        DataSet detailDataSet = null;
        for (int arrayIndex = 0; arrayIndex < balIdsArray.size(); ++arrayIndex) {
            QFilter qFilter = new QFilter("entryid", "in", balIdsArray.get(arrayIndex));
            DataSet currDetailDataSet = QueryServiceHelper.queryDataSet((String)StockDiffDetailBplatReportUtil.class.getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
            detailDataSet = detailDataSet == null ? currDetailDataSet : detailDataSet.union(currDetailDataSet);
        }
        if (detailDataSet == null) {
            QFilter qFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            return QueryServiceHelper.queryDataSet((String)StockDiffDetailBplatReportUtil.class.getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        return detailDataSet;
    }

    private static List<Set<Object>> getBatchIdList(Set<Object> ids) {
        ArrayList<Set<Object>> balIdsArray = new ArrayList<Set<Object>>(16);
        HashSet<Object> balIds = null;
        long index = 0L;
        for (Object id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Object>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }

    public static String[] getLeftSelects(StockDiffDetailReportParam reportParam) {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,");
        select.append("entryid,srcobject,difftype,createtype,billsrctype,currency,baseunit,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,linetype,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("ordercol_second,ordercol_first");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColStr(reportParam, select);
        return resultStr.split(",");
    }

    public static String[] getRightSelects() {
        StringBuilder select = new StringBuilder();
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        select.append("actualcost,differ,standardcost");
        return select.toString().split(",");
    }

    public static String[] getDiffRightSelects() {
        StringBuilder select = new StringBuilder();
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        select.append("actualcost,sub_adjustamt,ddiff_m,standardcost");
        return select.toString().split(",");
    }

    public static String[] getExtAdjustDetailSelects(StockDiffDetailReportParam reportParam) {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,");
        select.append("entryid,srcobject,difftype,createtype,billsrctype,currency,baseunit,");
        select.append("0 as periodinqty,case when calbilltype = 'IN' AND difftype != 'M' then differ ");
        select.append("when calbilltype = 'IN' AND difftype = 'M' and createtype != 'C1' then differ else 0 end as periodinamount,");
        select.append("case when calbilltype = 'IN' and difftype <> 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'IN' AND difftype = 'M' then differ else 0 end as periodindifferamount,");
        select.append("case when calbilltype = 'IN' and difftype = 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'IN' and difftype = 'M' and createtype = 'C1' then (0-differ)  else 0 end as periodinstandardamount,");
        select.append("0 as periodoutqty, case when calbilltype = 'OUT' AND difftype != 'M' then differ ");
        select.append("when calbilltype = 'OUT' AND difftype = 'M' and createtype != 'C1' then differ else 0 end as periodoutamount,");
        select.append("case when calbilltype = 'OUT' and difftype <> 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'OUT' AND difftype = 'M' then differ else 0 end as periodoutdifferamount,");
        select.append("case when calbilltype = 'OUT' and difftype = 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'OUT' and difftype = 'M' and createtype = 'C1' then (0-differ)  else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,linetype,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColStr(reportParam, select);
        return resultStr.split(",");
    }

    public static String[] getExtCostdiffbillDetailSelects(StockDiffDetailReportParam reportParam) {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,");
        select.append("entryid,srcobject,difftype,createtype,billsrctype,currency,baseunit,");
        select.append("0 as periodinqty,case when calbilltype = 'IN' AND createtype != 'C1' then ddiff_m ");
        select.append("when calbilltype = 'IN' then (sub_adjustamt-ddiff_m) else 0 end as periodinamount,");
        select.append("case when calbilltype = 'IN' then sub_adjustamt else 0 end as periodindifferamount,");
        select.append("case when calbilltype = 'IN' and createtype = 'C1' then (0-ddiff_m)  else 0 end as periodinstandardamount,");
        select.append("0 as periodoutqty, case when calbilltype = 'OUT' AND createtype != 'C1' then ddiff_m ");
        select.append("when calbilltype = 'OUT' then (sub_adjustamt-ddiff_m) else 0 end as periodoutamount,");
        select.append("case when calbilltype = 'OUT' then sub_adjustamt else 0 end as periodoutdifferamount,");
        select.append("case when calbilltype = 'OUT' and createtype = 'C1' then (0-ddiff_m)  else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,linetype,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColStr(reportParam, select);
        return resultStr.split(",");
    }

    public static String[] getExtCostRecordDetailSelects(StockDiffDetailReportParam reportParam) {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,");
        select.append("entryid,srcobject,difftype,createtype,billsrctype,currency,baseunit,");
        select.append("0 as periodinqty,case when calbilltype = 'IN' then actualcost else 0 end as periodinamount,");
        select.append("0 as periodindifferamount,case when calbilltype = 'IN' then standardcost else 0 end as periodinstandardamount,");
        select.append("0 as periodoutqty,case when calbilltype = 'OUT' then actualcost else 0 end as periodoutamount,");
        select.append("0 as periodoutdifferamount,case when calbilltype = 'OUT' then standardcost else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,linetype,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColStr(reportParam, select);
        return resultStr.split(",");
    }

    public static String getFinalSelects(StockDiffDetailReportParam reportParam) {
        StringBuilder select = new StringBuilder();
        select.append("year,case when period = 99 then 0 else period end as period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,");
        select.append(StockDiffDetailBplatReportUtil.getPriceSelect("periodinstandardamount", "periodinqty")).append(" as periodinprice,");
        select.append(StockDiffDetailBplatReportUtil.getPriceSelect("periodoutstandardamount", "periodoutqty")).append(" as periodoutprice,");
        select.append(StockDiffDetailBplatReportUtil.getEndPriceSelect("periodendstandardamount", "periodendqty")).append(" as periodendprice,");
        select.append("currency,baseunit,");
        boolean showdetail = reportParam.isShowdetail();
        boolean onlyShowSumRow = reportParam.isOnlyShowSumRow();
        if (showdetail && !onlyShowSumRow) {
            select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        }
        select.append("billid,bizentityobject,linetype");
        String resultStr = StockDiffDetailBplatReportUtil.setShowKeyColStr(reportParam, select);
        return resultStr;
    }

    private static String getEndPriceSelect(String amount, String qty) {
        return "case when  " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    public static String getCreateTypeStr(String type, List<ValueMapItem> propComboItems, String entityName) {
        String title = ResManager.loadKDString((String)"\u672a\u77e5\u7684\u521b\u5efa\u7c7b\u578b\u3002", (String)"StockDifferDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            if (!type.equals(value)) continue;
            title = valueMapItem.getName().toString();
        }
        String createTypeName = null;
        createTypeName = "cal_stdcostdiffbill".equals(entityName) ? ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355(%1$s)", (String)"StockDifferDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(%1$s)", (String)"StockDifferDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
        return String.format(createTypeName, title);
    }

    private static String setShowKeyColStr(StockDiffDetailReportParam reportParam, StringBuilder select) {
        Set<String> showKeyColSet = reportParam.getShowKeyColSet();
        for (String showKeyCol : showKeyColSet) {
            select.append(",");
            select.append(showKeyCol);
        }
        String selectStr = select.substring(0, select.length());
        return selectStr;
    }

    private static String setShowKeyColNullStr(StockDiffDetailReportParam reportParam, StringBuilder select) {
        Set<String> showKeyColSet = reportParam.getShowKeyColSet();
        Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
        for (String showKeyCol : showKeyColSet) {
            if ("calorg".equals(showKeyCol) || "costaccount".equals(showKeyCol) || "material".equals(showKeyCol)) continue;
            select.append(",");
            IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
            if (dataProperty == null) continue;
            if (dataProperty instanceof BasedataProp) {
                select.append("0 as ");
                select.append(showKeyCol);
                continue;
            }
            if (dataProperty instanceof TextProp) {
                select.append("null as ");
                select.append(showKeyCol);
                continue;
            }
            if ("ownertype".equals(showKeyCol)) {
                select.append("null as ");
                select.append(showKeyCol);
                continue;
            }
            select.append("0 as ");
            select.append(showKeyCol);
        }
        String selectStr = select.substring(0, select.length());
        return selectStr;
    }

    public static void setNewDifffieldsValues(StockDiffDetailReportParam reportParam, List<Field> newDifffields, List<Object> fieldsDiffValues) {
        Set<String> showKeyColSet = reportParam.getShowKeyColSet();
        Map<String, IDataEntityProperty> dataTypeMap = reportParam.getDataEntityPropertyMap();
        for (String showKeyCol : showKeyColSet) {
            IDataEntityProperty dataProperty = dataTypeMap.get(showKeyCol);
            if (dataProperty == null) continue;
            if (dataProperty instanceof BasedataProp) {
                newDifffields.add(new Field(showKeyCol, (DataType)DataType.LongType));
                fieldsDiffValues.add(0L);
                continue;
            }
            if (dataProperty instanceof TextProp) {
                newDifffields.add(new Field(showKeyCol, (DataType)DataType.StringType));
                fieldsDiffValues.add(null);
                continue;
            }
            if ("ownertype".equals(showKeyCol)) {
                newDifffields.add(new Field(showKeyCol, (DataType)DataType.StringType));
                fieldsDiffValues.add(null);
                continue;
            }
            newDifffields.add(new Field(showKeyCol, (DataType)DataType.LongType));
            fieldsDiffValues.add(0L);
        }
    }
}

