/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffdetaillrpt.dataxtransform;

import java.util.ArrayList;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailBplatReportUtil;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailReportParam;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.function.DetailChangeYearAndMonthMapFuction;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.function.DiffDetailBeforePeriodGroupFunction;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.function.PeriodinAmountBakMapFuction;

public class GetPeriodBeginDataxTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private StockDiffDetailReportParam reportparam;

    public GetPeriodBeginDataxTransform(ReportDataCtx ctx, StockDiffDetailReportParam reportparam) {
        this.ctx = ctx;
        this.reportparam = reportparam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        ArrayList<Field> newfields = new ArrayList<Field>(16);
        ArrayList<Integer> fieldsValues = new ArrayList<Integer>(16);
        newfields.add(new Field("ordercol_second", (DataType)DataType.IntegerType));
        fieldsValues.add(1);
        newfields.add(new Field("month", (DataType)DataType.IntegerType));
        fieldsValues.add(0);
        newfields.add(new Field("linetype", (DataType)DataType.IntegerType));
        fieldsValues.add(0);
        srcData = srcData.addFields(newfields.toArray(new Field[0]), fieldsValues.toArray());
        DataSetX zeroPeriodBeginDataSet = srcData.groupBy(new String[]{"calorg", "costaccount", "material", "year", "period"}).reduceGroup((GroupReduceFunction)new DiffDetailBeforePeriodGroupFunction(srcData.getRowMeta(), this.reportparam));
        String[] fields = zeroPeriodBeginDataSet.getRowMeta().getFieldNames();
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            if ("linetype".equals(field)) continue;
            sb.append(field);
            sb.append(",");
        }
        String ssStr = sb.substring(0, sb.length() - 1);
        zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.groupBy(ssStr.split(",")).max("linetype");
        zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.map((MapFunction)new DetailChangeYearAndMonthMapFuction(zeroPeriodBeginDataSet.getRowMeta()));
        DataSetX balancedataSet = null;
        String selectfields = "year,month,calorg,costaccount,material,periodbeginqty,periodbeginactualcost,periodbegincostdiff,beginstandardcost";
        boolean isNewBalance = this.reportparam.isNewBalanceFlag();
        if (isNewBalance) {
            String moreFields = ",year,month,calorg,baseqty as periodbeginqty,actualcost as periodbeginactualcost,costdiff as periodbegincostdiff,standardcost as beginstandardcost";
            String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",year,month,calorg").split(",");
            OrmInput balinput = new OrmInput(this.getClass().getName(), "cal_bal", select, new QFilter[]{StockDiffDetailBplatReportUtil.getPeriodBeginBalFilter(this.reportparam)});
            balancedataSet = this.ctx.getCurrentJob().fromInput((Input)balinput);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            balancedataSet = balCompress ? balancedataSet.groupBy(groupSelect).sum("periodbeginqty").sum("periodbeginactualcost").sum("periodbegincostdiff").sum("beginstandardcost") : balancedataSet.groupBy(groupSelect).max("periodbeginqty").sum("periodbeginactualcost").sum("periodbegincostdiff").sum("beginstandardcost");
            balancedataSet = balancedataSet.select(selectfields.split(","));
        } else {
            OrmInput balanceinput = new OrmInput(this.getClass().getName(), "cal_balance", selectfields, new QFilter[]{StockDiffDetailBplatReportUtil.getPeriodBeginBalFilter(this.reportparam)});
            balancedataSet = this.ctx.getCurrentJob().fromInput((Input)balanceinput);
        }
        balancedataSet = balancedataSet.groupBy(new String[]{"year", "month", "calorg", "costaccount", "material"}).sum("periodbeginqty").sum("periodbeginactualcost").sum("periodbegincostdiff").sum("beginstandardcost");
        zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.leftJoin(balancedataSet).on("year", "year").on("month", "month").on("calorg", "calorg").on("costaccount", "costaccount").on("material", "material").select(zeroPeriodBeginDataSet.getRowMeta().getFieldNames(), new String[]{"periodbeginqty", "periodbeginactualcost", "periodbegincostdiff", "beginstandardcost"});
        zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.map((MapFunction)new PeriodinAmountBakMapFuction(zeroPeriodBeginDataSet.getRowMeta(), this.reportparam));
        zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.select(srcData.getRowMeta().getFieldNames());
        srcData = srcData.union(zeroPeriodBeginDataSet);
        return srcData;
    }
}

