/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffdetaillrpt.dataxtransform;

import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailBplatReportUtil;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailReportParam;

public class UnionTotalDataxTransform
implements IDataTransform {
    public StockDiffDetailReportParam reportParam;

    public UnionTotalDataxTransform(StockDiffDetailReportParam reportParam) {
        this.reportParam = reportParam;
    }

    public DataSet doTransform(DataSet dataSet) {
        DataSet periodTotalDataSet = dataSet.copy().groupBy(new String[]{"year", "period", "calorg", "costaccount", "material", "currency", "baseunit"}).sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").minP("ordercol_second", "periodendqty").minP("ordercol_second", "periodendamount").minP("ordercol_second", "periodenddifferamount").minP("ordercol_second", "periodendstandardamount").finish().select(new String[]{"year", "period", "calorg", "costaccount", "material", "currency", "baseunit", "periodinqty", "periodinamount", "periodindifferamount", "periodinstandardamount", "periodoutqty", "periodoutamount", "periodoutdifferamount", "periodoutstandardamount", "periodendqty+periodinqty-periodoutqty as periodendqty", "periodendamount+periodinamount-periodoutamount as periodendamount", "periodenddifferamount+periodindifferamount-periodoutdifferamount as periodenddifferamount", "periodendstandardamount+periodinstandardamount-periodoutstandardamount as periodendstandardamount"}).select(StockDiffDetailBplatReportUtil.getPeriodTotalFinalSelects(this.reportParam).split(","));
        String validPeriod = null;
        StringBuilder sBuilder = new StringBuilder(16);
        for (Row row : periodTotalDataSet.copy()) {
            int year = row.getInteger("year");
            int period = row.getInteger("period");
            int periodNumber = year * 100 + period;
            sBuilder.append(periodNumber).append(",");
        }
        validPeriod = sBuilder.toString();
        if (!StringUtils.isEmpty((String)validPeriod)) {
            validPeriod = validPeriod.substring(0, validPeriod.length() - 1);
            dataSet = dataSet.filter("year*100+period in (" + validPeriod + ")");
        } else {
            dataSet = dataSet.filter("1 <> 1");
        }
        DataSet yearTotalDataSet = periodTotalDataSet.copy().groupBy(new String[]{"year", "calorg", "costaccount", "material", "currency", "baseunit"}).sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").finish();
        DataSet yearInOutDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)"calorg,costaccount,entryentity.material as material,period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost + entryentity.yearincostdiff as yearinactualcost,entryentity.yearincostdiff as yearincostdiff,case when costaccount.enablestandardcost = '1' or  entryentity.accounttype = 'D' then entryentity.yearincost else 0 end as yearinstandradcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost + entryentity.yearissuecostdiff as yearissueactualcost,entryentity.yearissuecostdiff as yearissuecostdiff,case when costaccount.enablestandardcost = '1' or  entryentity.accounttype = 'D' then entryentity.yearissuecost else 0 end as yearissuestandradcost", (QFilter[])new QFilter[]{StockDiffDetailBplatReportUtil.getInitBillFilter(this.reportParam)}, null).groupBy(new String[]{"year", "calorg", "costaccount", "material"}).sum("yearinqty").sum("yearinactualcost").sum("yearincostdiff").sum("yearinstandradcost").sum("yearissueqty").sum("yearissueactualcost").sum("yearissuecostdiff").sum("yearissuestandradcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(yearInOutDataSet, JoinType.LEFT).on("year", "year").on("calorg", "calorg").on("costaccount", "costaccount").on("material", "material").select(new String[]{"year", "currency", "baseunit", "calorg", "costaccount", "material", "0 as periodendqty", "0 as periodendamount", "0 as periodenddifferamount", "0 as periodendstandardamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodindifferamount+yearincostdiff as periodindifferamount", "periodinstandardamount+yearinstandradcost as periodinstandardamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "periodoutdifferamount+yearissuecostdiff as periodoutdifferamount", "periodoutstandardamount+yearissuestandradcost as periodoutstandardamount"}).finish().select(StockDiffDetailBplatReportUtil.getYearTotalFinalSelects(this.reportParam).split(","));
        dataSet = dataSet.addField("0", "ordercol_first");
        periodTotalDataSet = periodTotalDataSet.addField("1", "ordercol_second").addField("1", "ordercol_first").select(dataSet.getRowMeta().getFieldNames());
        yearTotalDataSet = yearTotalDataSet.addField("1", "ordercol_second").addField("2", "ordercol_first").select(dataSet.getRowMeta().getFieldNames());
        dataSet = dataSet.union(periodTotalDataSet).union(yearTotalDataSet);
        return dataSet;
    }
}

