/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.newreport.stockdiffdetaillrpt.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.base.CalAuxptyFilterHelper;
import kd.fi.cal.report.newreport.stockdiffdetaillrpt.StockDiffDetailReportParam;

public class StockDiffDetailReportBplatForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private MaterialCategoryHelper materialCategoryHelper = null;

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("mulcostaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("mulcalrange".equals(key)) {
            this.beforeF7Select4MulCalrange(e);
        } else if ("mulstorageorg".equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if ("mulwarehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e, this.getModel());
        } else if ("mullocation".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key) || "materialto".equals(key)) {
            DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            for (DynamicObject calOrg : calOrgList) {
                orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            ReportF7Helper.beforeF7Select4NewMaterial((BeforeF7SelectEvent)e, orgIds);
        } else if ("mulowner".equals(key)) {
            this.beforeF7Select4Mulcalorgowner(e);
        } else if ("startperiod".equals(key) || "endperiod".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("auxproperty".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxProperty(showParameter);
        } else if ("auxdetailbd".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxpropertydetail(showParameter, (IFormView)this.getView());
        }
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        HashSet<Long> periodIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> periodCostAccountMap = new HashMap<Long, DynamicObject>(16);
        if (costaccountList == null || costaccountList.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"StockGatherReportBplatForm_3", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        for (DynamicObject costaccount : costaccountList) {
            DynamicObject startPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (startPeriod == null) continue;
            periodIdSet.add(startPeriod.getLong("id"));
            periodCostAccountMap.put(startPeriod.getLong("id"), costaccount.getDynamicObject("fbasedataid"));
        }
        if (periodIdSet.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        Long periodId = (Long)Collections.min(periodIdSet);
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)((DynamicObject)periodCostAccountMap.get(periodId)));
        if (q == null) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6838\u7b97\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccountList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        if (costaccountList == null || costaccountList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccount.getDynamicObject("fbasedataid").getLong("id"));
            if (ownerIsArray == null || ownerIsArray.length <= 0) continue;
            for (Long id : ownerIsArray) {
                ownerIdSet.add(id);
            }
        }
        if (ownerIdSet.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", ownerIdSet);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        HashSet warehouseIdSet = new HashSet();
        for (DynamicObject calOrg : calOrgList) {
            Set set = ReportF7Helper.beforeF7Warehouse((DynamicObjectCollection)storageOrgs, (Object)calOrg.getDynamicObject("fbasedataid"));
            warehouseIdSet.addAll(set);
        }
        if (warehouseIdSet.size() > 0) {
            q = new QFilter("id", "in", warehouseIdSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet storageOrgSet = new HashSet();
            for (DynamicObject calOrg : calOrgList) {
                Long calOrgId = calOrg.getDynamicObject("fbasedataid").getLong("id");
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrgId);
                storageOrgSet.addAll(list);
            }
            q = new QFilter("id", "in", storageOrgSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4MulCalrange(BeforeF7SelectEvent e) {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costaccounts != null && costaccounts.size() > 0) {
            HashSet<Long> costaccountIdSet = new HashSet<Long>();
            for (DynamicObject costaccount : costaccounts) {
                costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("costaccount", "in", costaccountIdSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("calorg", "in", calOrgIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        long userId = UserServiceHelper.getCurrentUserId();
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_stockdif_gather_newpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList report = (ReportList)this.getControl("reportlistap");
        this.addF7Listener(this, "mulcalorg", "mulcostaccount", "mulcalrange", "mulstorageorg", "mulwarehouse", "mullocation", "startperiod", "endperiod", "mulmaterial", "mulowner", "materialto", "auxproperty", "auxdetailbd");
        CalAuxptyFilterHelper.addAuxdetailbasebdRegister((Object)this);
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    StockDiffDetailReportBplatForm.this.hyperLinkBillNoClick(evt);
                }
            }
        });
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("mulcostaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("mulmaterial".equals(key)) {
            ReportUtil.mulMaterialChanged((IDataModel)this.getModel(), (IFormView)this.getView());
        } else if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("mulstorageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("mulwarehouse".equals(key)) {
            this.warehouseChanged();
        } else if ("startperiod".equals(key)) {
            this.startPeriodChanged();
        } else if ("endperiod".equals(key)) {
            this.endPeriodChanged();
        } else if ("ownertypehead".equals(key)) {
            ReportUtil.ownertypeChanged((IDataModel)this.getModel(), (IReportView)this.getView());
        } else if ("mulwarehsgroup".equals(key)) {
            ReportUtil.warehsgroupChanged((IDataModel)this.getModel());
        } else if ("auxproperty".equals(key)) {
            CalAuxptyFilterHelper.handleAuxpropertyChangeEvent(newValue, rowIndex, (IFormView)this.getView());
        } else if ("auxdetailbasebd".equals(key)) {
            CalAuxptyFilterHelper.handleAuxdetailBdChagneEvent(newValue, rowIndex, this.getView().getModel());
        }
    }

    private void calOrgChanged() {
        this.getModel().setValue("mulstorageorg", null);
        this.getModel().setValue("mulowner", null);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList == null || calOrgList.size() == 0) {
            this.getModel().setValue("mulcostaccount", null);
        } else {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set costAccountIds = OrgHelper.getCostAccountIdsByCalOrg(calOrgIds);
            if (costAccountIds != null && costAccountIds.size() > 0) {
                this.getModel().setValue("mulcostaccount", (Object)costAccountIds.toArray());
            } else {
                this.getModel().setValue("mulcostaccount", null);
            }
            this.getModel().setValue("ownertypehead", (Object)"bos_org");
        }
    }

    private void endPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("startperiod", endPeriod.getPkValue());
        }
    }

    private void startPeriodChanged() {
        int endPeriodNumber;
        int startPeriodNumber;
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (startPeriod != null && endPeriod != null && (startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber")) > (endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber"))) {
            this.getModel().setValue("endperiod", startPeriod.getPkValue());
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("mullocation", null);
    }

    private void storageOrgChanged() {
        this.getModel().setValue("mulwarehouse", null);
    }

    private void costAccountChanged() {
        DynamicObjectCollection costaccounts = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcostaccount");
        this.getModel().setValue("mulcalrange", null);
        this.getModel().setValue("mulowner", null);
        this.getModel().setValue("mulsupplierownerfrom", null);
        this.getModel().setValue("mulcustomerownerfrom", null);
        if (costaccounts == null || costaccounts.size() == 0) {
            this.getModel().setValue("localcurrency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        HashSet<Object> calpolicyIdSet = new HashSet<Object>();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccounts) {
            calpolicyIdSet.add(costaccount.getDynamicObject("fbasedataid").getDynamicObject("calpolicy").getPkValue());
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicyIdSet)});
        this.getModel().setValue("localcurrency", ((DynamicObject)coll.get(0)).get("currency"));
        Map periods = PeriodHelper.getCurrentPeriods(costaccountIdSet);
        HashSet<Long> periodIds = new HashSet<Long>();
        for (Long costAccountId : costaccountIdSet) {
            DynamicObject period = (DynamicObject)periods.get(costAccountId);
            if (period == null) continue;
            periodIds.add(period.getLong("id"));
        }
        if (periodIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long maxid = (Long)Collections.max(periodIds);
        Long minid = (Long)Collections.min(periodIds);
        this.getModel().setValue("startperiod", (Object)(periodIds.size() == 0 ? null : minid));
        this.getModel().setValue("endperiod", (Object)(periodIds.size() == 0 ? null : maxid));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection calOrgList = dataEntity.getDynamicObjectCollection("mulcalorg");
        DynamicObjectCollection costaccountList = dataEntity.getDynamicObjectCollection("mulcostaccount");
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (calOrgList == null || calOrgList.size() == 0 || costaccountList == null || costaccountList.size() == 0 || startPeriod == null || endPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"StockGatherRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        for (DynamicObject costaccount : costaccountList) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Object> calpolicyPeriodtype = new HashSet<Object>();
        DynamicObjectCollection costAccountInfoS = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype,calpolicy.currency,calpolicy.currency.amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        Long defaultCurrency = 0L;
        HashMap<Integer, Long> currencyAmtprecisionMap = new HashMap<Integer, Long>(16);
        HashSet<Integer> amtprecisionSet = new HashSet<Integer>(16);
        for (DynamicObject calpolicy : costAccountInfoS) {
            calpolicyPeriodtype.add(calpolicy.get("calpolicy.periodtype"));
            Long currencyId = calpolicy.getLong("calpolicy.currency");
            int amtprecision = calpolicy.getInt("calpolicy.currency.amtprecision");
            amtprecisionSet.add(amtprecision);
            currencyAmtprecisionMap.put(amtprecision, currencyId);
        }
        if (!amtprecisionSet.isEmpty()) {
            defaultCurrency = (Long)currencyAmtprecisionMap.get(Collections.max(amtprecisionSet));
        }
        if (calpolicyPeriodtype.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\u3002", (String)"StockGatherRptFormPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        if (endPeriodNumber < startPeriodNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"StockGatherRptFormPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        boolean topsumrow = dataEntity.getBoolean("topsumrow");
        StockDiffDetailReportParam stockGatherSumReportParam = this.buildStockDiffDetailReportParam(dataEntity, costAccountInfoS, queryParam);
        stockGatherSumReportParam.setDefaultCurrency(defaultCurrency);
        stockGatherSumReportParam.setOnlyShowSumRow(onlyshowsumrow);
        stockGatherSumReportParam.setTopSumRow(topsumrow);
        this.getQueryParam().getCustomParam().put(StockDiffDetailReportParam.class.getName(), stockGatherSumReportParam);
        return super.verifyQuery(queryParam);
    }

    private StockDiffDetailReportParam buildStockDiffDetailReportParam(DynamicObject dataEntity, DynamicObjectCollection costAccountInfoS, ReportQueryParam queryParam) {
        StockDiffDetailReportParam stockDiffDetailReportParam = new StockDiffDetailReportParam();
        HashSet<Long> costaccountIdSet = new HashSet<Long>();
        DynamicObjectCollection costaccounts = dataEntity.getDynamicObjectCollection("mulcostaccount");
        for (DynamicObject costaccount : costaccounts) {
            costaccountIdSet.add(costaccount.getDynamicObject("fbasedataid").getLong("id"));
        }
        stockDiffDetailReportParam.setCostaccountIdSet(costaccountIdSet);
        DynamicObject startperiod = dataEntity.getDynamicObject("startperiod");
        stockDiffDetailReportParam.setStartPeriod(startperiod);
        HashSet<Long> startPeriodIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> startPeriodIdMap = new HashMap<Long, DynamicObject>(16);
        for (Long costaccountId : costaccountIdSet) {
            DynamicObject startPeriod = PeriodHelper.getStartPeriod((Long)costaccountId);
            if (startPeriod == null) continue;
            Long startPeriodId = startPeriod.getLong("id");
            startPeriodIdMap.put(startPeriodId, startPeriod);
            startPeriodIds.add(startPeriodId);
        }
        startperiod = (DynamicObject)startPeriodIdMap.get(Collections.min(startPeriodIds));
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        stockDiffDetailReportParam.setEndPeriod(endperiod);
        int filter_startPeriodNumber = startperiod.getInt("periodyear") * 100 + startperiod.getInt("periodnumber");
        stockDiffDetailReportParam.setFilter_startPeriodNumber(filter_startPeriodNumber);
        int filter_endPeriodNumber = endperiod.getInt("periodyear") * 100 + endperiod.getInt("periodnumber");
        stockDiffDetailReportParam.setFilter_endPeriodNumber(filter_endPeriodNumber);
        ArrayList<Integer> periodNumberList = new ArrayList<Integer>(16);
        DynamicObjectCollection costAccountInfos = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "in", costaccountIdSet)});
        HashSet<Object> periodtypeSet = new HashSet<Object>(16);
        for (DynamicObject costAccount : costAccountInfos) {
            periodtypeSet.add(costAccount.get("calpolicy.periodtype"));
        }
        QFilter q = new QFilter("periodtype", "in", periodtypeSet);
        q.and(new QFilter("isadjustperiod", "=", (Object)false));
        q.and("periodyear*100+periodnumber", ">=", (Object)filter_startPeriodNumber);
        q.and("periodyear*100+periodnumber", "<=", (Object)filter_endPeriodNumber);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            periodNumberList.add(periodNumber);
        }
        stockDiffDetailReportParam.setPeriodNumberList(periodNumberList);
        Date filter_startDate = startperiod.getDate("begindate");
        Date filter_endDate = endperiod.getDate("enddate");
        stockDiffDetailReportParam.setFilter_endDate(filter_endDate);
        stockDiffDetailReportParam.setFilter_startDate(filter_startDate);
        String billno = dataEntity.getString("fbillno");
        stockDiffDetailReportParam.setBillno(billno);
        boolean noShowZeroInOut = dataEntity.getBoolean("noshowzeroinout");
        stockDiffDetailReportParam.setNoShowZeroInOut(noShowZeroInOut);
        boolean onlyshowsumrow = dataEntity.getBoolean("onlyshowsumrow");
        stockDiffDetailReportParam.setOnlyShowSumRow(onlyshowsumrow);
        boolean topsumrow = dataEntity.getBoolean("topsumrow");
        stockDiffDetailReportParam.setTopSumRow(topsumrow);
        boolean showdetail = dataEntity.getBoolean("showdetail");
        stockDiffDetailReportParam.setShowdetail(showdetail);
        Long currencyId = dataEntity.getDynamicObject("localcurrency").getLong("id");
        stockDiffDetailReportParam.setCurrencyId(currencyId);
        DynamicObjectCollection filter_ownerFrom = null;
        String filter_ownertype = dataEntity.getString("ownertypehead");
        stockDiffDetailReportParam.setOwnertype(filter_ownertype);
        if (StringUtils.isNotEmpty((String)filter_ownertype)) {
            if ("bos_org".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(filter_ownertype)) {
                filter_ownerFrom = dataEntity.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        stockDiffDetailReportParam.setOwnerFrom(filter_ownerFrom);
        DynamicObjectCollection filter_mulcalrange = dataEntity.getDynamicObjectCollection("mulcalrange");
        stockDiffDetailReportParam.setMulcalrange(filter_mulcalrange);
        DynamicObjectCollection filter_storageOrg = dataEntity.getDynamicObjectCollection("mulstorageorg");
        stockDiffDetailReportParam.setStorageOrg(filter_storageOrg);
        DynamicObjectCollection filter_warehouse = dataEntity.getDynamicObjectCollection("mulwarehouse");
        stockDiffDetailReportParam.setWarehouse(filter_warehouse);
        DynamicObjectCollection filter_location = dataEntity.getDynamicObjectCollection("mullocation");
        stockDiffDetailReportParam.setLocation(filter_location);
        DynamicObjectCollection filter_materialFrom = dataEntity.getDynamicObjectCollection("mulmaterial");
        stockDiffDetailReportParam.setMaterialFrom(filter_materialFrom);
        DynamicObject filter_materialTo = dataEntity.getDynamicObject("materialto");
        stockDiffDetailReportParam.setMaterialTo(filter_materialTo);
        DynamicObjectCollection mulwarehsgroup = dataEntity.getDynamicObjectCollection("mulwarehsgroup");
        stockDiffDetailReportParam.setMulwarehsgroup(mulwarehsgroup);
        DynamicObjectCollection mulmatcategory = dataEntity.getDynamicObjectCollection("mulmatcategory");
        stockDiffDetailReportParam.setMatcategory(mulmatcategory);
        stockDiffDetailReportParam.setNewBalanceFlag(this.isNewBalance);
        DynamicObjectCollection calOrgList = this.getModel().getDataEntity(true).getDynamicObjectCollection("mulcalorg");
        if (calOrgList != null && calOrgList.size() > 0) {
            HashSet<Long> calOrgIds = new HashSet<Long>();
            for (DynamicObject calOrg : calOrgList) {
                calOrgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            stockDiffDetailReportParam.setCalorgIdSet(calOrgIds);
        }
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection categorys = filterInfo.getDynamicObjectCollection("mulmatcategory");
        stockDiffDetailReportParam.setCategorys(categorys);
        DynamicObjectCollection costaccountCol = filterInfo.getDynamicObjectCollection("mulcostaccount");
        stockDiffDetailReportParam.setCostaccountCol(costaccountCol);
        DynamicObjectCollection owner = filterInfo.getDynamicObjectCollection("mulowner");
        stockDiffDetailReportParam.setOwner(owner);
        DynamicObjectCollection filter_invType = dataEntity.getDynamicObjectCollection("mulinvtype");
        stockDiffDetailReportParam.setFilter_invType(filter_invType);
        DynamicObjectCollection filter_invStatus = dataEntity.getDynamicObjectCollection("mulinvstatus");
        stockDiffDetailReportParam.setFilter_invStatus(filter_invStatus);
        Set<Long> materialIdSet = this.getBalMaterialDycs(queryParam);
        stockDiffDetailReportParam.setMaterialIdSet(materialIdSet);
        Set warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        stockDiffDetailReportParam.setWarehsGroupSet(warehsGroupSet);
        DynamicObjectCollection filter_billType = dataEntity.getDynamicObjectCollection("mulbilltype");
        stockDiffDetailReportParam.setFilter_billType(filter_billType);
        List<Object> auxptyIds = CalAuxptyFilterHelper.getAuxptyIds(this.getView().getModel());
        stockDiffDetailReportParam.setAuxptyIds(auxptyIds);
        return stockDiffDetailReportParam;
    }

    public DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = UserServiceHelper.getCurrentUserId();
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_stockdif_det_newrpt");
        if (calOrgId != null && calOrgId != 0L) {
            Long[] ids = new Long[]{calOrgId};
            this.getModel().setValue("mulcalorg", (Object)ids);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("mulcostaccount", (Object)new Long[]{costAccount.getLong("id")});
                this.costAccountChanged();
            }
        }
        ReportUtil.setOwnerVisible((IDataModel)this.getModel(), (IReportView)this.getView(), (String)"mulcalorg");
        this.resetFilterGrid();
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getView().getModel(), (IFormView)this.getView());
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(StockDiffDetailReportParam.class.getName());
        if (!StringUtils.isEmpty((String)openParamStr)) {
            StockDiffDetailReportParam stockDiffDetailReportParam = (StockDiffDetailReportParam)SerializationUtils.fromJsonString((String)openParamStr, StockDiffDetailReportParam.class);
            if (stockDiffDetailReportParam != null && stockDiffDetailReportParam.getCondition() != null) {
                filterGrid.SetValue(stockDiffDetailReportParam.getCondition());
            }
            if (null == stockDiffDetailReportParam) {
                CalAuxptyFilterHelper.setAuxEntryEnable(this.getView().getModel(), (IFormView)this.getView());
            } else {
                CalAuxptyFilterHelper.buildDiffDetailAuxptyEntry(stockDiffDetailReportParam, this.getModel(), this.getView());
            }
        }
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("calorg");
        removedPros.add("material");
        removedPros.add("owner");
        removedPros.add("ownertype");
        removedPros.add("storageorgunit");
        removedPros.add("warehouse");
        removedPros.add("location");
        removedPros.add("year");
        removedPros.add("month");
        removedPros.add("period");
        removedPros.add("endperiod");
        removedPros.add("baseunit");
        removedPros.add("currency");
        removedPros.add("calrange");
        removedPros.add("accounttype");
        removedPros.add("assist");
        removedPros.add("warehsgroup");
        removedPros.add("materialcategory");
        removedPros.add("bizdate");
        removedPros.add("mversion");
        removedPros.add("costelementname");
        removedPros.add("costelementnumber");
        removedPros.add("costsubelementnumer");
        removedPros.add("costsubelementname");
        removedPros.add("bookdate");
        removedPros.add("audittime");
        removedPros.add("isvoucher");
        removedPros.add("billno");
        removedPros.add("calbilltype");
        removedPros.add("billtype");
        removedPros.add("baseqty");
        removedPros.add("entryid");
        removedPros.add("srcobject");
        removedPros.add("difftype");
        removedPros.add("createtype");
        removedPros.add("billsrctype");
        removedPros.add("adjustamt");
        removedPros.add("biztype");
        removedPros.add("diff_m");
        removedPros.add("enablestandardcost");
        removedPros.add("standardcost");
        removedPros.add("unitstandardcost");
        removedPros.add("unitactualcost");
        removedPros.add("unitprice");
        removedPros.add("billid");
        removedPros.add("bizentityobject");
        return !removedPros.contains(split[0]) && !"tracknumber.name".equals(fieldName) && !"tracknumber.description".equals(fieldName);
    }

    private Set<Long> getBalMaterialDycs(ReportQueryParam queryParam) {
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        DynamicObject startPeriod = queryParam.getFilter().getDynamicObject("startperiod");
        DynamicObject endPeriod = queryParam.getFilter().getDynamicObject("endperiod");
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        int endPeriodNumber = endPeriod.getInt("periodyear") * 100 + endPeriod.getInt("periodnumber");
        QFilter inOutFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (queryParam.getFilter().getBoolean("noshowzeroinout")) {
            DynamicObjectCollection inOutMaterials;
            inOutFilter.and("period", ">=", (Object)startPeriodNumber);
            inOutFilter.and("period", "<=", (Object)endPeriodNumber);
            inOutFilter.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
            if (this.isNewBalance) {
                inOutFilter.and(QFilter.of((String)"baseqty_in <> 0 or standardcost_in <> 0 or costdiff_in <> 0 or baseqty_out <> 0 or standardcost_out <> 0 or costdiff_out <> 0", (Object[])new Object[0]));
                inOutMaterials = QueryServiceHelper.query((String)"cal_bal", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number");
            } else {
                inOutFilter.and(QFilter.of((String)"periodinqty <> 0 or periodinstandardcost <> 0 or periodincostdiff <> 0 or periodissueqty <> 0 or periodissuestandardcost <> 0 or periodissuecostdiff <> 0", (Object[])new Object[0]));
                inOutMaterials = QueryServiceHelper.query((String)"cal_balance", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number");
            }
            for (DynamicObject material : inOutMaterials) {
                Long materialId = material.getLong("material.id");
                materialIdSet.add(materialId);
            }
            return materialIdSet;
        }
        DynamicObjectCollection materials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{this.getBalFilter(queryParam)});
        HashSet<Long> materialIds = new HashSet<Long>(materials.size());
        for (DynamicObject material : materials) {
            Long materialId = material.getLong("material.id");
            materialIds.add(materialId);
        }
        inOutFilter.and("period", ">=", (Object)startPeriodNumber);
        inOutFilter.and("period", "<=", (Object)endPeriodNumber);
        inOutFilter.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        if (this.isNewBalance) {
            inOutFilter.and(QFilter.of((String)"baseqty_in <> 0 or standardcost_in <> 0 or costdiff_in <> 0 or baseqty_out <> 0 or standardcost_out <> 0 or costdiff_out <> 0", (Object[])new Object[0]));
        } else {
            inOutFilter.and(QFilter.of((String)"periodinqty <> 0 or periodissueqty <> 0 or periodinstandardcost <> 0 or periodincostdiff <> 0 or periodissuestandardcost <> 0 or periodissuecostdiff <> 0", (Object[])new Object[0]));
        }
        DynamicObjectCollection inOutMaterials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number") : QueryServiceHelper.query((String)"cal_balance", (String)"material.id,material.number", (QFilter[])new QFilter[]{this.getBalFilter(queryParam), inOutFilter}, (String)"material.number");
        HashSet<Long> inOutMaterialIds = new HashSet<Long>(inOutMaterials.size());
        for (DynamicObject inOutMaterial : inOutMaterials) {
            Long materialId = inOutMaterial.getLong("material.id");
            inOutMaterialIds.add(materialId);
        }
        HashSet noInOutMaterials = new HashSet(materialIds);
        noInOutMaterials.removeAll(inOutMaterialIds);
        QFilter q1 = new QFilter("material.id", "in", noInOutMaterials);
        q1.and("period", "<", (Object)startPeriodNumber);
        q1.and("endperiod", ">=", (Object)startPeriodNumber);
        q1.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        if (this.isNewBalance) {
            q1.and(QFilter.of((String)"baseqty_bal <> 0 or standardcost_bal <> 0 or costdiff_bal <> 0", (Object[])new Object[0]));
        } else {
            q1.and(QFilter.of((String)"periodendqty <> 0 or periodendstandardcost <> 0 or periodendcostdiff <> 0", (Object[])new Object[0]));
        }
        QFilter q2 = QFilter.of((String)"period != 0", (Object[])new Object[0]).and("period", "<=", (Object)startPeriodNumber).and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        q2.or(QFilter.of((String)"period = 0", (Object[])new Object[0]).and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0])));
        DynamicObjectCollection hasBeginMaterials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{q1, q2, this.getBalFilter(queryParam)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{q1, q2, this.getBalFilter(queryParam)});
        HashSet<Long> hasBeginMaterialIds = new HashSet<Long>();
        for (DynamicObject hasBeginMaterial : hasBeginMaterials) {
            Long materialId = hasBeginMaterial.getLong("material.id");
            hasBeginMaterialIds.add(materialId);
        }
        hasBeginMaterialIds.addAll(inOutMaterialIds);
        DynamicObjectCollection resultMaterials = this.isNewBalance ? QueryServiceHelper.query((String)"cal_bal", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("material.id", "in", hasBeginMaterialIds)}) : QueryServiceHelper.query((String)"cal_balance", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("material.id", "in", hasBeginMaterialIds)});
        for (DynamicObject material : resultMaterials) {
            Long materialId = material.getLong("material.id");
            materialIdSet.add(materialId);
        }
        return materialIdSet;
    }

    private QFilter getBalFilter(ReportQueryParam queryParam) {
        HashSet<Object> set;
        DynamicObjectCollection costAccounts = queryParam.getFilter().getDynamicObjectCollection("mulcostaccount");
        String filter_ownertype = queryParam.getFilter().getString("ownertypehead");
        DynamicObjectCollection filter_owner = null;
        if (StringUtils.isNotEmpty((String)filter_ownertype)) {
            if ("bos_org".equals(filter_ownertype)) {
                filter_owner = queryParam.getFilter().getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(filter_ownertype)) {
                filter_owner = queryParam.getFilter().getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(filter_ownertype)) {
                filter_owner = queryParam.getFilter().getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        DynamicObjectCollection filter_calrange = queryParam.getFilter().getDynamicObjectCollection("mulcalrange");
        DynamicObjectCollection filter_storageOrg = queryParam.getFilter().getDynamicObjectCollection("mulstorageorg");
        DynamicObjectCollection filter_warehouse = queryParam.getFilter().getDynamicObjectCollection("mulwarehouse");
        DynamicObjectCollection filter_location = queryParam.getFilter().getDynamicObjectCollection("mullocation");
        DynamicObjectCollection filter_materialFrom = queryParam.getFilter().getDynamicObjectCollection("mulmaterial");
        DynamicObject filter_materialTo = queryParam.getFilter().getDynamicObject("materialto");
        DynamicObjectCollection filter_mulMaterialCategory = queryParam.getFilter().getDynamicObjectCollection("mulmatcategory");
        String[] filter_lot = null;
        String lotnumber = queryParam.getFilter().getString("lotnumber");
        if (StringUtils.isNotEmpty((String)lotnumber)) {
            filter_lot = lotnumber.split(";");
        }
        DynamicObjectCollection filter_project = queryParam.getFilter().getDynamicObjectCollection("mulproject");
        DynamicObjectCollection filter_invType = queryParam.getFilter().getDynamicObjectCollection("mulinvtype");
        DynamicObjectCollection filter_invStatus = queryParam.getFilter().getDynamicObjectCollection("mulinvstatus");
        HashSet<Object> costAccountIdSet = new HashSet<Object>(16);
        for (DynamicObject costAccount : costAccounts) {
            costAccountIdSet.add(costAccount.getPkValue());
        }
        QFilter q = new QFilter("costaccount", "in", costAccountIdSet);
        ReportUtil.getOwnerFilter((QFilter)q, (String)filter_ownertype, (DynamicObjectCollection)filter_owner, (String)"cal_balance");
        if (filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        if (filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (filter_lot != null) {
            q.and("lot", "in", (Object)filter_lot);
        }
        if (filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (filter_materialFrom != null) {
            if (filter_materialFrom.size() > 1) {
                set = new HashSet();
                for (DynamicObject info : filter_materialFrom) {
                    set.add(info.getPkValue());
                }
                q.and("material", "in", set);
            } else {
                q.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (filter_materialTo != null) {
            q.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        if (filter_mulMaterialCategory != null && filter_mulMaterialCategory.size() > 0) {
            Set<Long> materialIds = this.getMaterialCategoryToMaterialIds(costAccounts, filter_owner, filter_mulMaterialCategory);
            q.and("material", "in", materialIds);
        }
        q.and("invtype.isforwardamount", "=", (Object)true);
        return q;
    }

    private Set<Long> getMaterialCategoryToMaterialIds(DynamicObjectCollection costacconts, DynamicObjectCollection filter_owner, DynamicObjectCollection filter_mulMaterialCategory) {
        if (this.materialCategoryHelper == null) {
            this.materialCategoryHelper = new MaterialCategoryHelper(costacconts, filter_owner, filter_mulMaterialCategory);
        }
        return this.materialCategoryHelper.getMaterialIds();
    }

    private void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject row = evt.getRowData();
        String billId = row.getString("billid");
        if ("0".equals(billId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bizEntityObject = row.getString("bizentityobject");
        showParameter.setPkId((Object)billId);
        showParameter.setFormId(bizEntityObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getModel(), (IFormView)this.getView());
    }

    public void click(EventObject evt) {
        CalAuxptyFilterHelper.click(evt, (IFormPlugin)this, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        CalAuxptyFilterHelper.closedCallBack(evt, this.getView());
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        CalAuxptyFilterHelper.loadOtherEntryFilter(scheme, this.getView().getModel(), this.getView());
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        CalAuxptyFilterHelper.saveEntryFilter((IFormView)this.getView(), "auxentry");
    }
}

